/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.group;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="debtor_group")
@AccessType(value="property")
public class DebtorGroup
extends PersistentDisplayableObject
implements Saveable {
    public static final Props Properties = new Props();
    private PersistentList<AbstractDebtor> debtors;
    private String type;
    private String systemState;
    private int sequence;

    public DebtorGroup() {
        this.debtors = this.createList(DebtorGroup.Properties.DEBTORS);
        this.type = "CUSTOMER";
        this.systemState = "ACTIVE";
        this.sequence = 0;
        this.setLabel("");
    }

    public DebtorGroup(String newLabel, AbstractDebtor debtor) {
        this(newLabel, debtor.getType());
    }

    public DebtorGroup(String newLabel, String newType) {
        this.debtors = this.createList(DebtorGroup.Properties.DEBTORS);
        this.type = "CUSTOMER";
        this.systemState = "ACTIVE";
        this.sequence = 0;
        this.setLabel(newLabel);
        this.setType(newType);
    }

    public void setType(String newType) {
        this.type = newType;
    }

    @Transient
    public boolean isActive() {
        return this.systemState.equalsIgnoreCase("ACTIVE");
    }

    @OneToMany(mappedBy="group", targetEntity=AbstractDebtor.class)
    public List<AbstractDebtor> getDebtors() {
        return this.debtors.getUnmodifiable();
    }

    public static List getCustomerAccountGroups() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CUSTOMER");
        list.add("SIMPLE");
        return DebtorGroup.getGroupsForDebtorTypes(list);
    }

    public static List getGroupsForDebtorType(AbstractDebtor debtorClass) {
        ArrayList<String> list = new ArrayList<String>();
        if (debtorClass instanceof CustomerDebtor || debtorClass instanceof SimpleDebtor) {
            return DebtorGroup.getCustomerAccountGroups();
        }
        list.add(debtorClass.getType());
        return DebtorGroup.getGroupsForDebtorTypes(list);
    }

    public static List<DebtorGroup> getRoomGroups() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ROOM");
        return DebtorGroup.getGroupsForDebtorTypes(list);
    }

    public static List<DebtorGroup> getAllDebtorGroups() {
        return DebtorGroup.getGroupsForDebtorTypes(null);
    }

    public static int getAllDebtorGroupCount() {
        ObjectQuery query = Query.count(DebtorGroup.class).active(DebtorGroup.class);
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
        if (result != null) {
            return ((Number)result[0][0]).intValue();
        }
        return 0;
    }

    public static DebtorGroup getRoomGroupWithName(String roomName) {
        String param = roomName;
        DebtorGroup group = PersistenceManager.getObject(DebtorGroup.class, Query.select(DebtorGroup.class).equals(DebtorGroup.Properties.TYPE, "ROOM").equalsParam(DebtorGroup.Properties.LABEL).toString(), param);
        if (group == null) {
            group = new DebtorGroup(roomName, "ROOM");
            group.save();
        } else if (!group.isActive()) {
            group.systemState = "ACTIVE";
        }
        return group;
    }

    public static DebtorGroup getMatchingGroup(DebtorGroup groupToMatch) {
        DebtorGroup group = PersistenceManager.getObject(DebtorGroup.class, Query.select(DebtorGroup.class).equals(DebtorGroup.Properties.TYPE, groupToMatch.type).equals(DebtorGroup.Properties.LABEL, groupToMatch.getName()).toString(), null);
        return group;
    }

    private static List<DebtorGroup> getGroupsForDebtorTypes(List<String> typeList) {
        List<DebtorGroup> returnList;
        ObjectQuery query = Query.select(DebtorGroup.class).active(DebtorGroup.class).orderBy(DebtorGroup.Properties.SEQUENCE).orderBy(DebtorGroup.Properties.LABEL);
        if (typeList != null && typeList.size() > 0) {
            query.wherePropertyIn(DebtorGroup.Properties.TYPE, typeList);
        }
        if ((returnList = PersistenceManager.getObjectList(DebtorGroup.class, query.toString(), new Object[0])) == null) {
            return new ArrayList<DebtorGroup>();
        }
        return returnList;
    }

    public void setDebtors(List<AbstractDebtor> newDebtors) {
        this.debtors = this.debtors.clone();
        this.debtors.set(newDebtors);
    }

    @Transient
    public String getName() {
        return this.getLabel();
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    @Override
    public void delete() {
        if (!this.debtors.isEmpty()) {
            boolean hasActive;
            AbstractDebtor debtor;
            Iterator<AbstractDebtor> debtorIt = this.getDebtors().iterator();
            for (hasActive = false; debtorIt.hasNext() && !hasActive; hasActive |= debtor.isActive()) {
                debtor = debtorIt.next();
            }
            if (hasActive) {
                throw new IllegalStateException("Cannot delete debtor groups that have active debtors");
            }
        }
        this.systemState = "DELETED";
        if (this.isPersistent()) {
            this.save();
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Column(name="system_state")
    protected String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property TYPE;
        public PropertiedObject.Property DEBTORS;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property SEQUENCE;
    }
}

