/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.implementation;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CUSTOMER")
@AccessType(value="property")
public class CustomerDebtor
extends AbstractDebtor
implements CustomerDebtorInterface {
    public static final String TYPE = "CUSTOMER";
    private Reference<Customer> customer;
    private int terms;
    public static final Props Properties = new Props();

    public static final List getRequiredCustomerFields() {
        return Customer.REQUIRE_FIRST_NAME;
    }

    public CustomerDebtor() {
        this.customer = this.createReference(CustomerDebtor.Properties.CUSTOMER);
        this.terms = 0;
    }

    public CustomerDebtor(Customer newCustomer) {
        super(newCustomer.getLastName());
        this.customer = this.createReference(CustomerDebtor.Properties.CUSTOMER);
        this.terms = 0;
        this.setCustomer(newCustomer);
    }

    public CustomerDebtor(Customer newCustomer, AbstractDebtor existingDebtor) {
        super(existingDebtor);
        this.customer = this.createReference(CustomerDebtor.Properties.CUSTOMER);
        this.terms = 0;
        if (!(existingDebtor instanceof SimpleDebtor) && !(existingDebtor instanceof CustomerDebtor)) {
            throw new IllegalArgumentException("cannot cast from debtor type: " + existingDebtor.getClass() + " to customer debtor");
        }
        this.setCustomer(newCustomer);
    }

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    @Override
    public void setCustomer(Customer newCustomer) {
        this.customer.set(newCustomer);
    }

    @Override
    public AbstractDebtor removeCustomer() {
        this.customer.set(null);
        return new SimpleDebtor(this);
    }

    @Override
    public boolean hasCustomer() {
        return true;
    }

    @Override
    @Transient
    public AbstractDebtor getDebtor() {
        return this;
    }

    @Override
    public boolean hasTerms() {
        return true;
    }

    @Override
    public void setTermsValue(AbstractDebtor.Terms newTerms) {
        this.terms = newTerms.getDays();
    }

    @Override
    @Transient
    public AbstractDebtor.Terms getTermsValue() {
        return new AbstractDebtor.Terms(this.terms);
    }

    @Column(name="terms")
    protected int getTerms() {
        return this.terms;
    }

    protected void setTerms(int terms) {
        this.terms = terms;
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/images/customerSingle.png";
    }

    @Override
    public void save() {
        this.customer.saveChild();
        super.save();
    }

    public static class Props
    extends AbstractDebtor.Props {
        public PropertiedObject.Property CUSTOMER;
        public PropertiedObject.Property TERMS;
    }
}

