/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.implementation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.sales.Account;
import ordermate.integration.PropertyIntegrationUtils;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="ROOM")
@AccessType(value="property")
public class RoomAccount
extends AbstractDebtor {
    public static final String TYPE = "ROOM";
    private String extID = "";
    private String roomNumber = "";
    private Integer folio;
    private Integer roomAccountID;
    public static final Props Properties = new Props();

    public RoomAccount() {
    }

    public RoomAccount(String newExtID, Integer newroomAccountID, String newDebtorName, DebtorGroup roomGroup, int newFolio, Price limit, Price balance) {
        super(newDebtorName);
        this.extID = newExtID;
        this.roomAccountID = newroomAccountID;
        this.roomNumber = roomGroup.getLabel();
        this.folio = new Integer(newFolio);
        this.setCreditLimit(limit.subtract(balance));
        this.setGroup(roomGroup);
    }

    public RoomAccount(String newExtID, String newDebtorName, DebtorGroup roomGroup, int newFolio, Price limit, Price balance) {
        super(newDebtorName);
        this.extID = newExtID;
        this.roomNumber = roomGroup.getLabel();
        this.folio = new Integer(newFolio);
        this.setCreditLimit(limit.subtract(balance));
        this.setGroup(roomGroup);
    }

    @Override
    @Transient
    public boolean isCreditLimited() {
        return true;
    }

    @Override
    public DebtorSale addSale(Account sale, FinanceTransactionContext context, String invoiceNote) {
        DebtorSale debtorSale = super.addSale(sale, context, invoiceNote);
        this.notifyPropertyIntegrator(debtorSale);
        return debtorSale;
    }

    private void notifyPropertyIntegrator(DebtorSale sale) {
        PropertyIntegrationUtils.transactionsCreated(sale);
    }

    @Override
    public void delete() {
        DebtorGroup group = this.getGroup();
        boolean deleteGroup = group.getDebtors().size() <= 1;
        super.delete();
        group = (DebtorGroup)PersistenceManager.reacquire(group);
        if (deleteGroup) {
            group.delete();
        }
    }

    @Column(name="extID")
    public String getExtID() {
        return this.extID;
    }

    @Column(name="roomNumber")
    public String getRoomNumber() {
        if (this.roomNumber == null) {
            return "";
        }
        return this.roomNumber;
    }

    @Column(name="folio")
    public int getFolio() {
        if (this.folio != null) {
            return this.folio;
        }
        return 0;
    }

    public void setFolio(int newFolio) {
        this.folio = new Integer(newFolio);
    }

    @Override
    @Transient
    public String getType() {
        return TYPE;
    }

    @Transient
    public String getName() {
        return "Room account " + this.getLabel().trim();
    }

    public static RoomAccount getAccountByFolio(int folio) {
        return PersistenceManager.getObject(RoomAccount.class, Query.select(RoomAccount.class).active(RoomAccount.class).equalsParam(RoomAccount.Properties.FOLIO).toString(), new Integer(folio));
    }

    public static List getAccountsByRoom(String room) {
        return PersistenceManager.getObjectList(RoomAccount.class, Query.select(RoomAccount.class).active(RoomAccount.class).equalsParam(DebtorGroup.Properties.LABEL).linkUsing(AbstractDebtor.Properties.GROUP).toString(), room);
    }

    public static RoomAccount createRoomAccount(String extID, Integer roomAccountID, String debtorName, String room, int folio, Price limit, Price balance) {
        DebtorGroup roomGroup = DebtorGroup.getRoomGroupWithName(room);
        RoomAccount roomAcc = new RoomAccount(extID, roomAccountID, debtorName, roomGroup, folio, limit, balance);
        roomAcc.save();
        return roomAcc;
    }

    public static RoomAccount createRoomAccount(String extID, String debtorName, String room, int folio, Price limit, Price balance) {
        DebtorGroup roomGroup = DebtorGroup.getRoomGroupWithName(room);
        RoomAccount roomAcc = new RoomAccount(extID, debtorName, roomGroup, folio, limit, balance);
        roomAcc.save();
        return roomAcc;
    }

    @Override
    @Transient
    public String getIcon() {
        return "/waitermate/images/delivery.png";
    }

    protected void setRoomNumber(String roomNum) {
        this.roomNumber = roomNum;
    }

    public void setExtID(String externalID) {
        this.extID = externalID;
    }

    public static RoomAccount getDebtorByNameAndExtID(String name, String extID) {
        ObjectQuery select = Query.select(AbstractDebtor.class).active(AbstractDebtor.class).equals(RoomAccount.Properties.LABEL, name).equals(RoomAccount.Properties.EXT_ID, extID).limit(1);
        return PersistenceManager.getObject(RoomAccount.class, select.toString(), null);
    }

    @Column(name="roomaccount_ID")
    public Integer getRoomAccountID() {
        return this.roomAccountID;
    }

    public void setRoomAccountID(Integer roomAccountID) {
        this.roomAccountID = roomAccountID;
    }

    public static class Props
    extends AbstractDebtor.Props {
        public PropertiedObject.Property EXT_ID;
        public PropertiedObject.Property ROOM_NUMBER;
        public PropertiedObject.Property FOLIO;
        public PropertiedObject.Property ROOMACCOUNTID;
    }
}

