/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.matchingstrategy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.matchingstrategy.AbstractCustomerToDebtorMatchingStrategy;
import ordermate.database.finance.debtors.matchingstrategy.CustomerToDebtorMatchingStrategy;
import ordermate.database.sales.Customer;

public class CustomerToDebtorMatchingStrategyFactory {
    private static final Map<CustomerToDebtorMatchingStrategy, AbstractCustomerToDebtorMatchingStrategy> strategyCache = new HashMap<CustomerToDebtorMatchingStrategy, AbstractCustomerToDebtorMatchingStrategy>(){
        {
            this.put(CustomerToDebtorMatchingStrategy.Ask, new AbstractCustomerToDebtorMatchingStrategy(){

                @Override
                public AbstractDebtor matchDebtor(List<AbstractDebtor> allDebtors) {
                    return null;
                }
            });
            this.put(CustomerToDebtorMatchingStrategy.Single_Customer, new AbstractCustomerToDebtorMatchingStrategy(){

                @Override
                public AbstractDebtor matchDebtor(List<AbstractDebtor> allDebtors) {
                    CustomerDebtor toReturn = null;
                    for (AbstractDebtor debtor : allDebtors) {
                        CustomerDebtor custDebtor;
                        if (!(debtor instanceof CustomerDebtor) || (custDebtor = (CustomerDebtor)debtor).getCustomer() == null || !custDebtor.getCustomer().equals(this.getCustomer())) continue;
                        if (toReturn == null) {
                            toReturn = custDebtor;
                            continue;
                        }
                        toReturn = null;
                        break;
                    }
                    return toReturn;
                }

                public Customer getCustomer() {
                    return this.getController().getCustomer();
                }
            });
        }
    };

    public static AbstractCustomerToDebtorMatchingStrategy getStrategy(CustomerToDebtorMatchingStrategy customerToDebtorMatchingStrategy) {
        return strategyCache.get((Object)customerToDebtorMatchingStrategy);
    }
}

