/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.transactions;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="debtor_payment")
@AccessType(value="property")
public class DebtorPayment
extends PersistentObject
implements SaveableChild,
Displayable {
    private static final DateTimeUtils.ThreadLocalDateFormat format = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yy hh:mm"));
    private Price amount = new Price(0.0, 0.01);
    private Date date = new Date();
    private boolean refunded = false;
    private Reference<AbstractDebtor> debtor;
    private Reference<DebtorSale> sale;
    private Reference<FinanceTransaction> financeTransaction;
    private Reference<Shift> shift;
    private Reference<Terminal> terminal;
    private Reference<CashDrawer> cashDrawer;
    public static final Props Properties = new Props();

    public DebtorPayment() {
        this.debtor = this.createReference(DebtorPayment.Properties.DEBTOR);
        this.sale = this.createReference(DebtorPayment.Properties.SALE);
        this.financeTransaction = this.createReference(DebtorPayment.Properties.FINANCE_TRANSACTION);
        this.shift = this.createReference(DebtorPayment.Properties.SHIFT);
        this.terminal = this.createReference(DebtorPayment.Properties.TERMINAL);
        this.cashDrawer = this.createReference(DebtorPayment.Properties.CASHDRAWER);
    }

    public DebtorPayment(AbstractDebtor newDebtor, FinanceTransaction tran, Price available) {
        this.debtor = this.createReference(DebtorPayment.Properties.DEBTOR);
        this.sale = this.createReference(DebtorPayment.Properties.SALE);
        this.financeTransaction = this.createReference(DebtorPayment.Properties.FINANCE_TRANSACTION);
        this.shift = this.createReference(DebtorPayment.Properties.SHIFT);
        this.terminal = this.createReference(DebtorPayment.Properties.TERMINAL);
        this.cashDrawer = this.createReference(DebtorPayment.Properties.CASHDRAWER);
        this.setFinanceTransaction(tran, available);
        this.setDebtor(newDebtor);
    }

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price newAmount) {
        this.amount = new Price(newAmount, 0.01);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_debtor_sale")
    public DebtorSale getSale() {
        return this.sale.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_transaction")
    public FinanceTransaction getFinanceTransaction() {
        return this.financeTransaction.get();
    }

    public boolean hasFinanceTransaction(FinanceTransaction payment) {
        if (payment == null) {
            return false;
        }
        if (this.isPersistent() && payment.isPersistent()) {
            return payment.getID().equals(this.financeTransaction.getObjectID());
        }
        return payment.equals(this.getFinanceTransaction());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_debtor")
    public AbstractDebtor getDebtor() {
        return this.debtor.get();
    }

    public void setDebtor(AbstractDebtor newDebtor) {
        assert (newDebtor != null) : "Cannot set debtor to null in debtor payment";
        this.debtor.set(newDebtor);
    }

    @Column(name="date")
    @Temporal(value=TemporalType.DATE)
    public Date getDate() {
        return this.date;
    }

    private void setFinanceTransaction(FinanceTransaction tran, Price available) {
        if (tran == null) {
            throw new IllegalArgumentException("Cannot set finance transaction to null in debtor payment");
        }
        tran.registerDebtorPayment(this);
        this.amount = new Price(available, 0.01);
        this.shift.set(tran.getShift());
        this.terminal.set(tran.getTerminal());
        this.cashDrawer.set(tran.getCashDrawer());
        this.date = new Date();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_shift")
    protected Shift getShift() {
        return this.shift.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal")
    protected Terminal getTerminal() {
        return this.terminal.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_cashdrawer")
    protected CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setDebtorSale(DebtorSale debtorSale) {
        this.sale.set(debtorSale);
        if (debtorSale != null) {
            if (debtorSale.getDebtor() != null) {
                this.setDebtor(debtorSale.getDebtor());
            }
            debtorSale.addPayment(this);
        }
    }

    public static Collection<FinanceTransaction> getFinanceTransactionsForDebtorSales(List<DebtorSale> debtorSales) {
        HashSet<FinanceTransaction> financeTransactionSet = new HashSet<FinanceTransaction>();
        for (DebtorSale currentSale : debtorSales) {
            financeTransactionSet.addAll(DebtorPayment.getFinanceTransactionsForDebtorPayments(currentSale.getPayments()));
        }
        return financeTransactionSet;
    }

    public static Collection<FinanceTransaction> getFinanceTransactionsForDebtorPayments(List<DebtorPayment> debtorPayments) {
        HashSet<FinanceTransaction> financeTransactionSet = new HashSet<FinanceTransaction>();
        for (DebtorPayment payment : debtorPayments) {
            financeTransactionSet.add(payment.getFinanceTransaction());
        }
        return financeTransactionSet;
    }

    public DebtorSale removeSale(AbstractDebtor aDebtor) {
        DebtorSale localSale = this.getSale();
        if (localSale != null) {
            this.getSale().removePayment(this, aDebtor);
            this.sale.set(null);
        }
        return localSale;
    }

    public boolean hasDebtorSale() {
        return !this.sale.isNull();
    }

    public void markAsRefunded() {
        this.refunded = true;
    }

    @Column(name="refunded")
    public boolean isRefunded() {
        return this.refunded;
    }

    void setRefunded(boolean isRefunded) {
        this.refunded = isRefunded;
    }

    public static void sortPaymentsForSettlement(List<DebtorPayment> debtorPayments) {
        Collections.sort(debtorPayments, new Comparator<DebtorPayment>(){

            @Override
            public int compare(DebtorPayment obj1, DebtorPayment obj2) {
                if (obj1.getAmount().greaterThan(Price.ZERO_DOLLAR)) {
                    if (obj2.getAmount().greaterThan(Price.ZERO_DOLLAR)) {
                        return this.compareByDate(obj1, obj2);
                    }
                    return 1;
                }
                if (obj2.getAmount().greaterThan(Price.ZERO_DOLLAR)) {
                    return -1;
                }
                return this.compareByDate(obj1, obj2);
            }

            private final int compareByDate(DebtorPayment pay1, DebtorPayment pay2) {
                return pay1.getFinanceTransaction().getCreationTime().compareTo(pay2.getFinanceTransaction().getCreationTime());
            }
        });
    }

    @Override
    public void deleteChild() {
        if (this.hasDebtorSale()) {
            this.getSale().removePayment(this, this.getDebtor());
        }
        this.getFinanceTransaction().deregisterDebtorPayment(this);
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        this.financeTransaction.saveChild();
        this.amount = new Price(this.amount, 0.01);
        PersistenceManager.saveChild(this);
    }

    protected void setCashDrawer(CashDrawer cashDrawer) {
        this.cashDrawer.set(cashDrawer);
    }

    protected void setTerminal(Terminal terminal) {
        this.terminal.set(terminal);
    }

    protected void setShift(Shift shift) {
        this.shift.set(shift);
    }

    protected void setFinanceTransaction(FinanceTransaction financeTransaction) {
        this.financeTransaction.set(financeTransaction);
    }

    protected void setDate(Date date) {
        this.date = date;
    }

    public void setSale(DebtorSale sale) {
        this.sale.set(sale);
    }

    public String formatPayment() {
        StringBuilder SB = new StringBuilder();
        SB.append(((DateFormat)format.get()).format(this.getFinanceTransaction().getCreationTime()));
        SB.append(" ").append(this.getAmount().toString(true));
        if (!this.getAmount().equals(this.getFinanceTransaction().getPaid())) {
            SB.append(" of ").append(this.getFinanceTransaction().getPaid().toString(true));
        }
        SB.append(" ").append(this.getFinanceTransaction().getType());
        return SB.toString();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return this.getFinanceTransaction().getBackgroundColor();
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return this.getFinanceTransaction().getForegroundColor();
    }

    @Override
    @Transient
    public String getIcon() {
        return this.getFinanceTransaction().getIcon();
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getFinanceTransaction() == null ? "<No Transaction>" : this.getFinanceTransaction().getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Price> AMOUNT;
        public PropertiedObject.Property<Date> DATE;
        public PropertiedObject.Property<DebtorSale> SALE;
        public PropertiedObject.Property<FinanceTransaction> FINANCE_TRANSACTION;
        public PropertiedObject.Property<AbstractDebtor> DEBTOR;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<CashDrawer> CASHDRAWER;
        public PropertiedObject.Property REFUNDED;
    }
}

