/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.transactions;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.RefundAccount;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemList;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="debtor_sale")
@AccessType(value="property")
public class DebtorSale
extends PersistentObject
implements SaveableChild,
Displayable {
    public static final Props Properties = new Props();
    private Date saleDate;
    private Date dueDate;
    private Date paidDate;
    private boolean paid = false;
    private Boolean exported = Boolean.FALSE;
    private Price amountOutstanding = Price.ZERO_DOLLAR;
    private Price tip = Price.ZERO_DOLLAR;
    private Price total = Price.ZERO_DOLLAR;
    private Price tax = Price.ZERO_DOLLAR;
    private String refundStatus = RefundStatus.NONE.toString();
    private Reference<Account> saleAccount;
    private Reference<AbstractDebtor> debtor;
    private Reference<Terminal> terminal;
    private Reference<Shift> shift;
    private Reference<CashDrawer> cashDrawer;
    private PersistentWriteableList<DebtorPayment> payments;
    private String invoiceNote;

    public DebtorSale() {
        this.saleAccount = this.createReference(DebtorSale.Properties.SALE_ACCOUNT);
        this.debtor = this.createReference(DebtorSale.Properties.DEBTOR);
        this.terminal = this.createReference(DebtorSale.Properties.TERMINAL);
        this.shift = this.createReference(DebtorSale.Properties.SHIFT);
        this.cashDrawer = this.createReference(DebtorSale.Properties.CASHDRAWER);
        this.payments = (PersistentWriteableList)this.createList(DebtorSale.Properties.PAYMENTS);
    }

    public DebtorSale(Account newSaleAccount, AbstractDebtor newDebtor, FinanceTransactionContext context) {
        this.saleAccount = this.createReference(DebtorSale.Properties.SALE_ACCOUNT);
        this.debtor = this.createReference(DebtorSale.Properties.DEBTOR);
        this.terminal = this.createReference(DebtorSale.Properties.TERMINAL);
        this.shift = this.createReference(DebtorSale.Properties.SHIFT);
        this.cashDrawer = this.createReference(DebtorSale.Properties.CASHDRAWER);
        this.payments = (PersistentWriteableList)this.createList(DebtorSale.Properties.PAYMENTS);
        this.setSaleAccount(newSaleAccount, newDebtor.getUser());
        this.amountOutstanding = new Price(newSaleAccount.getDue(), 0.01);
        this.total = new Price(newSaleAccount.getDue(), 0.01);
        this.tax = this.getTax();
        this.setDebtor(newDebtor);
        this.setDates(new Date(), this.getDebtor().getTermsValue());
        this.setExported(false);
        this.setPayments(new ArrayList<DebtorPayment>());
        this.setCashDrawer(context.getCashDrawer());
        this.setTerminal(context.getTerminal());
        this.setShift(context.getShift());
        this.updatePaid();
    }

    @Transient
    public int getInvoiceNumber() {
        if (this.saleAccount.getObjectID() == null) {
            return this.getSaleAccount().getID().intValue();
        }
        return this.saleAccount.getObjectID().intValue();
    }

    @Column(name="paid")
    public boolean isPaid() {
        return this.paid;
    }

    public void updatePaid() {
        boolean updatePaidDate = !this.isPaid();
        this.amountOutstanding = new Price(this.total.subtract(this.getTotalPaid()), 0.01);
        if (!this.amountOutstanding.isZero()) {
            this.paid = false;
            this.paidDate = null;
            return;
        }
        if (updatePaidDate) {
            this.paidDate = new Date();
        }
        this.paid = true;
    }

    @OneToMany(mappedBy="sale", targetEntity=DebtorPayment.class)
    public List<DebtorPayment> getPayments() {
        return this.payments.getUnmodifiable();
    }

    public void setDebtor(AbstractDebtor newDebtor) {
        this.debtor.set(newDebtor);
    }

    @ManyToOne
    @JoinColumn(name="FK_debtor")
    public AbstractDebtor getDebtor() {
        return this.debtor.get();
    }

    @Column(name="sale_date")
    @Temporal(value=TemporalType.DATE)
    public Date getSaleDate() {
        return this.saleDate;
    }

    @Column(name="due_date")
    @Temporal(value=TemporalType.DATE)
    public Date getDueDate() {
        return this.dueDate;
    }

    @Column(name="paid_date")
    @Temporal(value=TemporalType.DATE)
    public Date getPaidDate() {
        return this.paidDate;
    }

    @Transient
    public Price getTip() {
        return this.tip;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="amount_outstanding")
    public Price getAmountOutstanding() {
        if (this.paid) {
            return new Price(0.0, 0.0);
        }
        if (this.amountOutstanding != null) {
            return this.amountOutstanding;
        }
        throw new IllegalArgumentException("Amount outstanding should never be null");
    }

    @Transient
    public Price getDue() {
        return this.amountOutstanding;
    }

    @Column(name="total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getTotal() {
        return this.total;
    }

    @Transient
    public Price getAmount() {
        return this.total;
    }

    @Transient
    public Price getTotalPaid() {
        Iterator paymentIt = this.payments.iterator();
        Price totalPaid = new Price(0.0, 0.01);
        while (paymentIt.hasNext()) {
            DebtorPayment payment = (DebtorPayment)paymentIt.next();
            totalPaid = totalPaid.add(payment.getAmount());
        }
        return totalPaid;
    }

    public void setSaleAccount(Account newSaleAccount, User lockingUser) {
        if (Config.isDebuging()) {
            OrderMate.LOG.info("Account " + newSaleAccount + " locked to " + newSaleAccount.getUser() + ".");
            OrderMate.LOG.info("Locking user is " + lockingUser + ".");
        }
        if (!newSaleAccount.isLocked()) {
            if (lockingUser != null) {
                OrderMate.LOG.warn("Account is not locked, locking with:" + lockingUser);
                newSaleAccount.lock(lockingUser);
            } else {
                OrderMate.LOG.warn("Account is not locked, locking with the system user");
                newSaleAccount.lock(User.getSystemUser());
            }
            if (!newSaleAccount.isLocked()) {
                throw new IllegalArgumentException("cannot set sale to debtor when sale is not locked.");
            }
        }
        if (newSaleAccount.isDebtorSale()) {
            DebtorSale oldSale = newSaleAccount.getUniqueDebtorSale();
            oldSale.deleteChild();
        }
        newSaleAccount.save();
        this.saleAccount.set(newSaleAccount);
        newSaleAccount.setDebtorSale(this);
        this.updatePaid();
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_account")
    public Account getSaleAccount() {
        return this.saleAccount.get();
    }

    public void collapseSalesAccount() {
        this.saleAccount.setObjectID(this.saleAccount.getObjectID());
    }

    public void setPayments(List<DebtorPayment> debtorPayments) {
        this.payments = this.payments.clone();
        this.payments.set(debtorPayments);
        this.updatePaid();
    }

    public void removeAllPayments() {
        ArrayList<DebtorPayment> listCopy = new ArrayList<DebtorPayment>(this.getPayments());
        for (DebtorPayment payment : listCopy) {
            this.removePayment(payment, payment.getDebtor());
        }
        this.payments.clear();
        this.updatePaid();
    }

    public void removePayment(DebtorPayment payment, AbstractDebtor debtorToRemove) {
        debtorToRemove.addUnsettlePayment(payment);
        payment.setDebtorSale(null);
        this.payments.remove(payment);
        this.updatePaid();
    }

    protected void addPayment(DebtorPayment payment) {
        payment.setDebtor(this.getDebtor());
        this.payments.add(payment);
        this.updatePaid();
    }

    public void setExported(boolean isExported) {
        this.exported = isExported;
    }

    @Column(name="exported")
    public boolean isExported() {
        return this.exported;
    }

    @Transient
    public boolean isOverdue() {
        if (this.isPaid()) {
            return false;
        }
        Date now = new Date();
        if (now.getYear() > this.getDueDate().getYear()) {
            return true;
        }
        if (now.getYear() == this.getDueDate().getYear()) {
            if (now.getMonth() > this.getDueDate().getMonth()) {
                return true;
            }
            if (now.getMonth() == this.getDueDate().getMonth() && now.getDate() > this.getDueDate().getDate()) {
                return true;
            }
        }
        return false;
    }

    public void setDates(Date newSaleDate, AbstractDebtor.Terms terms) {
        this.saleDate = newSaleDate;
        this.dueDate = new Date(this.saleDate.getTime() + (long)terms.getDays() * 86400000L);
    }

    private void setCashDrawer(CashDrawer newDrawer) {
        this.cashDrawer.set(newDrawer);
    }

    private void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    private void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_cashdrawer")
    protected CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    @Override
    @Transient
    public String getLabel() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder label = new StringBuilder();
        Long saleID = null;
        if (this.getSaleAccount() != null) {
            saleID = this.getSaleAccount().getID();
        }
        label.append("<HTML><CENTER>#");
        label.append(saleID == null ? "-SaleID N/A-" : saleID.toString());
        label.append("&nbsp;&nbsp;");
        label.append(this.getShift() == null ? "-Shift N/A-" : this.getShift().getTradingDay().getLabel());
        label.append("&nbsp;&nbsp;&nbsp;Total:");
        label.append(this.getAmount());
        label.append("<BR>");
        if (this.isPaid()) {
            label.append("Due: ");
            label.append(this.getAmountOutstanding().toString());
        } else {
            label.append("<FONT size='+1'>Due: ");
            label.append(this.getAmountOutstanding().toString());
            label.append("</FONT>");
        }
        if (this.getDueDate() != null) {
            label.append("&nbsp;&nbsp;&nbsp; ");
            label.append(DateTimeUtils.getMediumDateFormat().format(this.getDueDate()));
        }
        label.append("</CENTER></HTML>");
        return label.toString();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.isExported()) {
            return Displayable.EXPORTED_COLOR;
        }
        if (this.isPaid()) {
            return Displayable.PAID_COLOR;
        }
        if (this.isOverdue()) {
            return Displayable.OVERDUE_COLOR;
        }
        return Displayable.PRINTED_COLOR;
    }

    @Override
    @Transient
    public String getIcon() {
        if (this.isExported()) {
            return "/waitermate/images/lock_small.png";
        }
        if (this.hasRefunded()) {
            return "/waitermate/images/undo.png";
        }
        if (this.isRefund()) {
            return "/waitermate/images/redo.png";
        }
        return null;
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        this.updatePaid();
        this.amountOutstanding = new Price(this.amountOutstanding, 0.01);
        this.total = new Price(this.total, 0.01);
        PersistenceManager.saveChild(this);
        this.payments.saveChild();
    }

    public static void sortListForPayment(List<DebtorSale> debtorSales) {
        Collections.sort(debtorSales, new Comparator<DebtorSale>(){

            @Override
            public int compare(DebtorSale d1, DebtorSale d2) {
                if (d1.getAmountOutstanding().lessThan(Price.ZERO) && d2.getAmountOutstanding().greaterThan(Price.ZERO)) {
                    return -1;
                }
                if (d1.getAmountOutstanding().greaterThan(Price.ZERO) && d2.getAmountOutstanding().lessThan(Price.ZERO)) {
                    return 1;
                }
                int comparison = d1.getDueDate().compareTo(d2.getDueDate());
                if (comparison == 0) {
                    comparison = d1.getSaleDate().compareTo(d2.getSaleDate());
                }
                if (comparison == 0) {
                    if (d1.isPersistent() && d2.isPersistent()) {
                        return d1.getID().compareTo(d2.getID());
                    }
                    if (d2.isPersistent()) {
                        return 1;
                    }
                    return -1;
                }
                return comparison;
            }
        });
    }

    public void markAllRefunded() {
        this.setRefundStatus(RefundStatus.ALL);
    }

    public void markSomeRefunded() {
        this.setRefundStatus(RefundStatus.SOME);
    }

    public void setRefundStatus(RefundStatus status) {
        this.refundStatus = status.toString();
    }

    void setRefundStatus(String status) {
        this.refundStatus = status;
    }

    @Column(name="refund_status")
    public String getRefundStatus() {
        return this.refundStatus;
    }

    public boolean hasAllRefunded() {
        return this.refundStatus.equals(RefundStatus.ALL.toString());
    }

    public boolean hasSomeRefunded() {
        return this.refundStatus.equals(RefundStatus.SOME.toString());
    }

    protected boolean hasRefunded() {
        return this.hasSomeRefunded() || this.hasAllRefunded();
    }

    @Transient
    protected boolean isRefund() {
        return this.getSaleAccount() != null && RefundAccount.TYPE.equals(this.getSaleAccount().getAccountType());
    }

    public boolean itemsAreASubSetOfTheseItems(List<SalesLineItem> items) {
        SalesItemList filteredItems = new SalesItemList();
        for (SalesLineItem currentItem : items) {
            if (!currentItem.getAccount().equals(this.getSaleAccount())) continue;
            filteredItems.addAll(currentItem.getSalesItems());
        }
        SalesItemList accountItems = new SalesItemList(this.getSaleAccount().getItemHelper().getSalesItems());
        if (accountItems.size() == 0 && filteredItems.size() != 0) {
            return false;
        }
        for (SalesItem item : accountItems) {
            if (!filteredItems.getEquivalentItemQuantity(item).notEquals(accountItems.getEquivalentItemQuantity(item))) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnItemInList(List<SalesLineItem> items) {
        Account account = this.getSaleAccount();
        for (SalesLineItem item : items) {
            if (!item.getAccount().equals(account) || !item.getQuantity().notEquals(0)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemGroup> getSalesAccounts(List<DebtorSale> debtorSales) {
        ArrayList<ItemGroup> accounts = new ArrayList<ItemGroup>();
        for (DebtorSale currentSale : debtorSales) {
            accounts.add(currentSale.getSaleAccount());
        }
        return accounts;
    }

    public static List<DebtorPayment> getDebtorPayments(List<DebtorSale> debtorSales) {
        ArrayList<DebtorPayment> payments = new ArrayList<DebtorPayment>();
        for (DebtorSale currentSale : debtorSales) {
            payments.addAll(currentSale.getPayments());
        }
        return payments;
    }

    public void nukeSale() {
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE debtor_payment SET debtor_payment.FK_debtor_sale = NULL WHERE debtor_payment.FK_debtor_sale = ?", new Object[]{this.getID()});
        AbstractDebtor debtorToUpdate = this.getDebtor();
        PersistenceManager.getPersistenceDelegate().executeUpdate("DELETE FROM debtor_sale WHERE debtor_sale.ID = ?", new Object[]{this.getID()});
        debtorToUpdate = (AbstractDebtor)PersistenceManager.reacquire(debtorToUpdate);
        DebtorPaymentAgent agent = new DebtorPaymentAgent(debtorToUpdate);
        agent.pay();
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    protected void setDueDate(Date newDueDate) {
        this.dueDate = newDueDate;
    }

    protected void setPaid(boolean newPaid) {
        this.paid = newPaid;
    }

    protected void setTotal(Price newTotal) {
        this.total = newTotal;
    }

    protected void setAmountOutstanding(Price newAmountOutstanding) {
        this.amountOutstanding = newAmountOutstanding;
    }

    public void setTip(Price newTip) {
        this.tip = newTip;
    }

    protected void setSaleDate(Date newSaleDate) {
        this.saleDate = newSaleDate;
    }

    protected void setSaleAccount(Account newSaleAccount) {
        this.saleAccount.set(newSaleAccount);
    }

    protected void setPaidDate(Date newPaidDate) {
        this.paidDate = newPaidDate;
    }

    public void setInvoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
    }

    @Column(name="invoice_note")
    public String getInvoiceNote() {
        return this.invoiceNote;
    }

    public boolean hasNote() {
        return this.invoiceNote != null && !this.invoiceNote.isEmpty();
    }

    @Transient
    public Price getTax() {
        return this.calculateTAX(this.total);
    }

    public Price calculateTAX(Price total) {
        Price savedTotal = this.saleAccount.get().getSavedTotal();
        Price savedTax = this.saleAccount.get().getTax();
        if (savedTax != null && savedTax.doubleValue() == 0.0) {
            return Price.ZERO_NO_ROUND;
        }
        Price ratio = savedTotal.divide(savedTax);
        return total.divide(ratio);
    }

    private static class RefundStatus {
        public static RefundStatus ALL = new RefundStatus("ALL");
        public static RefundStatus SOME = new RefundStatus("SOME");
        public static RefundStatus NONE = new RefundStatus("NONE");
        private String label;

        private RefundStatus(String desc) {
            this.label = desc;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Account> SALE_ACCOUNT;
        public PropertiedObject.Property SALE_DATE;
        public PropertiedObject.Property DUE_DATE;
        public PropertiedObject.Property PAID_DATE;
        public PropertiedObject.Property<DebtorPayment> PAYMENTS;
        public PropertiedObject.Property<AbstractDebtor> DEBTOR;
        public PropertiedObject.Property PAID;
        public PropertiedObject.Property AMOUNT_OUTSTANDING;
        public PropertiedObject.Property TIP;
        public PropertiedObject.Property TOTAL;
        public PropertiedObject.Property TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorSale.class), "tax");
        public PropertiedObject.Property EXPORTED;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<CashDrawer> CASHDRAWER;
        public PropertiedObject.Property REFUND_STATUS;
        public PropertiedObject.Property INVOICE_NOTE;
    }
}

