/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.giftvoucher;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.queries.finance.voucher.VoucherTransactionQueries;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_gift_voucher")
public class GiftVoucher
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Date creationDate;
    private Date creationTime;
    private Date activationDate;
    private Date activationTime;
    private Price cachedValue;
    private String uniqueId;
    private String authorisation;
    private Reference<Customer> customer;
    private PersistentWriteableList<GiftVoucherTransaction> transactions;

    @Deprecated
    public GiftVoucher() {
        this.customer = this.createReference(GiftVoucher.Properties.CUSTOMER);
        this.transactions = this.createWriteableList(GiftVoucher.Properties.TRANSACTIONS);
    }

    public GiftVoucher(String uuid) {
        this.customer = this.createReference(GiftVoucher.Properties.CUSTOMER);
        this.transactions = this.createWriteableList(GiftVoucher.Properties.TRANSACTIONS);
        this.setUniqueId(uuid);
        Date now = new Date();
        this.setCreationDate(now);
        this.setCreationTime(now);
        this.cachedValue = Price.ZERO_DOLLAR;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @Column(name="creation_date")
    @Temporal(value=TemporalType.DATE)
    public Date getCreationDate() {
        return this.creationDate;
    }

    protected void setCreationDate(Date date) {
        this.creationDate = date;
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIME)
    public Date getCreationTime() {
        return this.creationTime;
    }

    protected void setCreationTime(Date time) {
        this.creationTime = DateTimeUtils.clearMillis(time);
    }

    @Transient
    public Date getCreationDateTime() {
        return DateTimeUtils.combineDateAndTime(this.getCreationDate(), this.getCreationTime());
    }

    @Transient
    public Date getExpiryDateTime() {
        GiftVoucherTransaction voucherTransaction = PersistenceManager.getObject(GiftVoucherTransaction.class, VoucherTransactionQueries.getTopupTxnWithLatestExpiryDate(this).toString());
        if (voucherTransaction != null && voucherTransaction.getExpiryDate() != null && voucherTransaction.getExpiryTime() != null) {
            return DateTimeUtils.combineDateAndTime(voucherTransaction.getExpiryDate(), voucherTransaction.getExpiryTime());
        }
        OrderMate.LOG.warn(this + " Voucher has NO expiry date /time in the system, how possible? ");
        return null;
    }

    @Column(name="activation_date")
    @Temporal(value=TemporalType.DATE)
    public Date getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(Date date) {
        this.activationDate = date;
    }

    @Column(name="activation_time")
    @Temporal(value=TemporalType.TIME)
    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date time) {
        this.activationTime = DateTimeUtils.clearMillis(time);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="cached_value")
    public Price getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Price value) {
        this.cachedValue = value;
    }

    @Column(name="unique_id")
    public String getUniqueId() {
        return this.uniqueId;
    }

    protected void setUniqueId(String id) {
        this.uniqueId = id;
    }

    @Column(name="authorisation")
    public String getAuthorisation() {
        return this.authorisation;
    }

    public void setAuthorisation(String auth) {
        this.authorisation = auth;
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer cust) {
        this.customer.set(cust);
    }

    @OneToMany(mappedBy="giftVoucher", targetEntity=GiftVoucherTransaction.class, fetch=FetchType.LAZY)
    public List<GiftVoucherTransaction> getTransactions() {
        return this.transactions.getUnmodifiable();
    }

    protected void setTransactions(List<GiftVoucherTransaction> gvTransactions) {
        this.transactions = this.transactions.clone();
        this.transactions.set(gvTransactions);
    }

    public void addGiftVoucherTransaction(GiftVoucherTransaction transaction) {
        this.transactions.add(transaction);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.transactions.saveChild();
    }

    @Override
    public void delete() {
        this.setSystemState(SystemState.DELETED_STATE);
        for (GiftVoucherTransaction gvt : this.transactions) {
            gvt.deleteChild();
        }
        this.save();
    }

    @Transient
    public int numUnconfirmedTransactions() {
        NumberReport report = PersistenceManager.getObject(NumberReport.class, Query.count(GiftVoucherTransaction.class, "value").equals(GiftVoucherTransaction.Properties.GIFT_VOUCHER, this).active(GiftVoucherTransaction.class).not().equals(GiftVoucherTransaction.Properties.CONFIRMED, (Object)1).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).toString());
        return report.intValue();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        if (this.uniqueId != null) {
            return this.uniqueId;
        }
        return "";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Date> CREATION_DATE;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<Date> ACTIVATION_DATE;
        public PropertiedObject.Property<Date> ACTIVATION_TIME;
        public PropertiedObject.Property<String> UNIQUE_ID;
        public PropertiedObject.Property<String> AUTHORISATION;
        public PropertiedObject.Property<Price> CACHED_VALUE;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<GiftVoucherTransaction> TRANSACTIONS;
    }
}

