/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.giftvoucher;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.finance.voucher.VoucherTransactionQueries;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_gift_voucher_transaction")
public class GiftVoucherTransaction
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Price amount;
    private Date creationDate;
    private Date creationTime;
    private String authId;
    private Long financeTransactionId;
    private Date expiryDate;
    private Date expiryTime;
    private Price voucherBalance;
    private String voucherTransactionType;
    private boolean confirmed;
    private boolean bonus;
    private PersistentWriteableList<FinanceTransaction> payments;
    private Reference<TradingDay> tradingDay;
    private Reference<VoucherTransaction> financeTransaction;
    private Reference<GiftVoucher> giftVoucher;
    private Reference<Account> account;
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private Reference<TerminalLocation> location;
    private Reference<SalesLocation> salesLocation;
    private Reference<Shift> shift;
    private Reference<GiftVoucherTransaction> reversedVoucherTransaction;
    private Reference<SalesPriceAdjustment> priceAdjustment;
    private Reference<GiftVoucherTransaction> bonusTransaction;

    @Deprecated
    public GiftVoucherTransaction() {
        this.payments = (PersistentWriteableList)this.createList(GiftVoucherTransaction.Properties.PAYMENTS);
        this.tradingDay = this.createReference(GiftVoucherTransaction.Properties.TRADING_DAY);
        this.financeTransaction = this.createReference(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION);
        this.giftVoucher = this.createReference(GiftVoucherTransaction.Properties.GIFT_VOUCHER);
        this.account = this.createReference(GiftVoucherTransaction.Properties.ACCOUNT);
        this.user = this.createReference(GiftVoucherTransaction.Properties.USER);
        this.terminal = this.createReference(GiftVoucherTransaction.Properties.TERMINAL);
        this.location = this.createReference(GiftVoucherTransaction.Properties.LOCATION);
        this.salesLocation = this.createReference(GiftVoucherTransaction.Properties.SALES_LOCATION);
        this.shift = this.createReference(GiftVoucherTransaction.Properties.SHIFT);
        this.reversedVoucherTransaction = this.createReference(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        this.priceAdjustment = this.createReference(GiftVoucherTransaction.Properties.PRICE_ADJUSTMENT);
        this.bonusTransaction = this.createReference(GiftVoucherTransaction.Properties.BONUS_TRANSACTION);
    }

    public GiftVoucherTransaction(Price theAmount, GiftVoucher voucher, VoucherTransaction transaction, String authId, Account theAccount, EventContext context) {
        this.payments = (PersistentWriteableList)this.createList(GiftVoucherTransaction.Properties.PAYMENTS);
        this.tradingDay = this.createReference(GiftVoucherTransaction.Properties.TRADING_DAY);
        this.financeTransaction = this.createReference(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION);
        this.giftVoucher = this.createReference(GiftVoucherTransaction.Properties.GIFT_VOUCHER);
        this.account = this.createReference(GiftVoucherTransaction.Properties.ACCOUNT);
        this.user = this.createReference(GiftVoucherTransaction.Properties.USER);
        this.terminal = this.createReference(GiftVoucherTransaction.Properties.TERMINAL);
        this.location = this.createReference(GiftVoucherTransaction.Properties.LOCATION);
        this.salesLocation = this.createReference(GiftVoucherTransaction.Properties.SALES_LOCATION);
        this.shift = this.createReference(GiftVoucherTransaction.Properties.SHIFT);
        this.reversedVoucherTransaction = this.createReference(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        this.priceAdjustment = this.createReference(GiftVoucherTransaction.Properties.PRICE_ADJUSTMENT);
        this.bonusTransaction = this.createReference(GiftVoucherTransaction.Properties.BONUS_TRANSACTION);
        this.setAmount(theAmount);
        this.setGiftVoucher(voucher);
        this.setFinanceTransaction(transaction);
        this.setAccount(theAccount);
        this.setAuthId(authId);
        if (context != null) {
            this.setUser(context.getUser());
            this.setTerminal(context.getTerminal());
            this.setLocation(context.getTerminal().getLocation());
            this.setSalesLocation(context.getTerminal().getSalesLocation());
            this.setShift(context.getShift());
            this.setTradingDay(context.getTradingDay());
        }
        Date now = new Date();
        this.setCreationDate(now);
        this.setCreationTime(now);
        if (voucher != null) {
            voucher.addGiftVoucherTransaction(this);
        }
        if (theAccount != null) {
            theAccount.addVoucherTransaction(this);
        }
    }

    public GiftVoucherTransaction(Price theAmount, GiftVoucher voucher, VoucherTransaction transaction, String authId, Account theAccount) {
        this(theAmount, voucher, transaction, authId, theAccount, null);
    }

    public GiftVoucherTransaction(Price theAmount, GiftVoucher voucher, Account account) {
        this(theAmount, voucher, null, null, account);
    }

    public void deleteTransaction() {
        this.systemState = SystemState.DELETED_STATE;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="amount")
    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price value) {
        this.amount = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="voucher_balance")
    public Price getVoucherBalance() {
        return this.voucherBalance;
    }

    public void setVoucherBalance(Price voucherBalance) {
        this.voucherBalance = voucherBalance;
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_account")
    public Account getAccount() {
        return this.account.get();
    }

    public void setAccount(Account salesAccount) {
        this.account.set(salesAccount);
    }

    @Transient
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User configUser) {
        this.user.set(configUser);
    }

    @Transient
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal configTerminal) {
        this.terminal.set(configTerminal);
    }

    @Column(name="FK_config_user")
    public Long getUserId() {
        if (this.user.get() != null) {
            return this.user.get().getID();
        }
        return null;
    }

    @Deprecated
    public void setUserId(Long userId) {
    }

    @Column(name="FK_config_terminal")
    public Long getTerminalId() {
        if (this.terminal.get() != null) {
            return this.terminal.get().getID();
        }
        return null;
    }

    @Deprecated
    public void setTerminalId(Long terminalId) {
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    protected void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getLocation() {
        if (this.location.get() == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        }
        return this.location.get();
    }

    protected void setLocation(TerminalLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        } else {
            this.location.set(value);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_config_sales_location")
    public SalesLocation getSalesLocation() {
        if (this.salesLocation.get() == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        }
        return this.salesLocation.get();
    }

    protected void setSalesLocation(SalesLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        } else {
            this.salesLocation.set(value);
        }
    }

    @Column(name="creation_date")
    @Temporal(value=TemporalType.DATE)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIME)
    public Date getCreationTime() {
        return this.creationTime;
    }

    protected void setCreationTime(Date time) {
        this.creationTime = DateTimeUtils.clearMillis(time);
    }

    @Column(name="auth_id")
    public String getAuthId() {
        return this.authId;
    }

    protected void setAuthId(String value) {
        this.authId = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_gift_voucher")
    public GiftVoucher getGiftVoucher() {
        return this.giftVoucher.get();
    }

    public void setGiftVoucher(GiftVoucher voucher) {
        this.giftVoucher.set(voucher);
    }

    @OneToOne
    @JoinColumn(name="fk_finance_gift_voucher_transaction")
    public GiftVoucherTransaction getReversedVoucherTransaction() {
        return this.reversedVoucherTransaction.get();
    }

    public void setReversedVoucherTransaction(GiftVoucherTransaction reversedTransaction) {
        this.reversedVoucherTransaction.set(reversedTransaction);
    }

    @Transient
    public boolean isReversal() {
        return !this.reversedVoucherTransaction.isNull();
    }

    @Transient
    public boolean isReversed() {
        if (this.isReversal()) {
            return false;
        }
        GiftVoucherTransaction reversal = PersistenceManager.getObject(GiftVoucherTransaction.class, VoucherTransactionQueries.getReversalForVoucherTxn(this).toString());
        return reversal != null;
    }

    @Transient
    public VoucherTransaction getFinanceTransaction() {
        return this.financeTransaction.get();
    }

    public void setFinanceTransaction(VoucherTransaction transaction) {
        if (!this.financeTransaction.isNull() && !this.financeTransaction.get().equals(transaction)) {
            throw new IllegalArgumentException("We cannot override the transaction for a voucher");
        }
        this.financeTransaction.set(transaction);
        this.financeTransactionId = transaction != null ? transaction.getID() : null;
    }

    @Column(name="fk_finance_transaction")
    public Long getFinanceTransactionId() {
        return this.financeTransactionId;
    }

    @Deprecated
    protected void setFinanceTransactionId(Long id) {
    }

    @Transient
    public String getVoucherTransactionType() {
        this.voucherTransactionType = this.isRedeemReversal() ? VoucherTransactionType.REDEEM_REVERSAL.getName() : (this.isTopupReversal() ? VoucherTransactionType.TOPUP_REVERSAL.getName() : (this.isTopup() ? VoucherTransactionType.TOPUP.getName() : VoucherTransactionType.REDEEM.getName()));
        return this.voucherTransactionType;
    }

    @Transient
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    @Column(name="fk_finance_trading_day")
    public Long getTradingDayId() {
        if (this.tradingDay.get() != null) {
            return this.tradingDay.get().getID();
        }
        return null;
    }

    @Deprecated
    protected void setTradingDayId(Long id) {
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.financeTransaction != null) {
            this.financeTransaction.saveChild();
        }
        if (this.bonusTransaction != null) {
            this.bonusTransaction.saveChild();
        }
        if (this.priceAdjustment != null) {
            this.priceAdjustment.saveChild();
        }
        this.payments.saveChild();
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.setSystemState(SystemState.DELETED_STATE);
        this.payments.deleteChild();
        this.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Transient
    public boolean isRedeeming() {
        return Price.ZERO_DOLLAR.greaterThan(this.amount) && !this.isReversal();
    }

    @Transient
    public boolean isTopup() {
        return Price.ZERO_DOLLAR.lessThan(this.amount) && !this.isReversal();
    }

    @Transient
    public boolean isTopupReversal() {
        return Price.ZERO_DOLLAR.greaterThan(this.amount) && this.isReversal();
    }

    @Transient
    public boolean isRedeemReversal() {
        return Price.ZERO_DOLLAR.lessThan(this.amount) && this.isReversal();
    }

    @Transient
    public boolean isAuthorised() {
        return this.authId != null;
    }

    @Transient
    public boolean isActive() {
        return SystemState.ACTIVE_STATE.equals(this.systemState);
    }

    public void authorise(String authorisationId) {
        if (this.authId != null && !this.authId.equals(authorisationId)) {
            throw new IllegalStateException("Cannot re-set the authorisation id for a gift voucher transaction");
        }
        this.authId = authorisationId;
    }

    @Column(name="expiry_date")
    @Temporal(value=TemporalType.DATE)
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date date) {
        this.expiryDate = date;
    }

    @Column(name="expiry_time")
    @Temporal(value=TemporalType.TIME)
    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Date time) {
        this.expiryTime = time == null ? time : DateTimeUtils.clearMillis(time);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="finance_transaction_item", joinColumns={@JoinColumn(name="FK_finance_gift_voucher_transaction", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_finance_transaction", referencedColumnName="ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<FinanceTransaction> getPayments() {
        return this.payments;
    }

    protected void setPayments(List<FinanceTransaction> newPayment) {
        this.payments.set(newPayment);
    }

    @Transient
    public List<FinanceTransaction> getFinancePayments() {
        return this.payments.getUnmodifiable();
    }

    public void addFinancePayments(FinanceTransaction toAdd) {
        this.payments.add(toAdd);
    }

    public void removeFinancePayments(FinanceTransaction toRemove) {
        this.payments.remove(toRemove);
    }

    @Transient
    public boolean hasPayments() {
        return !this.payments.isEmpty();
    }

    @Column(name="confirmed")
    public boolean isConfirmed() {
        return this.confirmed;
    }

    protected void setConfirmed(boolean value) {
        this.confirmed = value;
    }

    public void confirm() {
        this.confirmed = true;
    }

    @Transient
    public boolean isPositive() {
        return Price.ZERO_DOLLAR.lessThan(this.amount);
    }

    @Column(name="bonus")
    public boolean isBonus() {
        return this.bonus;
    }

    protected void setBonus(boolean value) {
        this.bonus = value;
    }

    @Transient
    public SalesPriceAdjustment getPriceAdjustment() {
        return this.priceAdjustment.get();
    }

    public void setSalesPriceAdjustment(SalesPriceAdjustment yourAdj) {
        this.priceAdjustment.set(yourAdj);
    }

    @Transient
    public GiftVoucherTransaction getBonusTransaction() {
        return this.bonusTransaction.get();
    }

    public void setBonusTransaction(GiftVoucherTransaction txn) {
        this.bonusTransaction.set(txn);
    }

    @Transient
    public String getUuid() {
        if (this.getGiftVoucher() != null) {
            return this.getGiftVoucher().getUniqueId();
        }
        return "-";
    }

    public static enum VoucherTransactionType {
        TOPUP("Topup"),
        REDEEM("Redeem"),
        TOPUP_REVERSAL("Topup Reversal"),
        REDEEM_REVERSAL("Redeem Reversal");

        private String name;

        private VoucherTransactionType(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Price> AMOUNT;
        public PropertiedObject.Property<Date> CREATION_DATE;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<VoucherTransaction> FINANCE_TRANSACTION;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<GiftVoucher> GIFT_VOUCHER;
        public PropertiedObject.Property<String> AUTH_ID;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<Date> EXPIRY_DATE;
        public PropertiedObject.Property<Date> EXPIRY_TIME;
        public PropertiedObject.Property<Price> VOUCHER_BALANCE;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<FinanceTransaction> PAYMENTS;
        public PropertiedObject.Property<TerminalLocation> LOCATION;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Boolean> CONFIRMED;
        public PropertiedObject.Property<GiftVoucherTransaction> REVERSED_VOUCHER_TRANSACTION;
        public PropertiedObject.Property<Boolean> BONUS;
        public PropertiedObject.Property<SalesPriceAdjustment> PRICE_ADJUSTMENT;
        public PropertiedObject.Property<GiftVoucherTransaction> BONUS_TRANSACTION;
        public PersistentObject.DerivedProperty<String> VOUCHER_TRANSACTION_TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GiftVoucherTransaction.class), "voucherTransactionType");
        public PersistentObject.DerivedProperty<String> UUID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GiftVoucherTransaction.class), "uuid");
        public PersistentObject.DerivedProperty<Long> FINANCE_TRANSACTION_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GiftVoucherTransaction.class), "financeTransactionId");
        public PersistentObject.DerivedProperty<Long> USER_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GiftVoucherTransaction.class), "userId");
        public PersistentObject.DerivedProperty<Long> TERMINAL_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)GiftVoucherTransaction.class), "terminalId");
    }
}

