/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.giftvoucher;

public enum VoucherError {
    CANNOT_LOCK("This voucher is already being used somewhere else."),
    CANNOT_CREATE("Could not create voucher."),
    CANNOT_GENERATE("Could not generate a new voucher."),
    CANNOT_CONFIRM("The remote authenticator cannot confirm the transaction."),
    CANNOT_CANCEL_CONFIRMED("Could not cancel a transaction that has been confirmed."),
    CANNOT_CANCEL_REVERSED("Could not cancel a transaction that has been reversed."),
    NOT_EXISTS("This voucher does not exist."),
    DELETED("This voucher has been deleted."),
    EXPIRED("This voucher has expired."),
    REQUEST_INVALID("The voucher request was invalid."),
    INSUFFICIENT_FUNDS("This voucher contains insufficient funds to be consumed."),
    NO_AUTHORITY("No voucher authority was found."),
    NOT_AUTHORISED("The voucher authority rejected the authentication."),
    SERVER_ERROR("A server error has occurred."),
    AUTH_ERROR("A remote authenticator error has occurred.");

    private String error;

    private VoucherError(String errorExplanation) {
        this.error = errorExplanation;
    }

    public String getExplanation() {
        return this.error;
    }
}

