/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.giftvoucher;

import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.queries.finance.voucher.VoucherQueries;

public class VoucherUtils {
    private static final int LOCAL_VOUCHER_BARCODE_PREFIX_LENGTH = 2;

    public static int getExpectedVoucherLength(String voucherID) {
        if (StringUtils.isEmpty(voucherID)) {
            return Integer.MAX_VALUE;
        }
        int longestLength = 0;
        List<GiftVoucherConfiguration> activeVoucherConfigs = VoucherQueries.getActiveVoucherProviders();
        for (GiftVoucherConfiguration voucherConfig : activeVoucherConfigs) {
            int length;
            if (GiftVoucherIntegrationType.Hive.equals((Object)voucherConfig.getIntegrationType())) {
                if (!voucherID.startsWith(voucherConfig.getPrefix())) continue;
                return voucherConfig.getUuidLength();
            }
            if (!GiftVoucherIntegrationType.POS.equals((Object)voucherConfig.getIntegrationType()) || voucherID.length() <= 2 || !VoucherUtils.matches(voucherID.substring(2), voucherConfig.getPrefix()) || longestLength >= (length = (voucherConfig.getPrefix() != null ? voucherConfig.getPrefix().length() : 0) + voucherConfig.getUuidLength() + 2)) continue;
            longestLength = length;
        }
        return longestLength == 0 ? Integer.MAX_VALUE : longestLength;
    }

    public static boolean hasMatchingPrefix(String voucherID) {
        ExperimentalFeature bypass = ExperimentalFeature.find("Bypass Voucher Validation");
        if (bypass != null && bypass.getBooleanValue(Boolean.FALSE).booleanValue()) {
            return true;
        }
        if (StringUtils.isEmpty(voucherID)) {
            return true;
        }
        boolean hasMatch = false;
        List<GiftVoucherConfiguration> activeVoucherConfigs = VoucherQueries.getActiveVoucherProviders();
        for (GiftVoucherConfiguration voucherConfig : activeVoucherConfigs) {
            if (GiftVoucherIntegrationType.Hive.equals((Object)voucherConfig.getIntegrationType())) {
                if (!VoucherUtils.matches(voucherID, voucherConfig.getPrefix())) continue;
                return true;
            }
            if (!GiftVoucherIntegrationType.POS.equals((Object)voucherConfig.getIntegrationType())) continue;
            if (voucherID.length() <= 2) {
                hasMatch = true;
                continue;
            }
            if (voucherID.length() <= 2 || !VoucherUtils.matches(voucherID.substring(2), voucherConfig.getPrefix())) continue;
            hasMatch = true;
        }
        return hasMatch;
    }

    public static boolean hasClashingPrefix(GiftVoucherConfiguration config) {
        List<GiftVoucherConfiguration> activeVoucherConfigs = VoucherQueries.getActiveVoucherProviders();
        for (GiftVoucherConfiguration voucherConfig : activeVoucherConfigs) {
            if (config.equals(voucherConfig) || voucherConfig.getIntegrationType().equals((Object)GiftVoucherIntegrationType.Hive) && StringUtils.isEmpty(voucherConfig.getPrefix()) || !VoucherUtils.matches(config.getPrefix(), voucherConfig.getPrefix())) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String input, String voucherPrefix) {
        if (input.length() > voucherPrefix.length()) {
            return input.startsWith(voucherPrefix);
        }
        return voucherPrefix.startsWith(input);
    }
}

