/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.giftvoucher;

import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.queries.finance.voucher.VoucherConfigurationQueries;

public class VoucherValidationUtil {
    private static final String CARD_PREFIX = "06";
    private final List<GiftVoucherConfiguration> schemes = VoucherConfigurationQueries.getActiveSchemes();
    private int shortestUuidLength = 100;
    private int longestUuidLength = 1;
    private int longestPrefixLength = 1;

    public VoucherValidationUtil() {
        for (GiftVoucherConfiguration scheme : this.schemes) {
            int virtLength = scheme.getUuidLength();
            if (GiftVoucherIntegrationType.POS.equals((Object)scheme.getIntegrationType())) {
                virtLength = scheme.getUuidLength() + scheme.getPrefix().length();
            }
            if (this.longestUuidLength < virtLength) {
                this.longestUuidLength = virtLength;
            }
            if (this.shortestUuidLength > scheme.getUuidLength()) {
                this.shortestUuidLength = scheme.getUuidLength();
            }
            if (scheme.getPrefix() == null || this.longestPrefixLength >= scheme.getPrefix().length()) continue;
            this.longestPrefixLength = scheme.getPrefix().length();
        }
    }

    private String removeBarcodePrefix(String text) {
        if (text != null && text.startsWith(CARD_PREFIX)) {
            return text.substring(CARD_PREFIX.length());
        }
        return text == null || text.isEmpty() ? "NULL VOUCHER CODE" : text;
    }

    public boolean matchesSchemeFormat(String text) {
        if (text == null) {
            return false;
        }
        String cleanedUuid = this.removeBarcodePrefix(text);
        if (this.shortestUuidLength > 0 && cleanedUuid.length() > this.longestUuidLength) {
            return false;
        }
        for (GiftVoucherConfiguration scheme : this.schemes) {
            if (GiftVoucherIntegrationType.POS.equals((Object)scheme.getIntegrationType())) {
                if (cleanedUuid.length() < scheme.getUuidLength() + scheme.getPrefix().length() || !cleanedUuid.startsWith(scheme.getPrefix()) || cleanedUuid.substring(scheme.getPrefix().length()).length() != scheme.getUuidLength()) continue;
                return true;
            }
            if (!GiftVoucherIntegrationType.Hive.equals((Object)scheme.getIntegrationType())) continue;
            if (StringUtils.isEmpty(scheme.getPrefix())) {
                return true;
            }
            if (text.length() < scheme.getUuidLength() || !text.startsWith(scheme.getPrefix()) || text.length() != scheme.getUuidLength()) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyUuidLength(String text) {
        if (text == null) {
            return false;
        }
        if (text.length() <= this.longestPrefixLength) {
            return false;
        }
        for (GiftVoucherConfiguration scheme : this.schemes) {
            if (!this.matchesLength(scheme, text)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesLength(GiftVoucherConfiguration scheme, String text) {
        if (GiftVoucherIntegrationType.POS.equals((Object)scheme.getIntegrationType())) {
            return this.removeBarcodePrefix(text).length() == scheme.getUuidLength() + scheme.getPrefix().length();
        }
        if (GiftVoucherIntegrationType.Hive.equals((Object)scheme.getIntegrationType())) {
            return text.length() == scheme.getUuidLength();
        }
        return false;
    }

    public boolean uuidMatchesLongestSchemeUuidLength(String text) {
        String uuid = this.removeBarcodePrefix(text);
        for (GiftVoucherConfiguration scheme : this.schemes) {
            if (uuid.length() != this.longestUuidLength) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnoughCharacters(String text) {
        if (this.shortestUuidLength == 0) {
            return true;
        }
        int length = text.length();
        return length >= this.shortestUuidLength - 1 && length <= this.longestUuidLength + 1;
    }

    public String stripRepeat(String text) {
        if (text != null && text.length() > this.shortestUuidLength * 2 && text.length() % 2 == 0) {
            for (GiftVoucherConfiguration config : this.schemes) {
                String substring;
                if (config.getUuidLength() > 0 && config.getUuidLength() + config.getPrefix().length() == text.length() / 2 && (substring = text.substring(0, config.getUuidLength() + config.getPrefix().length())).equals(text.substring(substring.length(), text.length()))) {
                    return substring;
                }
                if (config.getUuidLength() <= 0 || config.getUuidLength() + 2 + config.getPrefix().length() != text.length() / 2 || !(substring = text.substring(0, 2 + config.getUuidLength() + config.getPrefix().length())).equals(text.substring(substring.length(), text.length()))) continue;
                return substring;
            }
        }
        return null;
    }
}

