/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.InventoryPriceAdjustmentI;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.SystemCurrentInfo;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_price_adjustment")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
public abstract class InventoryPriceAdjustment
extends PersistentDisplayableObject
implements Sequenced,
Saveable,
InventoryPriceAdjustmentI,
ExportableObject {
    public static final Props Properties = new Props();
    private Double percentage;
    private Price flatPrice;
    private Price dollarAmount;
    private Price capAmount;
    private PriceAdjustmentUnit unit = PriceAdjustmentUnit.DOLLAR_UNIT;
    private PriceAdjustmentDirection direction = PriceAdjustmentDirection.DISCOUNT;
    private Reference<FinanceUnit> financeUnit;
    protected PriceAdjustmentLevel level;
    private Boolean displayable;
    private Boolean openPrice;
    private static final LocalCacheListManager<InventoryPriceAdjustment> allActivePriceAdjustments = new LocalCacheListManager<InventoryPriceAdjustment>(Query.createQueryList(InventoryPriceAdjustment.class, Query.select(InventoryPriceAdjustment.class).active(InventoryPriceAdjustment.class).orderBy(InventoryPriceAdjustment.Properties.ID)));
    private PriceAdjustmentType type;
    private int sequence;
    private SystemState systemState;
    private Long masterId;

    public static List<InventoryPriceAdjustment> getAllPriceAdjustments() {
        return allActivePriceAdjustments.getList();
    }

    @Override
    public SalesPriceAdjustment createSalesPriceAdjustment(PriceAdjustable adjustable, EventContext context) {
        return this.createSalesPriceAdjustment(Collections.singletonList(adjustable), context);
    }

    public SalesPriceAdjustment createSalesPriceAdjustment(Collection adjustables, EventContext context) {
        SalesPriceAdjustment salesAdj = this.getUnit().constructSalesPriceAdjustment(this, context);
        salesAdj.setType(this.getType());
        for (PriceAdjustable adjustable : adjustables) {
            if (adjustable.hasPriceAdjustment(this)) {
                SalesPriceAdjustment adj = adjustable.getPriceAdjustment(this);
                adjustable.removePriceAdjustment(adj, context);
            }
            adjustable.addSalesPriceAdjustment(salesAdj, context);
        }
        return salesAdj;
    }

    public InventoryPriceAdjustment() {
        this.financeUnit = this.createReference(InventoryPriceAdjustment.Properties.FINANCE_UNIT);
        this.level = PriceAdjustmentLevel.ALL;
        this.displayable = Boolean.TRUE;
        this.openPrice = Boolean.FALSE;
        this.type = PriceAdjustmentType.NORMAL;
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public InventoryPriceAdjustment(double newAmount, PriceAdjustmentUnit newUnit, PriceAdjustmentDirection newDirection, String newName, PriceAdjustmentLevel theLevel) {
        this.financeUnit = this.createReference(InventoryPriceAdjustment.Properties.FINANCE_UNIT);
        this.level = PriceAdjustmentLevel.ALL;
        this.displayable = Boolean.TRUE;
        this.openPrice = Boolean.FALSE;
        this.type = PriceAdjustmentType.NORMAL;
        this.systemState = SystemState.ACTIVE_STATE;
        this.setAmount(newAmount, newUnit);
        this.setUnit(newUnit);
        this.setLabel(newName);
        this.level = theLevel;
        this.direction = newDirection;
    }

    public void setPercentage(Double perc) {
        assert (PriceAdjustmentUnit.PERCENTAGE_UNIT.equals(this.unit)) : "Cannot call setPercentage (" + perc + ") on price adjustment that is [" + this.unit + " instead of percentage adjustment [" + PriceAdjustmentUnit.PERCENTAGE_UNIT + "]";
        if (perc != null && Math.abs(perc) > 100.0 && this.direction.equals(PriceAdjustmentDirection.DISCOUNT)) {
            throw new IllegalArgumentException("Cannot create discount or surcharge greater than 100%.  Perc:" + perc);
        }
        this.percentage = perc;
    }

    public void setDollarAmount(Price amount) {
        assert (PriceAdjustmentUnit.DOLLAR_UNIT.equals(this.unit) || PriceAdjustmentUnit.FINAL_UNIT.equals(this.unit)) : "Cannot call setDollarAmount (" + amount + ") on price adjustment that is [" + this.unit + "] instead of dollar unit adjustment [" + PriceAdjustmentUnit.DOLLAR_UNIT + "]";
        this.dollarAmount = amount;
    }

    public void setFlatPrice(Price amount) {
        assert (PriceAdjustmentUnit.FLAT_PRICE_UNIT.equals(this.unit)) : "Cannot call setFlatPrice (" + amount + ") on price adjustment that is [" + this.unit + "] instead of flat price adjustment [" + PriceAdjustmentUnit.FLAT_PRICE_UNIT + "]";
        this.flatPrice = amount;
    }

    public void setPriceLevelAmount(Price amount) {
        assert (PriceAdjustmentUnit.PRICE_LEVEL_UNIT.equals(this.unit)) : "Cannot call setPriceLevelAmount (" + amount + ") on price adjustment that is [" + this.unit + "] instead of price level price adjustment [" + PriceAdjustmentUnit.PRICE_LEVEL_UNIT + "]";
        this.direction = amount.lessThan(Price.ZERO_DOLLAR) ? PriceAdjustmentDirection.SURCHARGE : PriceAdjustmentDirection.DISCOUNT;
        this.dollarAmount = amount.lessThan(Price.ZERO_DOLLAR) ? amount.negate() : amount;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="dollar_amount")
    public Price getDollarAmount() {
        if (this.dollarAmount == null) {
            this.dollarAmount = Price.ZERO_DOLLAR;
            OrderMate.LOG.warn("Null dollar price adjustment has been found for : " + this.getID() + " " + this.getLabel());
        }
        return this.dollarAmount;
    }

    @Column(name="percentage")
    public Double getPercentage() {
        if (this.percentage == null) {
            this.percentage = new Double(0.0);
            OrderMate.LOG.warn("Null percentage adjustment has been found for :" + this.getID() + " " + this.getLabel());
        }
        return this.percentage;
    }

    @Column(name="flat_price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getFlatPrice() {
        if (this.flatPrice == null) {
            this.flatPrice = Price.ZERO_DOLLAR;
            OrderMate.LOG.warn("Null flat price adjustment has been found for : " + this.getID() + " " + this.getLabel());
        }
        return this.flatPrice;
    }

    @Transient
    public Price getPriceLevelAmount() {
        assert (PriceAdjustmentUnit.PRICE_LEVEL_UNIT.equals(this.unit)) : "Cannot call getPriceLevelAmount on price adjustment that is not a price level price adjustment";
        return this.dollarAmount;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        SystemCurrentInfo.setMenuUpdate("Inventory Price Adjustment");
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_finance_unit")
    public FinanceUnit getFinanceUnit() {
        return this.financeUnit.get();
    }

    public void setFinanceUnit(FinanceUnit financeUnit) {
        this.financeUnit.set(financeUnit);
    }

    public void setLevel(PriceAdjustmentLevel theLevel) {
        assert (theLevel != null) : "Price adjustment level cannot be null";
        this.level = theLevel;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentLevel")})
    @Column(name="level")
    public PriceAdjustmentLevel getLevel() {
        assert (this.level != null) : "Level is Null; price adjustment does not make sense without a level";
        return this.level;
    }

    public int compareTo(Object other) {
        return Sequenced.SequenceComparator.getInst().compare(this, other);
    }

    @Override
    @Transient
    public abstract PriceAdjustmentType getType();

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentUnit")})
    @Column(name="unit")
    public PriceAdjustmentUnit getUnit() {
        assert (this.unit != null) : "Unit is null; a price adjustment does not make sense without a unit.";
        return this.unit;
    }

    public void setUnit(PriceAdjustmentUnit newUnit) {
        assert (newUnit != null) : "Unit cannot be null";
        this.unit = newUnit;
        if (this.unit != null) {
            if ((this.unit.equals(PriceAdjustmentUnit.DOLLAR_UNIT) || this.unit.equals(PriceAdjustmentUnit.DOLLAR_UNIT)) && this.dollarAmount == null) {
                this.setDollarAmount(new Price(0.0, 0.001));
            } else if (this.unit.equals(PriceAdjustmentUnit.PERCENTAGE_UNIT) && this.percentage == null) {
                this.setPercentage(0.0);
            } else if (this.unit.equals(PriceAdjustmentUnit.FLAT_PRICE_UNIT) && this.flatPrice == null) {
                this.setFlatPrice(new Price(0.0, 0.001));
            }
        }
    }

    @Override
    @Column(name="direction")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentDirection")})
    public PriceAdjustmentDirection getDirection() {
        assert (this.direction != null) : "Direction is null; a price adjustment does not make sense without a direction";
        return this.direction;
    }

    @Override
    @Transient
    public String getLabel() {
        String label = super.getLabel();
        if (label == null || label.equals("")) {
            label = this.getUnit().getFormattedValue(this.getAmount().doubleValue());
            if (this.getCapAmount() != null) {
                label = label + " Cap " + this.getCapAmount();
            }
        } else if (this.shouldDisplayAmount() && !label.contains(this.getUnit().getFormattedValue(Math.abs(this.getAmount().doubleValue())))) {
            label = label + " (" + this.getUnit().getFormattedValue(Math.abs(this.getAmount().doubleValue())) + ")";
        }
        return label;
    }

    public boolean hasValue() {
        return this.dollarAmount != null && !this.dollarAmount.isZero() || this.flatPrice != null && !this.flatPrice.isZero() || this.percentage != null && !(Math.abs(this.percentage) < 0.001);
    }

    public void setAmount(double amount, PriceAdjustmentUnit theUnit) {
        this.unit = theUnit;
        this.setAmount(amount);
    }

    public void setAmount(Number amount) {
        if (this.unit.equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
            this.setPercentage(amount.doubleValue());
        } else if (this.unit.equals(PriceAdjustmentUnit.DOLLAR_UNIT) || this.unit.equals(PriceAdjustmentUnit.FINAL_UNIT)) {
            this.setDollarAmount(new Price(amount, 0.01));
        } else if (this.unit.equals(PriceAdjustmentUnit.FLAT_PRICE_UNIT)) {
            this.setFlatPrice(new Price(amount, 0.01));
        } else if (this.unit.equals(PriceAdjustmentUnit.PRICE_LEVEL_UNIT)) {
            this.setPriceLevelAmount(new Price(amount, 0.01));
        } else {
            throw new IllegalArgumentException("Not valid unit " + this.unit);
        }
    }

    @Transient
    public Number getAmount() {
        assert (this.unit != null) : "Null unit is invalid.";
        if (this.unit == null) {
            return 0;
        }
        if (this.unit.equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
            return new Double(this.getPercentage());
        }
        if (this.unit.equals(PriceAdjustmentUnit.DOLLAR_UNIT) || this.unit.equals(PriceAdjustmentUnit.FINAL_UNIT)) {
            return this.getDollarAmount();
        }
        if (this.unit.equals(PriceAdjustmentUnit.FLAT_PRICE_UNIT)) {
            return this.getFlatPrice();
        }
        if (this.unit.equals(PriceAdjustmentUnit.PRICE_LEVEL_UNIT)) {
            return this.getPriceLevelAmount();
        }
        throw new IllegalStateException("Unit is not valid : " + this.unit);
    }

    public void setOpenPrice(boolean openPrice) {
        this.openPrice = openPrice ? Boolean.TRUE : Boolean.FALSE;
    }

    @Column(name="open_price")
    public boolean isOpenPrice() {
        return this.openPrice != null ? this.openPrice : false;
    }

    public void setDisplayable(boolean isDisplayable) {
        this.displayable = isDisplayable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Column(name="is_displayable")
    public boolean isDisplayable() {
        return this.displayable != null ? this.displayable : true;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="bg_color")
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="fg_color")
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    @Override
    public void setBackgroundColor(Color newBackgroundColor) {
        super.setBackgroundColor(newBackgroundColor);
    }

    @Override
    public void setForegroundColor(Color newForegroundColor) {
        super.setForegroundColor(newForegroundColor);
    }

    protected void setDirection(PriceAdjustmentDirection newDirection) {
        this.direction = newDirection;
    }

    public void adjustDirection(PriceAdjustmentDirection newDirection) {
        if (this.isPersistent() && this.direction != null && !this.direction.equals(newDirection)) {
            throw new IllegalStateException("Cannot change the direction once created.");
        }
        this.direction = newDirection;
    }

    public void setSystemState(SystemState newSystemState) {
        this.systemState = newSystemState;
    }

    protected void setType(PriceAdjustmentType newType) {
        this.type = newType;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    protected boolean shouldDisplayAmount() {
        return !this.isOpenPrice();
    }

    @Column(name="cap")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCapAmount() {
        return this.capAmount;
    }

    public void setCapAmount(Price value) {
        this.capAmount = value;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<PriceAdjustmentUnit> UNIT;
        public PropertiedObject.Property<Price> DOLLAR_AMOUNT;
        public PropertiedObject.Property<Double> PERCENTAGE;
        public PropertiedObject.Property<Price> FLAT_PRICE;
        public PropertiedObject.Property<Price> CAP_AMOUNT;
        public PropertiedObject.Property SYSTEM_STATE;
        public PersistentObject.DerivedProperty<InventoryPriceAdjustment> AMOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryPriceAdjustment.class), "amount");
        public PropertiedObject.Property<PriceAdjustmentType> TYPE;
        public PropertiedObject.Property<PriceAdjustmentDirection> DIRECTION;
        public PropertiedObject.Property<PriceAdjustmentLevel> LEVEL;
        public PropertiedObject.Property<FinanceUnit> FINANCE_UNIT;
        public PropertiedObject.Property OPEN_PRICE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property DISPLAYABLE;
        public PropertiedObject.Property MASTER_ID;
    }
}

