/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentI;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.CouponPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.OpenPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.inventory.PriceLevelPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.TradingDayAdjustment;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.inventory.coupon.PriceAdjustmentCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class PriceAdjustmentManager {
    private final LocalCacheListManager<TriggeredPriceAdjustment> automaticAdjustments;
    private final LocalCacheListManager<TriggeredPriceAdjustment> displayableAdjustments;
    private final LocalCacheListManager<InventoryPriceAdjustment> systemAdjustments;
    private static final ExperimentalFeature autoAdjustRefresh = ExperimentalFeature.find("Refresh Automatic Adjustment On Call");
    private static final PriceAdjustmentManager instance = new PriceAdjustmentManager();

    private PriceAdjustmentManager() {
        this.automaticAdjustments = new LocalCacheListManager<TriggeredPriceAdjustment>(Query.createQueryList(TriggeredPriceAdjustment.class, Query.select(InventoryPriceAdjustment.class).active(InventoryPriceAdjustment.class).not().equals(TriggeredPriceAdjustment.Properties.AUTOMATIC, false).orderBy(TriggeredPriceAdjustment.Properties.SEQUENCE).orderBy(TriggeredPriceAdjustment.Properties.ID)));
        this.displayableAdjustments = new LocalCacheListManager<TriggeredPriceAdjustment>(Query.createQueryList(TriggeredPriceAdjustment.class, Query.select(InventoryPriceAdjustment.class).wherePropertyIn(TriggeredPriceAdjustment.Properties.TYPE, PriceAdjustmentType.triggeredTypes.values()).active(InventoryPriceAdjustment.class).not().equals(InventoryPriceAdjustment.Properties.DISPLAYABLE, false).orderBy(TriggeredPriceAdjustment.Properties.SEQUENCE).orderBy(TriggeredPriceAdjustment.Properties.ID)));
        this.systemAdjustments = new LocalCacheListManager<InventoryPriceAdjustment>(Query.createQueryList(InventoryPriceAdjustment.class, Query.select(InventoryPriceAdjustment.class).active(InventoryPriceAdjustment.class).equals(InventoryPriceAdjustment.Properties.DISPLAYABLE, false).equals(TriggeredPriceAdjustment.Properties.AUTOMATIC, false).not().equals(InventoryPriceAdjustment.Properties.TYPE, PriceAdjustmentType.CUSTOM).orderBy(InventoryPriceAdjustment.Properties.SEQUENCE).orderBy(TriggeredPriceAdjustment.Properties.ID)));
    }

    public static PriceAdjustmentManager getInstance() {
        return instance;
    }

    public List<TriggeredPriceAdjustment> getAutomaticAdjustments() {
        if (autoAdjustRefresh != null && autoAdjustRefresh.getBooleanValue(false).booleanValue()) {
            this.clearAutomaticAdjustmentsCache();
        }
        return this.automaticAdjustments.getList();
    }

    public List<InventoryPriceAdjustment> getSystemPriceAdjustments() {
        return this.systemAdjustments.getList();
    }

    public Collection<InventoryPriceAdjustment> getAllPriceAdjustments() {
        List<TriggeredPriceAdjustment> autoAdjustments = this.getAutomaticAdjustments();
        List<TriggeredPriceAdjustment> dispAdjustments = this.getDisplayablePriceAdjustments();
        List<InventoryPriceAdjustment> systemAdjustment = this.getSystemPriceAdjustments();
        HashSet<InventoryPriceAdjustment> adjustmentSet = new HashSet<InventoryPriceAdjustment>((autoAdjustments.size() + dispAdjustments.size()) * 2 + systemAdjustment.size());
        adjustmentSet.addAll(dispAdjustments);
        adjustmentSet.addAll(autoAdjustments);
        adjustmentSet.addAll(systemAdjustment);
        return adjustmentSet;
    }

    public InventoryPriceAdjustment createCustomDiscount(double value, PriceAdjustmentUnit unit) {
        return PriceAdjustmentFactory.getInstance().createCustomDiscount(value, unit);
    }

    public InventoryPriceAdjustment createCustomSurcharge(double value, PriceAdjustmentUnit unit) {
        return PriceAdjustmentFactory.getInstance().createCustomSurcharge(value, unit);
    }

    public List<TriggeredPriceAdjustment> getDisplayablePriceAdjustments() {
        return this.displayableAdjustments.getList();
    }

    public Collection getActiveDisplayablePriceAdjustments(TriggerActivationContext context) {
        List<TriggeredPriceAdjustment> nonAutoDisplayableDiscounts = this.getDisplayablePriceAdjustments();
        return TriggerActivationHelper.getActive(nonAutoDisplayableDiscounts, context);
    }

    public List<TriggeredPriceAdjustment> getAllDollarAmountDiscounts() {
        return this.getMatching(this.getDisplayablePriceAdjustments(), PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.DISCOUNT);
    }

    public List getAllPercentageDiscounts() {
        return this.getMatching(this.getDisplayablePriceAdjustments(), PriceAdjustmentUnit.PERCENTAGE_UNIT, PriceAdjustmentDirection.DISCOUNT);
    }

    public List getAllDollarAmountSurcharges() {
        return this.getMatching(this.getDisplayablePriceAdjustments(), PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.SURCHARGE);
    }

    public List getAllPercentageSurcharges() {
        return this.getMatching(this.getDisplayablePriceAdjustments(), PriceAdjustmentUnit.PERCENTAGE_UNIT, PriceAdjustmentDirection.SURCHARGE);
    }

    public List getDiscounts(PriceAdjustmentUnit unit, PriceAdjustmentLevel level) {
        return this.getMatching(this.getDisplayablePriceAdjustments(), unit, PriceAdjustmentDirection.DISCOUNT, level);
    }

    public List getDiscounts(PriceAdjustmentType type, PriceAdjustmentLevel level) {
        return this.getMatching(this.getAllPriceAdjustments(), PriceAdjustmentDirection.DISCOUNT, level, type);
    }

    public List getSurcharges(PriceAdjustmentUnit unit, PriceAdjustmentLevel level) {
        return this.getMatching(this.getDisplayablePriceAdjustments(), unit, PriceAdjustmentDirection.SURCHARGE, level);
    }

    public List getSurcharges(PriceAdjustmentType type, PriceAdjustmentLevel level) {
        return this.getMatching(this.getDisplayablePriceAdjustments(), PriceAdjustmentDirection.SURCHARGE, level, type);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentDirection direction, final PriceAdjustmentLevel level, final PriceAdjustmentType type) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adjustment) {
                return direction.equals(adjustment.getDirection()) && level.matches(adjustment.getLevel()) && type.equals(adjustment.getType());
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public List getMatching(Collection<? extends PriceAdjustmentI> adjustments, final PriceAdjustmentUnit unit, final PriceAdjustmentDirection direction, final PriceAdjustmentLevel level) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adjustment) {
                return adjustment.getUnit().equals(unit) && direction.equals(adjustment.getDirection()) && level.matches(adjustment.getLevel());
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public List getMatching(Collection<? extends PriceAdjustmentI> adjustments, final PriceAdjustmentUnit unit, final PriceAdjustmentLevel level) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adjustment) {
                return adjustment.getUnit().equals(unit) && level.matches(adjustment.getLevel());
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentUnit unit, final PriceAdjustmentDirection direction) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adjustment) {
                return adjustment.getUnit().equals(unit) && direction.equals(adjustment.getDirection());
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentUnit unit) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adjustment) {
                return adjustment.getUnit().equals(unit);
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentDirection direction) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adj) {
                return adj.getDirection().equals(direction);
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentDirection direction, final PriceAdjustmentType type, final PriceAdjustmentUnit unit) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adj) {
                return adj.getDirection().equals(direction) && adj.getUnit().equals(unit) && adj.getType().equals(type);
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentDirection direction, final PriceAdjustmentType type) {
        return this.applyMatcher(adjustments, new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adj) {
                return adj.getDirection().equals(direction) && adj.getType().equals(type);
            }
        });
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentType type) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adj) {
                return adj.getType().equals(type);
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> getMatching(Collection<T> adjustments, final PriceAdjustmentType type, final PriceAdjustmentLevel level) {
        Matcher matcher = new Matcher(){

            @Override
            public boolean match(PriceAdjustmentI adj) {
                return type.equals(adj.getType()) && level.matches(adj.getLevel());
            }
        };
        return this.applyMatcher(adjustments, matcher);
    }

    public <T extends PriceAdjustmentI> List<T> applyMatcher(Collection<T> adjustments, Matcher matcher) {
        ArrayList<PriceAdjustmentI> matches = new ArrayList<PriceAdjustmentI>();
        for (PriceAdjustmentI adjustment : adjustments) {
            if (adjustment == null || !matcher.match(adjustment)) continue;
            matches.add(adjustment);
        }
        return matches;
    }

    public InventoryPriceAdjustment getTradingDayAdjustments(TradingDay day) {
        List<TriggeredPriceAdjustment> adjustments = PriceAdjustmentManager.getInstance().getMatching(this.getAutomaticAdjustments(), PriceAdjustmentType.DAILY);
        for (TradingDayAdjustment tradingDayAdjustment : adjustments) {
            if (tradingDayAdjustment.getTradingDay() == null || !tradingDayAdjustment.getTradingDay().equals(day)) continue;
            return tradingDayAdjustment;
        }
        return null;
    }

    public DeliveryPriceAdjustment getDeliveryFee() {
        DeliveryPriceAdjustment adj = SystemProperty.getInstance().getDeliveryFee();
        if (adj == null) {
            OrderMate.LOG.warn("Delivery fee was null, creating new delivery fee.");
            adj = (DeliveryPriceAdjustment)PriceAdjustmentFactory.getInstance().createTriggeredPriceAdjustment(PriceAdjustmentDirection.SURCHARGE, 0.0, PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentType.DELIVERY_SURCHARGE, "Delivery Fee");
            this.clearCachedAdjustments();
            adj.save();
            return adj;
        }
        return adj;
    }

    public PriceLevelPriceInvAdjustment getPriceLevelAdjustment() {
        return PriceAdjustmentType.PRICE_LEVEL.getPriceLevelAdjustment();
    }

    public FinalPriceInvAdjustment getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier type, FinanceUnit financeUnit) {
        switch (type) {
            case COMBO: {
                return PriceAdjustmentType.FINAL.getOrCreateFinalPriceAdjustment(type, financeUnit);
            }
        }
        return PriceAdjustmentType.FINAL_PAYMENT.getOrCreateFinalPriceAdjustment(type, financeUnit);
    }

    public List<FinalPriceInvAdjustment> getFinalPriceAdjustments() {
        ArrayList<FinalPriceInvAdjustment> list = new ArrayList<FinalPriceInvAdjustment>();
        list.addAll(PriceAdjustmentType.FINAL.getFinalPriceAdjustments());
        list.addAll(PriceAdjustmentType.FINAL_PAYMENT.getFinalPriceAdjustments());
        return list;
    }

    public void clearCachedAdjustments() {
        this.displayableAdjustments.clearCache();
        this.automaticAdjustments.clearCache();
        this.systemAdjustments.clearCache();
        SystemProperty.clearCache();
    }

    public void clearAutomaticAdjustmentsCache() {
        if (this.automaticAdjustments != null) {
            this.automaticAdjustments.clearCache();
        }
    }

    public OpenPriceAdjustment getOpenPriceDiscount() {
        return this.getOpenPriceAdjustment(PriceAdjustmentDirection.DISCOUNT);
    }

    public OpenPriceAdjustment getOpenPriceSurcharge() {
        return this.getOpenPriceAdjustment(PriceAdjustmentDirection.SURCHARGE);
    }

    private OpenPriceAdjustment getOpenPriceAdjustment(PriceAdjustmentDirection direction) {
        List<InventoryPriceAdjustment> adjustments = this.getMatching(this.getSystemPriceAdjustments(), direction, PriceAdjustmentType.OPEN_PRICE);
        if (adjustments.isEmpty()) {
            OpenPriceAdjustment adj = (OpenPriceAdjustment)PriceAdjustmentFactory.getInstance().createInventoryPriceAdjustment(direction, 0.0, PriceAdjustmentUnit.FLAT_PRICE_UNIT, PriceAdjustmentType.OPEN_PRICE, PriceAdjustmentDirection.DISCOUNT.equals(direction) ? "Open Price discount" : "Open Price surcharge");
            this.clearCachedAdjustments();
            PersistenceManager.save(adj);
            return adj;
        }
        if (adjustments.size() > 1) {
            Iterator<InventoryPriceAdjustment> it = adjustments.iterator();
            it.next();
            while (it.hasNext()) {
                ((Saveable)it.next()).delete();
                it.remove();
            }
            this.clearCachedAdjustments();
        }
        return (OpenPriceAdjustment)adjustments.get(0);
    }

    public Price getSalesItemUsageValueForAccountLevelAdjustments(Collection salesLineItems, PriceAdjustmentUnit unit) {
        Price totalAccountLevelValue = Price.ZERO_DOLLAR;
        for (SalesLineItem currentLineItem : salesLineItems) {
            for (SalesItem currentItem : currentLineItem.getSalesItems()) {
                for (SalesComponent currentComp : currentItem.getComponentList()) {
                    for (SalesPriceAdjustmentUsage usage : currentComp.getPriceAdjustmentUsages()) {
                        SalesPriceAdjustment adjustment = usage.getSalesPriceAdjustment();
                        if (!adjustment.getUnit().equals(unit) || !adjustment.getLevel().equals(PriceAdjustmentLevel.ACCOUNT_LEVEL)) continue;
                        totalAccountLevelValue = totalAccountLevelValue.add(usage.getUnitValue().multiply(currentItem.getQuantity()));
                    }
                }
            }
        }
        return totalAccountLevelValue;
    }

    public Price getUsageValueForItems(Collection salesLineItems, boolean includePriceLevelAdj) {
        Price value = new Price(0.0, 0.0);
        for (SalesLineItem currentLineItem : salesLineItems) {
            for (SalesItem item : currentLineItem.getSalesItems()) {
                for (SalesComponent component : item.getComponentList()) {
                    for (SalesPriceAdjustmentUsage usage : component.getPriceAdjustmentUsages()) {
                        SalesPriceAdjustment adjustment = usage.getSalesPriceAdjustment();
                        if (!adjustment.getLevel().equals(PriceAdjustmentLevel.ITEM_LEVEL) || PriceAdjustmentType.PRICE_LEVEL.equals(adjustment.getType()) && !includePriceLevelAdj) continue;
                        value = value.add(usage.getUnitValue().multiply(item.getQuantity()));
                    }
                }
            }
        }
        return value;
    }

    public Price getUsageValueForItems(SalesPriceAdjustment adjustment, Collection<SalesLineItem> salesLineItems) {
        Price value = Price.ZERO_NO_ROUND;
        for (SalesLineItem lineItem : salesLineItems) {
            value = value.add(this.getValue(adjustment, lineItem));
        }
        return value;
    }

    Price getUsageValueForAccount(SalesPriceAdjustment adjustment, Account account) {
        return this.getUsageValueForItems(adjustment, account.getItems());
    }

    public Price getValue(SalesPriceAdjustment adjustment, SalesLineItem lineItem) {
        Price value = new Price(0.0, 1.0E-4);
        for (SalesItem item : lineItem.getSalesItems()) {
            for (SalesPriceAdjustmentUsage usage : adjustment.getPriceAdjustmentUsagesSafe()) {
                if (!item.getComponentList().contains(usage.getSalesComponent())) continue;
                value = value.add(usage.getUnitValue().multiply(item.getQuantity()));
            }
        }
        return value;
    }

    public CouponPriceAdjustment getCouponPriceAdjustment(PriceAdjustmentCoupon coupon) {
        CouponPriceAdjustment adj = PersistenceManager.getObject(CouponPriceAdjustment.class, Query.select(CouponPriceAdjustment.class).equals(CouponPriceAdjustment.Properties.COUPON, coupon).active(CouponPriceAdjustment.class).toString());
        if (adj == null) {
            adj = new CouponPriceAdjustment(coupon);
            adj.save();
        }
        return adj;
    }

    public static interface Matcher {
        public boolean match(PriceAdjustmentI var1);
    }
}

