/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_price_adjustment_trigger_link")
@AccessType(value="property")
public class PriceAdjustmentTriggerLink
extends PersistentObject
implements SaveableChild,
TriggerLink {
    public static final Props Properties = new Props();
    private Reference<AbstractTrigger> trigger;
    private Reference<InventoryPriceAdjustment> inventoryPriceAdjustment;

    public PriceAdjustmentTriggerLink() {
        this.trigger = this.createReference(PriceAdjustmentTriggerLink.Properties.TRIGGER);
        this.inventoryPriceAdjustment = this.createReference(PriceAdjustmentTriggerLink.Properties.INVENTORY_PRICE_ADJUSTMENT);
    }

    public PriceAdjustmentTriggerLink(TriggeredPriceAdjustment adj, AbstractTrigger trig) {
        this.trigger = this.createReference(PriceAdjustmentTriggerLink.Properties.TRIGGER);
        this.inventoryPriceAdjustment = this.createReference(PriceAdjustmentTriggerLink.Properties.INVENTORY_PRICE_ADJUSTMENT);
        this.setTrigger(trig);
        this.setInventoryPriceAdjustment(adj);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_price_adjustment")
    public TriggeredPriceAdjustment getInventoryPriceAdjustment() {
        return (TriggeredPriceAdjustment)this.inventoryPriceAdjustment.get();
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_inventory_trigger")
    public AbstractTrigger getTrigger() {
        if (this.trigger == null) {
            OrderMate.LOG.warn("The instance is not initialized, cannot get a trigger.", (Throwable)new Exception());
            return null;
        }
        return this.trigger.get();
    }

    public void setTrigger(AbstractTrigger trig) {
        this.trigger.set(trig);
    }

    public void setInventoryPriceAdjustment(TriggeredPriceAdjustment adj) {
        if (this.inventoryPriceAdjustment == null) {
            OrderMate.LOG.warn("The instance is not initialized, cannot set a trigger.", (Throwable)new Exception());
            return;
        }
        this.inventoryPriceAdjustment.set(adj);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (!this.getTrigger().isPersistent()) {
            throw new IllegalStateException("Trigger must be persisted before saving this link.");
        }
        if (!this.getInventoryPriceAdjustment().isPersistent()) {
            throw new IllegalStateException("Price adjustment must be persisted before saving this link");
        }
        PersistenceManager.saveChild(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryPriceAdjustment> INVENTORY_PRICE_ADJUSTMENT;
        public PropertiedObject.Property<AbstractTrigger> TRIGGER;
    }
}

