/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.util.Collection;
import java.util.Map;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.DollarPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.FlatPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PercentagePriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PriceLevelSalesPriceAdjustment;

public abstract class PriceAdjustmentUnit
extends PersistentEnumeration {
    private static final long serialVersionUID = 1L;
    public static final PriceAdjustmentUnit DOLLAR_UNIT = new PriceAdjustmentUnit("Dollar Amount"){
        private static final long serialVersionUID = 1L;

        @Override
        protected Price getAdjustmentValue(PriceAdjustmentDirection direction, Price total, double adjValue) {
            double value = adjValue;
            if (direction.equals(PriceAdjustmentDirection.DISCOUNT)) {
                value = total.doubleValue() < 0.0 ? Math.max(total.doubleValue(), value) : Math.min(total.doubleValue(), value);
            }
            return new Price(direction.applySign(value), 1.0E-4);
        }

        @Override
        protected SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context) {
            return new DollarPriceAdjustment(adj, adj.getDollarAmount(), context);
        }
    };
    public static final PriceAdjustmentUnit PERCENTAGE_UNIT = new PriceAdjustmentUnit("Percentage Amount"){
        private static final long serialVersionUID = 1L;

        @Override
        public String getFormattedValue(double value) {
            return FinanceUtils.formatAsPercentage(value);
        }

        @Override
        protected Price getAdjustmentValue(PriceAdjustmentDirection direction, Price total, double value) {
            return total.multiply(direction.applySign(value / 100.0));
        }

        @Override
        protected SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context) {
            return new PercentagePriceAdjustment(adj, adj.getPercentage(), context);
        }
    };
    public static final PriceAdjustmentUnit FLAT_PRICE_UNIT = new PriceAdjustmentUnit("Flat Price Amount"){
        private static final long serialVersionUID = 1L;

        @Override
        protected Price getAdjustmentValue(PriceAdjustmentDirection direction, Price total, double value) {
            return new Price(total.doubleValue() - value, 1.0E-4);
        }

        @Override
        protected SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context) {
            return new FlatPriceAdjustment(adj, context);
        }
    };
    public static final PriceAdjustmentUnit FINAL_UNIT = new PriceAdjustmentUnit("Final Amount"){
        private static final long serialVersionUID = 1L;

        @Override
        protected Price getAdjustmentValue(PriceAdjustmentDirection direction, Price total, double adjValue) {
            double value = adjValue;
            if (direction.equals(PriceAdjustmentDirection.DISCOUNT)) {
                value = total.doubleValue() < 0.0 ? Math.max(total.doubleValue(), value) : Math.min(total.doubleValue(), value);
            }
            return new Price(direction.applySign(value), 1.0E-4);
        }

        @Override
        protected SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context) {
            return new FinalSalesPriceAdjustment(adj, adj.getDollarAmount(), context);
        }
    };
    public static final PriceAdjustmentUnit PRICE_LEVEL_UNIT = new PriceAdjustmentUnit("Price Level Amount"){
        private static final long serialVersionUID = 1L;

        @Override
        protected Price getAdjustmentValue(PriceAdjustmentDirection direction, Price total, double adjValue) {
            double value = adjValue;
            if (direction.equals(PriceAdjustmentDirection.DISCOUNT)) {
                value = total.doubleValue() < 0.0 ? Math.max(total.doubleValue(), value) : Math.min(total.doubleValue(), value);
            }
            return new Price(direction.applySign(value), 1.0E-4);
        }

        @Override
        protected SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context) {
            return new PriceLevelSalesPriceAdjustment(adj, context, adj.getDollarAmount());
        }
    };
    public static final Map register;

    public static Map getRegister() {
        return register;
    }

    protected abstract Price getAdjustmentValue(PriceAdjustmentDirection var1, Price var2, double var3);

    protected abstract SalesPriceAdjustment constructSalesPriceAdjustment(InventoryPriceAdjustment var1, EventContext var2);

    public static Collection getAll() {
        return register.values();
    }

    private PriceAdjustmentUnit(String newLabel) {
        super(newLabel);
    }

    public String getFormattedValue(double value) {
        return new Price(value, 0.01).toString();
    }

    static {
        PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentUnit> builder = new PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentUnit>();
        builder.put(DOLLAR_UNIT);
        builder.put(PERCENTAGE_UNIT);
        builder.put(FLAT_PRICE_UNIT);
        builder.put(PRICE_LEVEL_UNIT);
        builder.put(FINAL_UNIT);
        register = builder.getMap();
    }
}

