/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_item_price_adjustment_link")
@AccessType(value="property")
public class SalesItemPriceAdjustmentLink
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<SalesLineItem> salesLineItem;
    private Reference<SalesPriceAdjustment> salesPriceAdjustment;

    public SalesItemPriceAdjustmentLink() {
        this.salesLineItem = this.createReference(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM);
        this.salesPriceAdjustment = this.createReference(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT);
    }

    public SalesItemPriceAdjustmentLink(SalesLineItem item, SalesPriceAdjustment adj) {
        this.salesLineItem = this.createReference(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM);
        this.salesPriceAdjustment = this.createReference(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT);
        if (item == null) {
            throw new NullPointerException("Sales line item cannot be null");
        }
        if (adj == null) {
            throw new NullPointerException("Sales price adjustment cannot be null");
        }
        this.salesLineItem.set(item);
        this.salesPriceAdjustment.set(adj);
        adj.addSalesLineItemLink(this);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_sales_line_item")
    public SalesLineItem getSalesLineItem() {
        return this.salesLineItem.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_price_adjustment")
    public SalesPriceAdjustment getSalesPriceAdjustment() {
        return this.salesPriceAdjustment.get();
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (!this.getSalesLineItem().isPersistent()) {
            throw new IllegalStateException("Sales line item must be perisstent before saving this link");
        }
        this.salesPriceAdjustment.saveChild();
        PersistenceManager.saveChild(this);
    }

    protected void setSalesLineItem(SalesLineItem salesLineItem) {
        this.salesLineItem.set(salesLineItem);
    }

    protected void setSalesPriceAdjustment(SalesPriceAdjustment salesPriceAdjustment) {
        this.salesPriceAdjustment.set(salesPriceAdjustment);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SalesLineItem> SALES_LINE_ITEM;
        public PropertiedObject.Property<SalesPriceAdjustment> SALES_PRICE_ADJUSTMENT;
    }
}

