/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentI;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesItemPriceAdjustmentLink;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.users.User;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_price_adjustment")
@DiscriminatorColumn(name="unit")
@AccessType(value="property")
public abstract class SalesPriceAdjustment
extends PersistentDisplayableObject
implements SaveableChild,
SalesPriceAdjustmentI {
    public static final Props Properties = new Props();
    private Date timestamp = new Date();
    private PriceAdjustmentUnit unit = null;
    private PriceAdjustmentLevel level = null;
    private PriceAdjustmentType type = PriceAdjustmentType.NORMAL;
    private PriceAdjustmentDirection direction;
    private Reference<User> user;
    private Reference<InventoryPriceAdjustment> inventoryPriceAdjustment;
    private Reference<TradingDay> tradingDay;
    private Reference<Shift> shift;
    private Reference<Terminal> terminal;
    private Reference<SalesLocation> salesLocation;
    private Reference<Account> account;
    private PersistentList<SalesItemPriceAdjustmentLink> salesItemLinks;
    private PersistentWriteableList<SalesPriceAdjustmentUsage> priceAdjustmentUsages;
    private String reason;
    private String source;
    private Reference<Customer> customer;

    public SalesPriceAdjustment() {
        this.user = this.createReference(SalesPriceAdjustment.Properties.USER);
        this.inventoryPriceAdjustment = this.createReference(SalesPriceAdjustment.Properties.INVENTORY_PRICE_ADJUSTMENT);
        this.tradingDay = this.createReference(SalesPriceAdjustment.Properties.TRADING_DAY);
        this.shift = this.createReference(SalesPriceAdjustment.Properties.SHIFT);
        this.terminal = this.createReference(SalesPriceAdjustment.Properties.TERMINAL);
        this.salesLocation = this.createReference(SalesPriceAdjustment.Properties.SALES_LOCATION);
        this.account = this.createReference(SalesPriceAdjustment.Properties.ACCOUNT);
        this.salesItemLinks = this.createList(SalesPriceAdjustment.Properties.SALES_ITEM_LINKS);
        this.priceAdjustmentUsages = (PersistentWriteableList)this.createList(SalesPriceAdjustment.Properties.PRICE_ADJUSTMENT_USAGES);
        this.customer = this.createReference(SalesPriceAdjustment.Properties.CUSTOMER);
    }

    protected SalesPriceAdjustment(PriceAdjustmentUnit unit) {
        this();
        this.unit = unit;
    }

    public SalesPriceAdjustment(InventoryPriceAdjustment baseAdjustment, EventContext context) {
        this.user = this.createReference(SalesPriceAdjustment.Properties.USER);
        this.inventoryPriceAdjustment = this.createReference(SalesPriceAdjustment.Properties.INVENTORY_PRICE_ADJUSTMENT);
        this.tradingDay = this.createReference(SalesPriceAdjustment.Properties.TRADING_DAY);
        this.shift = this.createReference(SalesPriceAdjustment.Properties.SHIFT);
        this.terminal = this.createReference(SalesPriceAdjustment.Properties.TERMINAL);
        this.salesLocation = this.createReference(SalesPriceAdjustment.Properties.SALES_LOCATION);
        this.account = this.createReference(SalesPriceAdjustment.Properties.ACCOUNT);
        this.salesItemLinks = this.createList(SalesPriceAdjustment.Properties.SALES_ITEM_LINKS);
        this.priceAdjustmentUsages = (PersistentWriteableList)this.createList(SalesPriceAdjustment.Properties.PRICE_ADJUSTMENT_USAGES);
        this.customer = this.createReference(SalesPriceAdjustment.Properties.CUSTOMER);
        this.unit = baseAdjustment.getUnit();
        this.setLabel(baseAdjustment.getLabel());
        this.setUser(context.getUser());
        this.shift.set(context.getShift());
        this.tradingDay.set(context.getTradingDay());
        this.inventoryPriceAdjustment.set(baseAdjustment);
        this.terminal.set(context.getTerminal());
        this.salesLocation.set(context.getTerminal().getSalesLocation());
    }

    protected SalesPriceAdjustment(SalesPriceAdjustment toClone) {
        this(toClone.getInventoryPriceAdjustment(), new EventContext(toClone.getTerminal(), toClone.getUser(), toClone.getTradingDay(), toClone.getShift()));
        this.setSalesLocation(this.salesLocation.get());
    }

    public abstract SalesPriceAdjustment copy();

    @Column(name="timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setReason(String newReason, EventContext context) {
        if (newReason != null) {
            TerminalEventLog.logCustomDiscountReason(context, this.getLabel(), newReason);
        }
        this.reason = newReason;
    }

    @Transient
    public String getReason() {
        return this.reason;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User newUser) {
        this.user.set(newUser);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer theCustomer) {
        this.customer.set(theCustomer);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SalesPriceAdjustment)) {
            return false;
        }
        SalesPriceAdjustment spa = (SalesPriceAdjustment)obj;
        if (this.isPersistent() && spa.isPersistent()) {
            return super.equals(spa);
        }
        return spa.type.equals(this.type) && spa.getLabel().equals(this.getLabel()) && spa.getDirection().equals(this.getDirection()) && spa.getUnit().equals(this.getUnit()) && spa.getInventoryPriceAdjustment().equals(this.getInventoryPriceAdjustment());
    }

    @Override
    public int hashCode() {
        if (this.isPersistent()) {
            return super.hashCode();
        }
        return new HashCodeBuilder().append((Object)this.level).append((Object)this.getDirection()).append((Object)this.getUnit()).append((Object)this.getInventoryPriceAdjustment()).toHashCode();
    }

    public boolean isEquals(SalesPriceAdjustment adj) {
        return super.equals(adj);
    }

    @Override
    @Transient
    public Price getValue() {
        if (this.getLevel().equals(PriceAdjustmentLevel.ITEM_LEVEL)) {
            return PriceAdjustmentManager.getInstance().getUsageValueForItems(this, this.getSalesLineItems());
        }
        if (this.getLevel().equals(PriceAdjustmentLevel.ACCOUNT_LEVEL)) {
            return PriceAdjustmentManager.getInstance().getUsageValueForAccount(this, this.getAccount());
        }
        return Price.ZERO_DOLLAR;
    }

    @Transient
    public Price getSavedValue() {
        Price savedTotal = new Price(0.0, 1.0E-4);
        for (SalesPriceAdjustmentUsage usage : this.getPriceAdjustmentUsagesSafe()) {
            savedTotal = savedTotal.add(usage.getSavedTotalValue());
        }
        return new Price(savedTotal, 0.01);
    }

    public Price getValue(SalesLineItem lineItem) {
        return PriceAdjustmentManager.getInstance().getValue(this, lineItem);
    }

    public abstract Price calcValue(Price var1);

    protected Price calcValue(Price amount, double value) {
        return this.getUnit().getAdjustmentValue(this.getDirection(), amount, value);
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_price_adjustment")
    public InventoryPriceAdjustment getInventoryPriceAdjustment() {
        return this.inventoryPriceAdjustment.get();
    }

    protected void setInventoryPriceAdjustment(InventoryPriceAdjustment adj) {
        this.inventoryPriceAdjustment.set(adj);
    }

    @OneToMany(mappedBy="salesPriceAdjustment", targetEntity=SalesPriceAdjustmentUsage.class, fetch=FetchType.LAZY)
    public List<SalesPriceAdjustmentUsage> getPriceAdjustmentUsages() {
        return this.priceAdjustmentUsages;
    }

    @Transient
    public List<SalesPriceAdjustmentUsage> getPriceAdjustmentUsagesSafe() {
        return new ArrayList<SalesPriceAdjustmentUsage>(this.priceAdjustmentUsages);
    }

    protected void setPriceAdjustmentUsages(List<SalesPriceAdjustmentUsage> usage) {
        this.priceAdjustmentUsages = this.priceAdjustmentUsages.clone();
        this.priceAdjustmentUsages.set(usage);
    }

    public void addPriceAdjustmentUsage(SalesPriceAdjustmentUsage usage) {
        if (usage == null) {
            return;
        }
        Iterator it = this.priceAdjustmentUsages.iterator();
        while (it.hasNext()) {
            SalesPriceAdjustmentUsage nextUsage = (SalesPriceAdjustmentUsage)it.next();
            if (!usage.getSalesComponent().equals(nextUsage.getSalesComponent())) continue;
            it.remove();
        }
        this.priceAdjustmentUsages.add(usage);
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_sales_account")
    public Account getAccount() {
        return this.account.get();
    }

    protected void setAccount(Account newAccount) {
        this.account.set(newAccount);
    }

    @Transient
    public Collection<SalesLineItem> getSalesLineItems() {
        ArrayList<SalesLineItem> salesLineItems = new ArrayList<SalesLineItem>();
        Iterator<SalesItemPriceAdjustmentLink> it = this.getSalesLineItemLinks().iterator();
        while (it.hasNext()) {
            salesLineItems.add(it.next().getSalesLineItem());
        }
        return salesLineItems;
    }

    @Transient
    protected List<SalesItemPriceAdjustmentLink> getSalesLineItemLinks() {
        return this.salesItemLinks.getUnmodifiable();
    }

    protected void addSalesLineItemLink(SalesItemPriceAdjustmentLink link) {
        if (!this.salesItemLinks.contains(link)) {
            this.salesItemLinks.add(link);
        }
    }

    public boolean removeSalesLineItemLink(SalesItemPriceAdjustmentLink link) {
        return this.salesItemLinks.remove(link);
    }

    @Override
    public void deleteChild() {
        this.tearDownUsages();
        PersistenceManager.deleteChild(this);
        this.priceAdjustmentUsages.deleteChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        if (this.getAccount() == null && this.getSalesLineItems().isEmpty()) {
            this.deleteChild();
            return;
        }
        if (!this.getInventoryPriceAdjustment().isPersistent()) {
            this.getInventoryPriceAdjustment().save();
        }
        this.direction = this.getDirection();
        this.type = this.getType();
        this.level = this.getLevel();
        PersistenceManager.saveChild(this);
    }

    public boolean matchesTypeAndUnit(PriceAdjustmentI adjustment) {
        InventoryPriceAdjustment theInvPriceAdj = this.getInventoryPriceAdjustment();
        return theInvPriceAdj.getType().equals(adjustment.getType()) && theInvPriceAdj.getUnit().equals(adjustment.getUnit()) && theInvPriceAdj.getDirection().equals(adjustment.getDirection());
    }

    @Override
    @Column(name="direction")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentDirection")})
    public PriceAdjustmentDirection getDirection() {
        InventoryPriceAdjustment theInvPriceAdj = this.getInventoryPriceAdjustment();
        if (this.direction == null && theInvPriceAdj != null) {
            this.direction = theInvPriceAdj.getDirection();
        }
        return this.direction;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentUnit")})
    @Column(name="unit", insertable=false, updatable=false)
    public PriceAdjustmentUnit getUnit() {
        return this.unit;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType")})
    @Column(name="type")
    public PriceAdjustmentType getType() {
        InventoryPriceAdjustment theInvPriceAdj = this.getInventoryPriceAdjustment();
        if (theInvPriceAdj != null) {
            return theInvPriceAdj.getType();
        }
        return PriceAdjustmentType.CUSTOM;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentLevel")})
    @Column(name="level")
    public PriceAdjustmentLevel getLevel() {
        if (this.level == null) {
            this.level = this.determineLevel();
        }
        return this.level;
    }

    private PriceAdjustmentLevel determineLevel() {
        if (this.getAccount() != null) {
            return PriceAdjustmentLevel.ACCOUNT_LEVEL;
        }
        if (this.getSalesLineItemLinks().size() > 0) {
            return PriceAdjustmentLevel.ITEM_LEVEL;
        }
        return null;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal")
    protected Terminal getTerminal() {
        return this.terminal.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    protected TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_shift")
    protected Shift getShift() {
        return this.shift.get();
    }

    @Transient
    public EventContext getCreationContext() {
        return new EventContext(this.getTerminal(), this.getUser(), this.getTradingDay(), this.getShift());
    }

    public void removePriceAdjustmentUsage(SalesPriceAdjustmentUsage usage) {
        this.priceAdjustmentUsages.remove(usage);
    }

    public void collapseUsages() {
        this.priceAdjustmentUsages.collapseUnsafe();
    }

    public void tearDownUsages() {
        ArrayList<SalesPriceAdjustmentUsage> changeList = new ArrayList<SalesPriceAdjustmentUsage>(this.priceAdjustmentUsages);
        for (SalesPriceAdjustmentUsage usage : changeList) {
            usage.clearReferences();
        }
        this.priceAdjustmentUsages.clear();
    }

    @Override
    public String toString() {
        return this.getLabel() != null ? this.getLabel() : this.getAccount() + "-" + (this.getInventoryPriceAdjustment() == null ? "Adjustement undefined" : this.getInventoryPriceAdjustment()) + "-" + (this.getLevel() == null ? "Level undefined" : this.getLevel()) + "-" + (this.getDirection() == null ? "Direction undefined" : this.getDirection());
    }

    protected void setDirection(PriceAdjustmentDirection newDirection) {
        this.direction = newDirection;
    }

    protected void setUnit(PriceAdjustmentUnit newUnit) {
        this.unit = newUnit;
    }

    @OneToMany(mappedBy="salesPriceAdjustment", targetEntity=SalesItemPriceAdjustmentLink.class, fetch=FetchType.LAZY)
    protected List<SalesItemPriceAdjustmentLink> getSalesItemLinks() {
        return this.salesItemLinks;
    }

    protected void setSalesItemLinks(List<SalesItemPriceAdjustmentLink> newSalesItemLinks) {
        this.salesItemLinks = this.salesItemLinks.clone();
        this.salesItemLinks.set(newSalesItemLinks);
    }

    protected void setLevel(PriceAdjustmentLevel newLevel) {
        this.level = newLevel;
    }

    protected void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
    }

    protected void setTradingDay(TradingDay newTradingDay) {
        this.tradingDay.set(newTradingDay);
    }

    protected void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    protected void setTimestamp(Date newTimestamp) {
        this.timestamp = newTimestamp;
    }

    protected void setType(PriceAdjustmentType newType) {
        this.type = newType;
    }

    @Transient
    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    protected void setSalesLocation(SalesLocation newLoc) {
        this.salesLocation.set(newLoc);
    }

    @Transient
    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<Date> TIMESTAMP;
        public PropertiedObject.Property<PriceAdjustmentUnit> UNIT;
        public PropertiedObject.Property<PriceAdjustmentType> TYPE;
        public PropertiedObject.Property<PriceAdjustmentLevel> LEVEL;
        public PropertiedObject.Property<PriceAdjustmentDirection> DIRECTION;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<SalesItemPriceAdjustmentLink> SALES_ITEM_LINKS;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<InventoryPriceAdjustment> INVENTORY_PRICE_ADJUSTMENT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<SalesPriceAdjustmentUsage> PRICE_ADJUSTMENT_USAGES;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<String> SOURCE;
    }
}

