/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentTriggerLink;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public abstract class TriggeredPriceAdjustment
extends InventoryPriceAdjustment
implements TriggerActivated {
    public static final Props Properties = new Props();
    private boolean automatic = false;
    protected PersistentWriteableList<PriceAdjustmentTriggerLink> triggerLink;
    private TriggerActivationStrategy triggerActivationStrategy;

    protected TriggeredPriceAdjustment() {
        this.triggerLink = (PersistentWriteableList)this.createList(TriggeredPriceAdjustment.Properties.TRIGGER_LINK);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    }

    protected TriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        super(amount, unit, direction, "New " + direction.toString(), PriceAdjustmentLevel.ALL);
        this.triggerLink = (PersistentWriteableList)this.createList(TriggeredPriceAdjustment.Properties.TRIGGER_LINK);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        HashSet<AbstractTrigger> triggerSet = new HashSet<AbstractTrigger>();
        for (PriceAdjustmentTriggerLink link : this.triggerLink) {
            if (link.getTrigger() == null) continue;
            triggerSet.add(link.getTrigger());
        }
        return new ArrayList<AbstractTrigger>(triggerSet);
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger triggerToAdd) {
        if (triggerToAdd != null) {
            if (!triggerToAdd.isPersistent()) {
                throw new IllegalStateException("Trigger should be persisted before adding to price adjustment" + triggerToAdd);
            }
            if (!this.getTriggers().contains(triggerToAdd)) {
                PriceAdjustmentTriggerLink link = new PriceAdjustmentTriggerLink(this, triggerToAdd);
                this.triggerLink.add(link);
                return link;
            }
        }
        return null;
    }

    @Override
    public boolean removeTrigger(AbstractTrigger triggerToRemove) {
        boolean removed = false;
        Iterator iter = this.triggerLink.iterator();
        while (iter.hasNext()) {
            PriceAdjustmentTriggerLink link = (PriceAdjustmentTriggerLink)iter.next();
            if (!link.getTrigger().equals(triggerToRemove)) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public void removeAllTriggers() {
        this.triggerLink.clear();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation_strategy")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy newStrategy) {
        this.triggerActivationStrategy = newStrategy;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.getTriggerActivationStrategy().isActive(this, context) && (this.hasValue() || this.isOpenPrice());
    }

    public void setAutomatic(boolean isAutomatic) {
        this.automatic = isAutomatic;
    }

    @Column(name="is_automatic")
    public boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public void save() {
        super.save();
        this.triggerLink.saveChild();
    }

    @Override
    public void delete() {
        this.triggerLink.deleteChild();
        this.triggerLink.clear();
        super.delete();
    }

    @OneToMany(mappedBy="inventoryPriceAdjustment", targetEntity=PriceAdjustmentTriggerLink.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PriceAdjustmentTriggerLink> getTriggerLink() {
        return this.triggerLink.getUnmodifiable();
    }

    protected void setTriggerLink(List<PriceAdjustmentTriggerLink> triggerLink) {
        this.triggerLink = this.triggerLink.clone();
        this.triggerLink.set(triggerLink);
    }

    public static class Props
    extends InventoryPriceAdjustment.Props {
        public PropertiedObject.Property TRIGGER_LINK;
        public PropertiedObject.Property TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property AUTOMATIC;
        public PersistentObject.DerivedProperty<TriggeredPriceAdjustment> TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TriggeredPriceAdjustment.class), "triggers");
    }
}

