/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.coupon.PriceAdjustmentCoupon;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="COUPON")
@AccessType(value="property")
public class CouponPriceAdjustment
extends InventoryPriceAdjustment {
    public static final Props Properties = new Props();
    private Reference<PriceAdjustmentCoupon> coupon;

    @Deprecated
    public CouponPriceAdjustment() {
        this.coupon = this.createReference(CouponPriceAdjustment.Properties.COUPON);
    }

    public CouponPriceAdjustment(PriceAdjustmentCoupon yourCouponSir) {
        this.coupon = this.createReference(CouponPriceAdjustment.Properties.COUPON);
        if (yourCouponSir == null) {
            throw new IllegalArgumentException("Cannot have a null coupon for a CouponPriceAdjustment");
        }
        this.setCoupon(yourCouponSir);
        double amount = yourCouponSir.getAmount();
        PriceAdjustmentUnit unit = yourCouponSir.getUnit();
        PriceAdjustmentDirection direction = amount <= 0.0 ? PriceAdjustmentDirection.DISCOUNT : PriceAdjustmentDirection.SURCHARGE;
        amount = Math.abs(amount);
        this.setAmount(amount, unit);
        this.setDirection(direction);
        this.setLabel(yourCouponSir.getLabel());
    }

    @JoinColumn(name="fk_inventory_coupon")
    @ManyToOne
    public PriceAdjustmentCoupon getCoupon() {
        return this.coupon.get();
    }

    protected void setCoupon(PriceAdjustmentCoupon value) {
        this.coupon.set(value);
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.COUPON;
    }

    public static class Props
    extends InventoryPriceAdjustment.Props {
        public PropertiedObject.Property<PriceAdjustmentCoupon> COUPON;
    }
}

