/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CUSTOMER")
@AccessType(value="property")
public class CustomerPriceAdjustment
extends TriggeredPriceAdjustment {
    public static final Props Properties = new Props();
    private PersistentList<Customer> customers;

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.CUSTOMER;
    }

    public CustomerPriceAdjustment() {
        this.customers = this.createList(CustomerPriceAdjustment.Properties.CUSTOMERS);
    }

    public CustomerPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        super(amount, unit, direction);
        this.customers = this.createList(CustomerPriceAdjustment.Properties.CUSTOMERS);
        this.setAutomatic(false);
        this.setDisplayable(true);
    }

    @OneToMany(mappedBy="priceAdjustment", targetEntity=Customer.class)
    public List<Customer> getCustomers() {
        return this.customers.getUnmodifiable();
    }

    protected void setCustomers(List<Customer> newCustomers) {
        this.customers = this.customers.clone();
        this.customers.set(newCustomers);
    }

    public static class Props
    extends TriggeredPriceAdjustment.Props {
        public PropertiedObject.Property<Customer> CUSTOMERS;
    }
}

