/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.sales.AccountType;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="DELIVERY_SURCHARGE")
@AccessType(value="property")
public class DeliveryPriceAdjustment
extends TriggeredPriceAdjustment {
    public static final Props Properties = new Props();

    public DeliveryPriceAdjustment() {
    }

    @Override
    public void init() {
        super.init();
        this.ensureTrigger();
        this.setAutomatic(true);
        this.setLevel(PriceAdjustmentLevel.ACCOUNT_LEVEL);
    }

    public DeliveryPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        super(amount, unit, direction);
        this.init();
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.DELIVERY_SURCHARGE;
    }

    @Override
    public void save() {
        if (this.getTriggers().size() == 0) {
            this.ensureTrigger();
        }
        super.save();
    }

    private void ensureTrigger() {
        AccountTypeTrigger trigger = AccountTypeTrigger.findDeliveryAccTypeTrigger();
        if (trigger == null) {
            trigger = new AccountTypeTrigger(AccountType.deliveryType);
            trigger.setLabel("Delivery Account Type Trigger");
            trigger.save();
        }
        this.addTrigger(trigger);
        if (this.isPersistent()) {
            this.triggerLink.saveChild();
        }
    }

    public static class Props
    extends TriggeredPriceAdjustment.Props {
    }
}

