/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import java.util.Collections;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="FINAL")
@AccessType(value="property")
public class FinalPriceInvAdjustment
extends InventoryPriceAdjustment {
    public static final Props Properties = new Props();
    private FinalPriceAdjustmentIdentifier priceAdjustmentIdentifier;

    public FinalPriceInvAdjustment() {
        super(0.0, PriceAdjustmentUnit.FINAL_UNIT, PriceAdjustmentDirection.SURCHARGE, "Final Price Adjustment", PriceAdjustmentLevel.ITEM_LEVEL);
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.FINAL;
    }

    @Override
    public FinalSalesPriceAdjustment createSalesPriceAdjustment(PriceAdjustable adjustable, EventContext context) {
        FinalSalesPriceAdjustment salesAdj = (FinalSalesPriceAdjustment)this.createSalesPriceAdjustment(Collections.singletonList(adjustable), context);
        salesAdj.setPriceAdjustmentIdentifier(this.priceAdjustmentIdentifier);
        return salesAdj;
    }

    @Override
    protected boolean shouldDisplayAmount() {
        return false;
    }

    @Transient
    public FinalPriceAdjustmentIdentifier getPriceAdjustmentIdentifier() {
        return this.priceAdjustmentIdentifier;
    }

    public void setPriceAdjustmentIdentifier(FinalPriceAdjustmentIdentifier priceAdjustmentIdentifier) {
        this.priceAdjustmentIdentifier = priceAdjustmentIdentifier;
        this.setLabel(priceAdjustmentIdentifier.getDescription());
    }

    public static class Props
    extends InventoryPriceAdjustment.Props {
    }
}

