/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.FlatPriceAdjustment;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="OPEN_PRICE")
@AccessType(value="property")
public class OpenPriceAdjustment
extends InventoryPriceAdjustment {
    public static final Props Properties = new Props();
    private static final LocalCachedReference persistedOpenPriceDiscount = new LocalCachedReference<OpenPriceAdjustment>(new QueryReference<OpenPriceAdjustment>(OpenPriceAdjustment.class, Query.select(OpenPriceAdjustment.class).active(OpenPriceAdjustment.class).equals(OpenPriceAdjustment.Properties.DIRECTION, PriceAdjustmentDirection.DISCOUNT).equals(OpenPriceAdjustment.Properties.TYPE, PriceAdjustmentType.OPEN_PRICE)));
    private static final LocalCachedReference persistedOpenPriceSurcharge = new LocalCachedReference<OpenPriceAdjustment>(new QueryReference<OpenPriceAdjustment>(OpenPriceAdjustment.class, Query.select(OpenPriceAdjustment.class).active(OpenPriceAdjustment.class).equals(OpenPriceAdjustment.Properties.DIRECTION, PriceAdjustmentDirection.SURCHARGE).equals(OpenPriceAdjustment.Properties.TYPE, PriceAdjustmentType.OPEN_PRICE)));

    public OpenPriceAdjustment() {
        this.setDisplayable(false);
    }

    private OpenPriceAdjustment(String name, PriceAdjustmentDirection direction) {
        super(0.0, PriceAdjustmentUnit.FLAT_PRICE_UNIT, direction, name, PriceAdjustmentLevel.ITEM_LEVEL);
        this.setDisplayable(false);
        PersistenceManager.save(this);
    }

    protected SalesPriceAdjustment constructSalesPriceAdjustment(EventContext context) {
        return new FlatPriceAdjustment(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OpenPriceAdjustment getPersistedDiscount() {
        LocalCachedReference localCachedReference = persistedOpenPriceDiscount;
        synchronized (localCachedReference) {
            OpenPriceAdjustment adj = (OpenPriceAdjustment)persistedOpenPriceDiscount.get();
            if (adj == null) {
                adj = new OpenPriceAdjustment("Open Price Discount", PriceAdjustmentDirection.DISCOUNT);
                persistedOpenPriceDiscount.set(adj);
            }
            return adj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OpenPriceAdjustment getPersistedSurcharge() {
        LocalCachedReference localCachedReference = persistedOpenPriceSurcharge;
        synchronized (localCachedReference) {
            OpenPriceAdjustment adj = (OpenPriceAdjustment)persistedOpenPriceSurcharge.get();
            if (adj == null) {
                adj = new OpenPriceAdjustment("Open Price Surcharge", PriceAdjustmentDirection.SURCHARGE);
                persistedOpenPriceSurcharge.set(adj);
            }
            return adj;
        }
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.OPEN_PRICE;
    }

    @Override
    public void delete() {
        OrderMate.LOG.warn("Cannot delete open price adjustment");
    }

    @Override
    public void save() {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    public static class Props
    extends InventoryPriceAdjustment.Props {
    }
}

