/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.LoyaltyPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.inventory.PriceLevelPriceInvAdjustment;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.inventory.triggers.TradingDayTrigger;
import ordermate.database.misc.TradingDay;

public final class PriceAdjustmentFactory {
    private static PriceAdjustmentFactory instance = new PriceAdjustmentFactory();

    public static PriceAdjustmentFactory getInstance() {
        return instance;
    }

    private PriceAdjustmentFactory() {
    }

    public InventoryPriceAdjustment createInventoryDiscount(double amount, PriceAdjustmentUnit unit, PriceAdjustmentType type, String name) {
        return this.createInventoryPriceAdjustment(PriceAdjustmentDirection.DISCOUNT, amount, unit, type, name);
    }

    public InventoryPriceAdjustment createInventorySurcharge(double amount, PriceAdjustmentUnit unit, PriceAdjustmentType type, String name) {
        return this.createInventoryPriceAdjustment(PriceAdjustmentDirection.SURCHARGE, amount, unit, type, name);
    }

    public InventoryPriceAdjustment createInventoryPriceAdjustment(PriceAdjustmentDirection direction, double amount, PriceAdjustmentUnit unit, PriceAdjustmentType type, String name) {
        this.checkParamsNotNull(direction, unit, type);
        InventoryPriceAdjustment adjustment = type.createPriceAdjustment(amount, unit, direction);
        PriceAdjustmentManager.getInstance().clearCachedAdjustments();
        adjustment.setLabel(name);
        return adjustment;
    }

    public TriggeredPriceAdjustment createTradingDayAdjustment(TradingDay day, PriceAdjustmentDirection direction, double amount, PriceAdjustmentUnit unit, String name) {
        this.checkParamsNotNull(direction, unit, PriceAdjustmentType.DAILY);
        TriggeredPriceAdjustment adjustment = PriceAdjustmentType.DAILY.createTriggeredPriceAdjustment(amount, unit, direction);
        TradingDayTrigger trigger = TradingDayTrigger.getTradingDayTrigger(day);
        if (trigger == null) {
            trigger = new TradingDayTrigger(day);
            trigger.save();
        }
        adjustment.addTrigger(trigger);
        return adjustment;
    }

    public TriggeredPriceAdjustment createTriggeredPriceAdjustment(PriceAdjustmentDirection direction, double amount, PriceAdjustmentUnit unit, PriceAdjustmentType type, String name) {
        this.checkParamsNotNull(direction, unit, type);
        if (!type.isTriggered()) {
            throw new IllegalArgumentException("Cannot create triggered discount, type does not support it");
        }
        TriggeredPriceAdjustment adjustment = type.createTriggeredPriceAdjustment(amount, unit, direction);
        adjustment.setLabel(name);
        PriceAdjustmentManager.getInstance().clearCachedAdjustments();
        return adjustment;
    }

    public InventoryPriceAdjustment createOpenPriceDiscountForDollarAmount(String name, PriceAdjustmentUnit unit) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cannot create discount with illegal name ");
        }
        if (!unit.equals(PriceAdjustmentUnit.DOLLAR_UNIT) && !unit.equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
            throw new IllegalArgumentException("PriceAdjustmentUnit can only be Dollar Unit or Percentage Unit ");
        }
        InventoryPriceAdjustment ipa = this.createInventoryPriceAdjustment(PriceAdjustmentDirection.DISCOUNT, 0.0, unit, PriceAdjustmentType.NORMAL, name);
        ipa.setOpenPrice(true);
        return ipa;
    }

    public TriggeredPriceAdjustment createOpenPriceTriggeredPriceAdjustment(PriceAdjustmentDirection direction, PriceAdjustmentUnit unit, String name) {
        TriggeredPriceAdjustment adjustment = this.createTriggeredPriceAdjustment(direction, 0.0, unit, PriceAdjustmentType.NORMAL, name);
        adjustment.setOpenPrice(true);
        return adjustment;
    }

    public InventoryPriceAdjustment createCustomDiscount(double value, PriceAdjustmentUnit unit) {
        return this.createInventoryDiscount(value, unit, PriceAdjustmentType.CUSTOM, unit.getFormattedValue(value));
    }

    public InventoryPriceAdjustment createCustomSurcharge(double value, PriceAdjustmentUnit unit) {
        return this.createInventorySurcharge(value, unit, PriceAdjustmentType.CUSTOM, unit.getFormattedValue(value));
    }

    private void checkParamsNotNull(PriceAdjustmentDirection direction, PriceAdjustmentUnit unit, PriceAdjustmentType type) {
        if (direction == null) {
            throw new IllegalArgumentException("Direction cannot be null");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
    }

    public LoyaltyPriceAdjustment getLoyaltyRedemptionAdjustment() {
        return PriceAdjustmentType.LOYALTY.getLoyaltyPriceAdjustment();
    }

    public PriceLevelPriceInvAdjustment getPriceLevelAdjustment() {
        return PriceAdjustmentType.PRICE_LEVEL.getPriceLevelAdjustment();
    }

    public FinalPriceInvAdjustment getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier type, FinanceUnit financeUnit) {
        switch (type) {
            case COMBO: {
                return PriceAdjustmentType.FINAL.getOrCreateFinalPriceAdjustment(type, financeUnit);
            }
        }
        return PriceAdjustmentType.FINAL_PAYMENT.getOrCreateFinalPriceAdjustment(type, financeUnit);
    }
}

