/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.CouponPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.CustomPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.CustomerPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPaymentPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.LoyaltyPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.OnlinePriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.OpenPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceLevelPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.inventory.SimplePriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.TradingDayAdjustment;
import ordermate.database.finance.transactions.FinanceUnit;

public class PriceAdjustmentType
extends PersistentEnumeration {
    private static final long serialVersionUID = 1L;
    public static final PriceAdjustmentType NORMAL = new PriceAdjustmentType("NORMAL", "Normal"){
        private static final long serialVersionUID = 1L;

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return this.createTriggeredPriceAdjustment(amount, unit, direction);
        }

        @Override
        public Class getTypeClass() {
            return SimplePriceAdjustment.class;
        }

        @Override
        public TriggeredPriceAdjustment createTriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return new SimplePriceAdjustment(amount, unit, direction);
        }

        @Override
        public boolean isTriggered() {
            return true;
        }
    };
    public static final PriceAdjustmentType DAILY = new PriceAdjustmentType("DAILY", "Daily"){
        private static final long serialVersionUID = 1L;

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return this.createTriggeredPriceAdjustment(amount, unit, direction);
        }

        @Override
        public Class getTypeClass() {
            return TradingDayAdjustment.class;
        }

        @Override
        public TriggeredPriceAdjustment createTriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return new TradingDayAdjustment(amount, unit, direction);
        }

        @Override
        public boolean isTriggered() {
            return true;
        }
    };
    public static final PriceAdjustmentType CUSTOMER = new PriceAdjustmentType("CUSTOMER", "Customer"){
        private static final long serialVersionUID = 1L;

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return this.createTriggeredPriceAdjustment(amount, unit, direction);
        }

        @Override
        public Class getTypeClass() {
            return CustomerPriceAdjustment.class;
        }

        @Override
        public TriggeredPriceAdjustment createTriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return new CustomerPriceAdjustment(amount, unit, direction);
        }

        @Override
        public boolean isTriggered() {
            return true;
        }
    };
    public static final PriceAdjustmentType CUSTOM = new PriceAdjustmentType("CUSTOM", "Custom"){
        private static final long serialVersionUID = 1L;

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return new CustomPriceAdjustment(amount, unit, direction);
        }

        @Override
        public Class getTypeClass() {
            return CustomPriceAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }
    };
    public static final PriceAdjustmentType COUPON = new PriceAdjustmentType("COUPON", "Coupon"){
        private static final long serialVersionUID = 1L;

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("createPriceAdjustment is not available for Coupons.");
        }

        @Override
        public Class getTypeClass() {
            return CouponPriceAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }
    };
    public static final DeliveryPriceAdjustmentType DELIVERY_SURCHARGE = new DeliveryPriceAdjustmentType();
    public static final OpenPriceAdjustmentType OPEN_PRICE = new OpenPriceAdjustmentType();
    public static final LoyaltyPriceAdjustmentType LOYALTY = new LoyaltyPriceAdjustmentType();
    public static final PriceLevelAdjustmentType PRICE_LEVEL = new PriceLevelAdjustmentType();
    public static final OnlinePriceAdjustmentType ONLINE = new OnlinePriceAdjustmentType();
    public static final FinalPriceAdjustmentType FINAL = new FinalPriceAdjustmentType();
    public static final FinalPaymentPriceAdjustmentType FINAL_PAYMENT = new FinalPaymentPriceAdjustmentType();
    public static final Map register;
    public static final Map triggeredTypes;

    public List<FinalPriceInvAdjustment> getFinalPriceAdjustments() {
        return PersistenceManager.getObjectList(FinalPriceInvAdjustment.class, Query.select(FinalPriceInvAdjustment.class).equals(FinalPriceInvAdjustment.Properties.TYPE, FINAL).active(FinalPriceInvAdjustment.class).toString(), null);
    }

    private PriceAdjustmentType(String desc, String displayableLabel) {
        super(desc, displayableLabel);
    }

    public boolean isDisplayOnReceipt() {
        return true;
    }

    public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        return new SimplePriceAdjustment(amount, unit, direction);
    }

    public TriggeredPriceAdjustment createTriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        throw new UnsupportedOperationException("default implementation does not support creating triggered adjustments");
    }

    public Class getTypeClass() {
        return SimplePriceAdjustment.class;
    }

    public boolean isTriggered() {
        return false;
    }

    public static Map getRegister() {
        return register;
    }

    public static Collection getAll() {
        return register.values();
    }

    public static Collection getAllUserDisplayableDiscounts() {
        PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType> builder = new PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType>();
        builder.put(NORMAL);
        builder.put(DAILY);
        builder.put(CUSTOM);
        builder.put(PRICE_LEVEL);
        builder.put(OPEN_PRICE);
        builder.put(LOYALTY);
        return builder.getMap().values();
    }

    public static Collection getAllUserDisplayableSurcharges() {
        PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType> builder = new PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType>();
        builder.put(NORMAL);
        builder.put(DAILY);
        builder.put(CUSTOMER);
        builder.put(CUSTOM);
        builder.put(PRICE_LEVEL);
        builder.put(OPEN_PRICE);
        builder.put(DELIVERY_SURCHARGE);
        builder.put(LOYALTY);
        builder.put(FINAL);
        builder.put(FINAL_PAYMENT);
        builder.put(COUPON);
        return builder.getMap().values();
    }

    static {
        PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType> builder = new PersistentEnumeration.UnmodifiableMapBuilder<PriceAdjustmentType>();
        builder.put(NORMAL);
        builder.put(DAILY);
        builder.put(CUSTOMER);
        builder.put(CUSTOM);
        builder.put(PRICE_LEVEL);
        builder.put(OPEN_PRICE);
        builder.put(DELIVERY_SURCHARGE);
        builder.put(LOYALTY);
        builder.put(FINAL);
        builder.put(FINAL_PAYMENT);
        builder.put(COUPON);
        register = builder.getMap();
        builder = new PersistentEnumeration.UnmodifiableMapBuilder();
        builder.put(NORMAL);
        builder.put(DAILY);
        builder.put(CUSTOMER);
        triggeredTypes = builder.getMap();
    }

    public static final class FinalPaymentPriceAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        private FinalPaymentPriceAdjustmentType() {
            super("FINAL_PAYMENT", "Payment Adjustment");
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("Final Price Adjustments are not supported to be created, call getOrCreateFinalPriceAdjustment method.");
        }

        @Override
        public Class getTypeClass() {
            return FinalPaymentPriceInvAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        public FinalPaymentPriceInvAdjustment getOrCreateFinalPriceAdjustment(FinalPriceAdjustmentIdentifier type, FinanceUnit financeUnit) {
            ObjectQuery query = Query.select(FinalPaymentPriceInvAdjustment.class).equals(FinalPaymentPriceInvAdjustment.Properties.TYPE, FINAL_PAYMENT).equals(FinalPaymentPriceInvAdjustment.Properties.FINANCE_UNIT, financeUnit).active(FinalPaymentPriceInvAdjustment.class);
            FinalPaymentPriceInvAdjustment adj = PersistenceManager.getObject(FinalPaymentPriceInvAdjustment.class, query.toString(), null);
            if (adj == null) {
                adj = new FinalPaymentPriceInvAdjustment();
                adj.setPriceAdjustmentIdentifier(type);
                adj.setFinanceUnit(financeUnit);
                if (financeUnit != null) {
                    adj.setLabel(adj.getLabel() + " - " + financeUnit.getLabel());
                } else {
                    adj.setLabel(adj.getLabel());
                }
                adj.save();
            }
            adj.setPriceAdjustmentIdentifier(type);
            return adj;
        }

        @Override
        public List<FinalPriceInvAdjustment> getFinalPriceAdjustments() {
            List<FinalPaymentPriceInvAdjustment> list = PersistenceManager.getObjectList(FinalPaymentPriceInvAdjustment.class, Query.select(FinalPaymentPriceInvAdjustment.class).equals(FinalPaymentPriceInvAdjustment.Properties.TYPE, FINAL_PAYMENT).active(FinalPaymentPriceInvAdjustment.class).toString(), null);
            return new ArrayList<FinalPriceInvAdjustment>(list);
        }
    }

    public static final class FinalPriceAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        private FinalPriceAdjustmentType() {
            super("FINAL", "Price Add");
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("Final Price Adjustments are not supported to be created, call getOrCreateFinalPriceAdjustment method.");
        }

        @Override
        public Class getTypeClass() {
            return FinalPriceInvAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        public FinalPriceInvAdjustment getOrCreateFinalPriceAdjustment(FinalPriceAdjustmentIdentifier type, FinanceUnit financeUnit) {
            FinalPriceInvAdjustment adj = PersistenceManager.getObject(FinalPriceInvAdjustment.class, Query.select(FinalPriceInvAdjustment.class).equals(FinalPriceInvAdjustment.Properties.TYPE, FINAL).equals(FinalPriceInvAdjustment.Properties.FINANCE_UNIT, financeUnit).active(FinalPriceInvAdjustment.class).toString(), null);
            if (adj == null) {
                adj = new FinalPriceInvAdjustment();
                adj.setPriceAdjustmentIdentifier(type);
                adj.setFinanceUnit(financeUnit);
                if (financeUnit != null) {
                    adj.setLabel(adj.getLabel() + " - " + financeUnit.getLabel());
                } else {
                    adj.setLabel(adj.getLabel());
                }
                adj.save();
            }
            adj.setPriceAdjustmentIdentifier(type);
            return adj;
        }
    }

    public static final class OnlinePriceAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        private OnlinePriceAdjustmentType() {
            super("ONLINE", "Online");
        }

        @Override
        public OnlinePriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("Use makeOnlineAdjustment method");
        }

        @Override
        public Class getTypeClass() {
            return OnlinePriceAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        public OnlinePriceAdjustment makeOnlinePriceAdjustment(String label, String source, PriceAdjustmentDirection direction) {
            OnlinePriceAdjustment adj = PersistenceManager.getObject(OnlinePriceAdjustment.class, Query.select(OnlinePriceAdjustment.class).equals(OnlinePriceAdjustment.Properties.LABEL, label).equals(OnlinePriceAdjustment.Properties.DIRECTION, direction).equals(OnlinePriceAdjustment.Properties.SOURCE, source).toString());
            if (adj == null) {
                adj = new OnlinePriceAdjustment(label, source, direction);
                adj.save();
            }
            if (!SystemState.ACTIVE_STATE.equals(adj.getSystemState())) {
                adj.setSystemState(SystemState.ACTIVE_STATE);
                adj.save();
            }
            return adj;
        }
    }

    public static final class PriceLevelAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        private PriceLevelAdjustmentType() {
            super("PRICE_LEVEL", "Price Level");
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("Price Level Adjustments are not supported to be created, call getPriceLevelAdjustment method.");
        }

        @Override
        public Class getTypeClass() {
            return PriceLevelPriceInvAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        public PriceLevelPriceInvAdjustment getPriceLevelAdjustment() {
            PriceLevelPriceInvAdjustment adj = PersistenceManager.getObject(PriceLevelPriceInvAdjustment.class, Query.select(PriceLevelPriceInvAdjustment.class).equals(PriceLevelPriceInvAdjustment.Properties.TYPE, PRICE_LEVEL).active(PriceLevelPriceInvAdjustment.class).toString(), null);
            if (adj == null) {
                adj = new PriceLevelPriceInvAdjustment();
                adj.save();
            }
            return adj;
        }
    }

    public static final class LoyaltyPriceAdjustmentType
    extends PriceAdjustmentType {
        private LoyaltyPriceAdjustmentType() {
            super("LOYALTY", "Loyalty");
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            throw new UnsupportedOperationException("LoyaltyRedemption is not customisable, use createLoyaltyPriceAdjustment()");
        }

        public LoyaltyPriceAdjustment getLoyaltyPriceAdjustment() {
            LoyaltyPriceAdjustment adj = PersistenceManager.getObject(LoyaltyPriceAdjustment.class, Query.select(LoyaltyPriceAdjustment.class).equals(LoyaltyPriceAdjustment.Properties.TYPE, LOYALTY).toString(), null);
            if (adj == null) {
                adj = new LoyaltyPriceAdjustment();
                adj.save();
            }
            return adj;
        }

        @Override
        public Class getTypeClass() {
            return LoyaltyPriceAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return false;
        }
    }

    public static class OpenPriceAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        private OpenPriceAdjustmentType() {
            super("OPEN_PRICE", "Open Price");
        }

        @Override
        public boolean isDisplayOnReceipt() {
            return false;
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            if (!unit.equals(PriceAdjustmentUnit.FLAT_PRICE_UNIT)) {
                throw new IllegalArgumentException("Cannot create an open price adjustment from anything other than a flat price unit");
            }
            return this.createOpenPriceAdjustment(new Price(amount, 0.01), direction);
        }

        protected OpenPriceAdjustment createOpenPriceAdjustment(Price openPrice, PriceAdjustmentDirection direction) {
            OpenPriceAdjustment adj;
            if (direction == null) {
                throw new IllegalArgumentException("Cannot create open price adjustment without a direction");
            }
            if (direction.equals(PriceAdjustmentDirection.DISCOUNT)) {
                adj = OpenPriceAdjustment.getPersistedDiscount();
            } else if (direction.equals(PriceAdjustmentDirection.SURCHARGE)) {
                adj = OpenPriceAdjustment.getPersistedSurcharge();
            } else {
                throw new IllegalArgumentException("Unknown price adjustment direction :" + direction);
            }
            adj.setFlatPrice(openPrice);
            return adj;
        }

        public OpenPriceAdjustment createOpenPriceAdjustment(Price openPrice, Price originalPrice) {
            if (openPrice.lessThan(originalPrice)) {
                return this.createOpenPriceAdjustment(openPrice, PriceAdjustmentDirection.DISCOUNT);
            }
            return this.createOpenPriceAdjustment(openPrice, PriceAdjustmentDirection.SURCHARGE);
        }
    }

    public static final class DeliveryPriceAdjustmentType
    extends PriceAdjustmentType {
        private static final long serialVersionUID = 1L;

        DeliveryPriceAdjustmentType() {
            super("DELIVERY_SURCHARGE", "Delivery Surcharge");
        }

        @Override
        public InventoryPriceAdjustment createPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            return this.createTriggeredPriceAdjustment(amount, unit, direction);
        }

        @Override
        public TriggeredPriceAdjustment createTriggeredPriceAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
            if (!direction.equals(PriceAdjustmentDirection.SURCHARGE)) {
                throw new IllegalArgumentException("Delivery surcharge can only be a surcharge.");
            }
            return new DeliveryPriceAdjustment(amount, unit, PriceAdjustmentDirection.SURCHARGE);
        }

        public DeliveryPriceAdjustment createDeliverySurcharge(Price dollarAmount) {
            return (DeliveryPriceAdjustment)this.createPriceAdjustment(dollarAmount.doubleValue(), PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.SURCHARGE);
        }

        @Override
        public Class getTypeClass() {
            return DeliveryPriceAdjustment.class;
        }

        @Override
        public boolean isTriggered() {
            return true;
        }
    }
}

