/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import java.util.Collections;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.PriceLevelSalesPriceAdjustment;
import ordermate.database.inventory.PriceLevel;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="PRICE_LEVEL")
@AccessType(value="property")
public class PriceLevelPriceInvAdjustment
extends InventoryPriceAdjustment {
    public static final Props Properties = new Props();

    public PriceLevelPriceInvAdjustment() {
        super(0.0, PriceAdjustmentUnit.PRICE_LEVEL_UNIT, PriceAdjustmentDirection.DISCOUNT, "Price Level Adjustment", PriceAdjustmentLevel.ITEM_LEVEL);
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.PRICE_LEVEL;
    }

    public PriceLevelSalesPriceAdjustment createSalesPriceAdjustment(PriceAdjustable adjustable, EventContext context, PriceLevel priceLevel) {
        PriceLevelSalesPriceAdjustment salesAdj = (PriceLevelSalesPriceAdjustment)this.createSalesPriceAdjustment(Collections.singletonList(adjustable), context);
        salesAdj.setPriceLevel(priceLevel);
        return salesAdj;
    }

    public static class Props
    extends InventoryPriceAdjustment.Props {
    }
}

