/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.inventory;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TradingDayTrigger;
import ordermate.database.misc.TradingDay;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="DAILY")
@AccessType(value="property")
public class TradingDayAdjustment
extends TriggeredPriceAdjustment {
    public static final Props Properties = new Props();

    public TradingDayAdjustment() {
    }

    public TradingDayAdjustment(double amount, PriceAdjustmentUnit unit, PriceAdjustmentDirection direction) {
        super(amount, unit, direction);
        this.setAutomatic(true);
        this.setDisplayable(false);
    }

    @Transient
    public TradingDay getTradingDay() {
        for (AbstractTrigger trigger : this.getTriggers()) {
            if (!(trigger instanceof TradingDayTrigger)) continue;
            return ((TradingDayTrigger)trigger).getTradingDay();
        }
        return null;
    }

    public void setTradingDay(TradingDay day) {
        if (day == null) {
            throw new NullPointerException("Cannot set trading to null for trading day adjustment");
        }
        this.removeAllTriggers();
        boolean foundTradingDayTrigger = false;
        for (AbstractTrigger trigger : AbstractTrigger.getAllTriggers()) {
            TradingDayTrigger tradingDayTrigger;
            if (!(trigger instanceof TradingDayTrigger) || !day.equals((tradingDayTrigger = (TradingDayTrigger)trigger).getTradingDay()) || PersistenceManager.getByID(tradingDayTrigger.getID(), TradingDayTrigger.class) == null) continue;
            this.addTrigger(tradingDayTrigger);
            foundTradingDayTrigger = true;
        }
        if (!foundTradingDayTrigger) {
            TradingDayTrigger trigger = new TradingDayTrigger(day);
            trigger.save();
            this.addTrigger(trigger);
        }
    }

    @Override
    @Transient
    public PriceAdjustmentType getType() {
        return PriceAdjustmentType.DAILY;
    }

    @Override
    public void delete() {
        List<AbstractTrigger> triggers = this.getTriggers();
        for (AbstractTrigger trig : triggers) {
            if (!(trig instanceof TradingDayTrigger)) continue;
            PersistenceManager.delete(trig);
        }
        super.delete();
    }

    public static class Props
    extends TriggeredPriceAdjustment.Props {
    }
}

