/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Dollar Amount")
@AccessType(value="property")
public class DollarPriceAdjustment
extends SalesPriceAdjustment {
    public static final Props Properties = new Props();
    private Price dollarAmount = Price.ZERO_DOLLAR;

    public DollarPriceAdjustment() {
        super(PriceAdjustmentUnit.DOLLAR_UNIT);
    }

    public DollarPriceAdjustment(InventoryPriceAdjustment adjustment, Price newDollarAmount, EventContext context) {
        super(adjustment, context);
        if (!PriceAdjustmentUnit.DOLLAR_UNIT.equals(adjustment.getUnit())) {
            throw new IllegalArgumentException("Cannot create a dollar price adjustment from and adjustment that is not a dollar unit");
        }
        this.dollarAmount = newDollarAmount;
    }

    private DollarPriceAdjustment(DollarPriceAdjustment toCopy) {
        super(toCopy);
        this.dollarAmount = toCopy.dollarAmount;
    }

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getDollarAmount() {
        return this.dollarAmount;
    }

    @Override
    public SalesPriceAdjustment copy() {
        return new DollarPriceAdjustment(this);
    }

    @Override
    public Price calcValue(Price amount) {
        return super.calcValue(amount, this.getDollarAmount().doubleValue());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DollarPriceAdjustment)) {
            return false;
        }
        DollarPriceAdjustment otherAdj = (DollarPriceAdjustment)other;
        if (otherAdj.isPersistent() && this.isPersistent()) {
            return super.equals(other);
        }
        return this.dollarAmount.equals(otherAdj.getDollarAmount()) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        return (int)(this.dollarAmount.doubleValue() * (double)superHashCode + (double)superHashCode);
    }

    protected void setDollarAmount(Price newDollarAmount) {
        this.dollarAmount = newDollarAmount;
    }

    public static class Props
    extends SalesPriceAdjustment.Props {
        public PropertiedObject.Property DOLLAR_AMOUNT;
    }
}

