/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Final Amount")
@AccessType(value="property")
public class FinalSalesPriceAdjustment
extends SalesPriceAdjustment {
    public static final Props Properties = new Props();
    private FinalPriceAdjustmentIdentifier priceAdjustmentIdentifier;
    private Price dollarAmount = Price.ZERO_DOLLAR;

    public FinalSalesPriceAdjustment() {
        super(PriceAdjustmentUnit.FINAL_UNIT);
    }

    public FinalSalesPriceAdjustment(InventoryPriceAdjustment adjustment, Price newDollarAmount, EventContext context) {
        super(adjustment, context);
        if (!PriceAdjustmentUnit.FINAL_UNIT.equals(adjustment.getUnit())) {
            throw new IllegalArgumentException("Cannot create a final price adjustment from and adjustment that is not a final price unit");
        }
        this.dollarAmount = newDollarAmount;
    }

    private FinalSalesPriceAdjustment(FinalSalesPriceAdjustment toCopy) {
        super(toCopy);
        this.dollarAmount = toCopy.dollarAmount;
        this.priceAdjustmentIdentifier = toCopy.priceAdjustmentIdentifier;
    }

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getDollarAmount() {
        return this.dollarAmount;
    }

    @Override
    public SalesPriceAdjustment copy() {
        return new FinalSalesPriceAdjustment(this);
    }

    @Override
    public Price calcValue(Price amount) {
        return super.calcValue(amount, this.getDollarAmount().doubleValue());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FinalSalesPriceAdjustment)) {
            return false;
        }
        FinalSalesPriceAdjustment otherAdj = (FinalSalesPriceAdjustment)other;
        if (otherAdj.isPersistent() && this.isPersistent()) {
            return super.equals(other);
        }
        return this.dollarAmount.equals(otherAdj.getDollarAmount()) && this.getTimestamp().equals(otherAdj.getTimestamp()) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        return (int)(this.dollarAmount.doubleValue() * (double)superHashCode + (double)superHashCode);
    }

    protected void setDollarAmount(Price newDollarAmount) {
        this.dollarAmount = newDollarAmount;
    }

    @Transient
    public FinalPriceAdjustmentIdentifier getPriceAdjustmentIdentifier() {
        return this.priceAdjustmentIdentifier;
    }

    public void setPriceAdjustmentIdentifier(FinalPriceAdjustmentIdentifier priceAdjustmentIdentifier) {
        this.priceAdjustmentIdentifier = priceAdjustmentIdentifier;
        if (!this.isPersistent()) {
            this.setLabel(priceAdjustmentIdentifier.getDescription());
        }
    }

    public static class Props
    extends SalesPriceAdjustment.Props {
        public PropertiedObject.Property DOLLAR_AMOUNT;
    }
}

