/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Flat Price Amount")
@AccessType(value="property")
public class FlatPriceAdjustment
extends SalesPriceAdjustment {
    public static final Props Properties = new Props();
    private Price flatPriceValue = Price.ZERO_DOLLAR;

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getFlatPriceValue() {
        return this.flatPriceValue;
    }

    public void setFlatPriceValue(Price value) {
        this.flatPriceValue = value;
    }

    public FlatPriceAdjustment() {
        super(PriceAdjustmentUnit.FLAT_PRICE_UNIT);
    }

    public FlatPriceAdjustment(InventoryPriceAdjustment baseAdjustment, EventContext context) {
        super(baseAdjustment, context);
        this.setFlatPriceValue(baseAdjustment.getFlatPrice());
    }

    protected FlatPriceAdjustment(FlatPriceAdjustment adj) {
        super(adj);
        this.flatPriceValue = adj.getFlatPriceValue();
    }

    @Override
    public Price calcValue(Price amount) {
        return amount.subtract(this.getFlatPriceValue());
    }

    @Override
    public SalesPriceAdjustment copy() {
        return new FlatPriceAdjustment(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FlatPriceAdjustment)) {
            return false;
        }
        FlatPriceAdjustment otherAdj = (FlatPriceAdjustment)other;
        if (otherAdj.isPersistent() && this.isPersistent()) {
            return super.equals(other);
        }
        return otherAdj.getFlatPriceValue().equals(this.flatPriceValue) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int superHash = super.hashCode();
        return this.flatPriceValue.getNumCents() * superHash + superHash;
    }

    public static class Props
    extends SalesPriceAdjustment.Props {
        public PropertiedObject.Property FLAT_PRICE_VALUE;
    }
}

