/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Percentage Amount")
@AccessType(value="property")
public class PercentagePriceAdjustment
extends SalesPriceAdjustment {
    public static final Props Properties = new Props();
    private double percentageAmount;
    private Price cap;

    public PercentagePriceAdjustment() {
        super(PriceAdjustmentUnit.PERCENTAGE_UNIT);
    }

    public PercentagePriceAdjustment(InventoryPriceAdjustment adjustment, double percentage, EventContext context) {
        super(adjustment, context);
        if (!PriceAdjustmentUnit.PERCENTAGE_UNIT.equals(adjustment.getUnit())) {
            throw new IllegalArgumentException("Price adjustment must use a percentage unit, instead got " + adjustment.getUnit());
        }
        this.percentageAmount = percentage;
        this.cap = adjustment.getCapAmount();
    }

    private PercentagePriceAdjustment(PercentagePriceAdjustment toCopy) {
        super(toCopy);
        this.percentageAmount = toCopy.percentageAmount;
        this.cap = toCopy.getCap();
    }

    @Override
    public SalesPriceAdjustment copy() {
        return new PercentagePriceAdjustment(this);
    }

    @Column(name="amount")
    public double getPercentageAmount() {
        return this.percentageAmount;
    }

    @Override
    public Price calcValue(Price amount) {
        Price value = super.calcValue(amount, this.getPercentageAmount());
        return value;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PercentagePriceAdjustment)) {
            return false;
        }
        PercentagePriceAdjustment otherAdj = (PercentagePriceAdjustment)other;
        if (otherAdj.isPersistent() && this.isPersistent()) {
            return super.equals(other);
        }
        return Math.abs(this.percentageAmount - otherAdj.percentageAmount) < 1.0E-4 && super.equals(otherAdj);
    }

    @Override
    public int hashCode() {
        int superHash = super.hashCode();
        return (int)this.percentageAmount * superHash + superHash;
    }

    protected void setPercentageAmount(double percentageAmount) {
        this.percentageAmount = percentageAmount;
    }

    @Column(name="cap")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCap() {
        return this.cap;
    }

    public void setCap(Price value) {
        this.cap = value;
    }

    public static class Props
    extends SalesPriceAdjustment.Props {
        public PropertiedObject.Property PERCENTAGE_AMOUNT;
        public PropertiedObject.Property<Price> CAP;
    }
}

