/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.priceadjustment.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.PriceLevel;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Price Level Amount")
@AccessType(value="property")
public class PriceLevelSalesPriceAdjustment
extends SalesPriceAdjustment {
    public static final Props Properties = new Props();
    private Price dollarAmount = Price.ZERO_DOLLAR;
    private Reference<PriceLevel> priceLevel;

    public PriceLevelSalesPriceAdjustment() {
        super(PriceAdjustmentUnit.PRICE_LEVEL_UNIT);
        this.priceLevel = this.createReference(PriceLevelSalesPriceAdjustment.Properties.PRICE_LEVEL);
    }

    public PriceLevelSalesPriceAdjustment(InventoryPriceAdjustment adj, EventContext context, Price newDollarAmount) {
        super(adj, context);
        this.priceLevel = this.createReference(PriceLevelSalesPriceAdjustment.Properties.PRICE_LEVEL);
        this.setType(PriceAdjustmentType.PRICE_LEVEL);
        this.dollarAmount = newDollarAmount;
    }

    private PriceLevelSalesPriceAdjustment(PriceLevelSalesPriceAdjustment toCopy) {
        super(toCopy);
        this.priceLevel = this.createReference(PriceLevelSalesPriceAdjustment.Properties.PRICE_LEVEL);
        this.setType(toCopy.getType());
        this.priceLevel.set(toCopy.getPriceLevel());
        this.dollarAmount = toCopy.getDollarAmount();
    }

    @Override
    public SalesPriceAdjustment copy() {
        return new PriceLevelSalesPriceAdjustment(this);
    }

    @Override
    public Price calcValue(Price amount) {
        return super.calcValue(amount, this.getDollarAmount().doubleValue());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_price_level")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    public void setPriceLevel(PriceLevel priceLevel) {
        this.priceLevel.set(priceLevel);
        this.setLabel(priceLevel.getLabelNoFormat());
    }

    public void setDollarAmount(Price newDollarAmount) {
        this.dollarAmount = newDollarAmount;
    }

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getDollarAmount() {
        return this.dollarAmount;
    }

    public static class Props
    extends SalesPriceAdjustment.Props {
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
        public PropertiedObject.Property DOLLAR_AMOUNT;
    }
}

