/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_reconciliation_entry")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
public abstract class AbstractReconciliationEntry
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Price value = new Price(0.0, 0.01);
    private final RecEntryType discriminatorType = this.getType();
    private Reference<CashdrawerReconciliation> parent;
    private Reference<FinanceUnit> financeUnit;

    public AbstractReconciliationEntry() {
        this.parent = this.createReference(AbstractReconciliationEntry.Properties.PARENT);
        this.financeUnit = this.createReference(AbstractReconciliationEntry.Properties.FINANCE_UNIT);
    }

    @Transient
    public abstract RecEntryType getType();

    @Transient
    public String getLabel() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public void setValue(Price theValue) {
        this.value = theValue;
    }

    @Transient
    protected RecEntryType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Column(name="value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getValue() {
        return this.value;
    }

    public void setParent(CashdrawerReconciliation theParent) {
        assert (theParent.getEntries().contains(this)) : "Cannot set parent to cashdrawerReconciliation that does not contain this.";
        this.parent.set(theParent);
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_reconciliation_cashdrawer")
    public CashdrawerReconciliation getParent() {
        return this.parent.get();
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_unit")
    public FinanceUnit getFinanceUnit() {
        return this.financeUnit.get();
    }

    public void setFinanceUnit(FinanceUnit unit) {
        this.financeUnit.set(unit);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    public static enum RecEntryType {
        ACTUAL_CASH,
        CASH_OUT,
        CREDIT,
        WEB,
        FLOAT,
        OVERRING,
        PETTY_CASH,
        TIPS;

        public static final Map<String, RecEntryType> register;

        static {
            register = PersistentEnumeration.buildRegister(RecEntryType.values());
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<CashdrawerReconciliation> PARENT;
        public PropertiedObject.Property DISCRIMINATOR_TYPE;
        public PropertiedObject.Property<FinanceUnit> FINANCE_UNIT;
        public PropertiedObject.Property VALUE;
    }
}

