/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.reconciliation.entries.ActualCashEntry;
import ordermate.database.finance.reconciliation.entries.CashOutEntry;
import ordermate.database.finance.reconciliation.entries.CreditEntry;
import ordermate.database.finance.reconciliation.entries.FloatEntry;
import ordermate.database.finance.reconciliation.entries.OverRingEntry;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.finance.reconciliation.entries.TipsEntry;
import ordermate.database.finance.reconciliation.entries.WebEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.reports.CashdrawerReconciliationQueries;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="finance_reconciliation_cashdrawer")
@AccessType(value="property")
public class CashdrawerReconciliation
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    public static final PropertiedObject.Property[] VARIANCE_PROPERTIES = new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.CASH_VARIANCE, CashdrawerReconciliation.Properties.CREDIT_VARIANCE, CashdrawerReconciliation.Properties.WEB_VARIANCE, CashdrawerReconciliation.Properties.TOTAL_VARIANCE};
    public static final PropertiedObject.Property[] SYSTEM_TOTAL_PROPERTIES = new PropertiedObject.Property[]{CashdrawerReconciliation.Properties.SYSTEM_TOTAL, CashdrawerReconciliation.Properties.SYSTEM_CASH, CashdrawerReconciliation.Properties.SYSTEM_CREDIT, CashdrawerReconciliation.Properties.SYSTEM_WEB, CashdrawerReconciliation.Properties.SYSTEM_CASH_OUT, CashdrawerReconciliation.Properties.SYSTEM_TIPS, CashdrawerReconciliation.Properties.SYSTEM_VOUCHER};
    private Reference<ShiftReconciliation> parent;
    private Reference<CashDrawer> cashDrawer;
    private PersistentWriteableList<FloatEntry> floatEntry;
    private PersistentWriteableList<OverRingEntry> overringEntry;
    private volatile PersistentWriteableList<ActualCashEntry> actualCashEntries;
    private PersistentWriteableList<PettyCashEntry> pettyCashEntries;
    private volatile PersistentWriteableList<CreditEntry> creditEntries;
    private volatile PersistentWriteableList<WebEntry> webEntries;
    private PersistentWriteableList<TipsEntry> tipsEntries;
    private PersistentWriteableList<CashOutEntry> cashOutEntry;
    private QueryReference systemCash;
    private QueryReference systemCredit;
    private QueryReference systemWeb;
    private QueryReference systemTips;
    private QueryReference systemCashOut;
    private QueryReference systemVoucher;
    private QueryReference totalSkims;
    private PersistentList<User> users;

    private void resetQueries() {
        this.systemCash = null;
        this.systemCredit = null;
        this.systemWeb = null;
        this.systemTips = null;
        this.systemCashOut = null;
        this.systemVoucher = null;
        this.users = null;
    }

    @Deprecated
    public CashdrawerReconciliation() {
        this.parent = this.createReference(CashdrawerReconciliation.Properties.PARENT);
        this.cashDrawer = this.createReference(CashdrawerReconciliation.Properties.CASHDRAWER);
        this.floatEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.FLOAT_ENTRY);
        this.overringEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.OVERRING_ENTRY);
        this.actualCashEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.ACTUAL_CASH_ENTRIES);
        this.pettyCashEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.PETTY_CASH_ENTRIES);
        this.creditEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.CREDIT_ENTRIES);
        this.webEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.WEB_ENTRIES);
        this.tipsEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.TIPS_ENTRIES);
        this.cashOutEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.CASH_OUT_ENTRY);
    }

    public CashdrawerReconciliation(ShiftReconciliation theParent, CashDrawer drawer) {
        this.parent = this.createReference(CashdrawerReconciliation.Properties.PARENT);
        this.cashDrawer = this.createReference(CashdrawerReconciliation.Properties.CASHDRAWER);
        this.floatEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.FLOAT_ENTRY);
        this.overringEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.OVERRING_ENTRY);
        this.actualCashEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.ACTUAL_CASH_ENTRIES);
        this.pettyCashEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.PETTY_CASH_ENTRIES);
        this.creditEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.CREDIT_ENTRIES);
        this.webEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.WEB_ENTRIES);
        this.tipsEntries = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.TIPS_ENTRIES);
        this.cashOutEntry = (PersistentWriteableList)this.createList(CashdrawerReconciliation.Properties.CASH_OUT_ENTRY);
        this.parent.set(theParent);
        this.setCashDrawer(drawer);
        this.setFloatEntry(new FloatEntry());
        this.setOverRingEntry(new OverRingEntry());
        this.setCashOutEntry(new CashOutEntry());
        for (int i = 0; i < Denomination.getDenominations().length; ++i) {
            this.addEntry(new ActualCashEntry(Denomination.getDenominations()[i]));
        }
        for (FinanceUnit element : FinanceUnit.getElectronicUnits()) {
            if (!"ACTIVE".equals(element.getSystemState())) continue;
            this.addEntry(new CreditEntry(element));
        }
        for (FinanceUnit element : FinanceUnit.getWebUnits()) {
            this.addEntry(new WebEntry(element));
        }
    }

    @Override
    public synchronized void init() {
        super.init();
        this.getTotalVariance();
    }

    protected synchronized void setParent(ShiftReconciliation shiftRecon) {
        assert (shiftRecon.getCashDrawerReconciliations().contains(this)) : "Cannot set parent when parent does not contain this.";
        this.parent.set(shiftRecon);
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_reconciliation_shift")
    public synchronized ShiftReconciliation getParent() {
        return this.parent.get();
    }

    protected synchronized void setCashDrawer(CashDrawer theCashdrawer) {
        if (theCashdrawer == null) {
            throw new IllegalArgumentException("Cannot set cashdrawer to null");
        }
        this.resetQueries();
        this.cashDrawer.set(theCashdrawer);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_cashdrawer")
    public synchronized CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    @Transient
    public synchronized List<AbstractReconciliationEntry> getEntries() {
        ArrayList<AbstractReconciliationEntry> entries = new ArrayList<AbstractReconciliationEntry>();
        entries.add(this.getFloatEntry());
        entries.add(this.getOverringEntry());
        entries.addAll(this.getActualCashEntries());
        entries.addAll(this.getPettyCashEntries());
        entries.addAll(this.getCreditEntries());
        entries.addAll(this.getWebEntries());
        entries.addAll(this.getTipsEntries());
        entries.add(this.getCashOutEntry());
        return entries;
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=FloatEntry.class)
    public synchronized FloatEntry getFloatEntry() {
        Object obj = this.getResolvedReferenceFromSingletonList(this.floatEntry);
        if (obj == null) {
            this.addEntry(new FloatEntry());
            return this.getFloatEntry();
        }
        return (FloatEntry)obj;
    }

    public synchronized void setFloatEntry(FloatEntry theEntry) {
        this.floatEntry.clear();
        if (theEntry != null) {
            this.floatEntry.add(theEntry);
        }
    }

    public synchronized void setOverRingEntry(OverRingEntry theEntry) {
        this.overringEntry.clear();
        if (theEntry != null) {
            this.overringEntry.add(theEntry);
        }
    }

    public synchronized void setCashOutEntry(CashOutEntry entry) {
        this.cashOutEntry.clear();
        if (entry != null) {
            this.cashOutEntry.add(entry);
        }
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=OverRingEntry.class)
    public synchronized OverRingEntry getOverringEntry() {
        OverRingEntry entry = (OverRingEntry)this.getResolvedReferenceFromSingletonList(this.overringEntry);
        if (entry == null) {
            this.addEntry(new OverRingEntry());
            return this.getOverringEntry();
        }
        return entry;
    }

    @Override
    public synchronized void delete() {
        PersistenceManager.delete(this);
        this.floatEntry.deleteChild();
        this.overringEntry.deleteChild();
        this.actualCashEntries.deleteChild();
        this.pettyCashEntries.deleteChild();
        this.creditEntries.deleteChild();
        this.webEntries.deleteChild();
        this.tipsEntries.deleteChild();
        this.cashOutEntry.deleteChild();
    }

    @Override
    public synchronized boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.floatEntry.hasChildChanged() || this.overringEntry.hasChildChanged() || this.actualCashEntries.hasChildChanged() || this.pettyCashEntries.hasChildChanged() || this.creditEntries.hasChildChanged() || this.webEntries.hasChildChanged() || this.tipsEntries.hasChildChanged() || this.cashOutEntry.hasChildChanged();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public synchronized void save() {
        if (this.getParent() != null && !this.getParent().isPersistent()) {
            this.getParent().save();
        }
        PersistenceManager.save(this);
        this.floatEntry.saveChild();
        this.overringEntry.saveChild();
        this.actualCashEntries.saveChild();
        this.pettyCashEntries.saveChild();
        this.creditEntries.saveChild();
        this.webEntries.saveChild();
        this.tipsEntries.saveChild();
        this.cashOutEntry.saveChild();
        this.resetQueries();
    }

    public synchronized void addEntry(AbstractReconciliationEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry instanceof FloatEntry) {
            this.setFloatEntry((FloatEntry)entry);
        } else if (entry instanceof OverRingEntry) {
            this.setOverRingEntry((OverRingEntry)entry);
        } else if (entry instanceof ActualCashEntry) {
            this.addActualCashEntry((ActualCashEntry)entry);
        } else if (entry instanceof PettyCashEntry) {
            this.pettyCashEntries.add((PettyCashEntry)entry);
        } else if (entry instanceof CreditEntry) {
            this.addCreditEntry((CreditEntry)entry);
        } else if (entry instanceof WebEntry) {
            this.addWebEntry((WebEntry)entry);
        } else if (entry instanceof TipsEntry) {
            this.tipsEntries.add((TipsEntry)entry);
        } else if (entry instanceof CashOutEntry) {
            this.setCashOutEntry((CashOutEntry)entry);
        } else {
            throw new IllegalStateException("Could not find appropriate subclass.");
        }
        entry.setParent(this);
    }

    public synchronized void removeEntry(AbstractReconciliationEntry entry) {
        if (entry instanceof FloatEntry) {
            this.setFloatEntry(new FloatEntry());
        } else if (entry instanceof OverRingEntry) {
            this.setOverRingEntry(new OverRingEntry());
        } else if (entry instanceof ActualCashEntry) {
            this.actualCashEntries.remove(entry);
        } else if (entry instanceof PettyCashEntry) {
            this.pettyCashEntries.remove(entry);
        } else if (entry instanceof CreditEntry) {
            this.creditEntries.remove(entry);
        } else if (entry instanceof WebEntry) {
            this.webEntries.remove(entry);
        } else if (entry instanceof TipsEntry) {
            this.tipsEntries.remove(entry);
        } else if (entry instanceof CashOutEntry) {
            this.setCashOutEntry(new CashOutEntry());
        }
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=ActualCashEntry.class)
    public synchronized List<ActualCashEntry> getActualCashEntries() {
        return this.actualCashEntries.getUnmodifiable();
    }

    public synchronized ActualCashEntry getActualCashEntry(Denomination denomination) {
        for (Object e : this.actualCashEntries) {
            ActualCashEntry currentEntry = (ActualCashEntry)e;
            if (!currentEntry.getDenomination().equals(denomination)) continue;
            return currentEntry;
        }
        this.addEntry(new ActualCashEntry(denomination));
        return this.getActualCashEntry(denomination);
    }

    private synchronized void addActualCashEntry(ActualCashEntry entry) {
        Iterator it = this.actualCashEntries.iterator();
        while (it.hasNext()) {
            ActualCashEntry currentEntry = (ActualCashEntry)it.next();
            if (!currentEntry.getDenomination().equals(entry.getDenomination())) continue;
            it.remove();
        }
        this.actualCashEntries.add(entry);
    }

    private synchronized void addCreditEntry(CreditEntry entry) {
        Iterator it = this.creditEntries.iterator();
        while (it.hasNext()) {
            CreditEntry currentEntry = (CreditEntry)it.next();
            if (!currentEntry.getFinanceUnit().equals(entry.getFinanceUnit())) continue;
            it.remove();
        }
        this.creditEntries.add(entry);
    }

    public synchronized CreditEntry getCreditEntry(FinanceUnit unit) {
        if (!FinanceUnit.getElectronicUnits().contains(unit)) {
            throw new IllegalArgumentException("Finance unit should be of type credit or debit");
        }
        for (CreditEntry element : this.getCreditEntries()) {
            CreditEntry currentEntry = element;
            if (!currentEntry.getFinanceUnit().equals(unit)) continue;
            return currentEntry;
        }
        this.addEntry(new CreditEntry(unit));
        return this.getCreditEntry(unit);
    }

    private synchronized void addWebEntry(WebEntry entry) {
        Iterator it = this.webEntries.iterator();
        while (it.hasNext()) {
            WebEntry currentEntry = (WebEntry)it.next();
            if (!currentEntry.getFinanceUnit().equals(entry.getFinanceUnit())) continue;
            it.remove();
        }
        this.webEntries.add(entry);
    }

    public synchronized WebEntry getWebEntry(FinanceUnit unit) {
        if (!FinanceUnit.getWebUnits().contains(unit)) {
            throw new IllegalArgumentException("Finance unit should be of type web");
        }
        for (WebEntry element : this.getWebEntries()) {
            WebEntry currentEntry = element;
            if (!currentEntry.getFinanceUnit().equals(unit)) continue;
            return currentEntry;
        }
        this.addEntry(new WebEntry(unit));
        return this.getWebEntry(unit);
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=PettyCashEntry.class)
    public synchronized List<PettyCashEntry> getPettyCashEntries() {
        return this.pettyCashEntries.getUnmodifiable();
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=CreditEntry.class)
    public synchronized List<CreditEntry> getCreditEntries() {
        return this.creditEntries.getUnmodifiable();
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=WebEntry.class)
    public synchronized List<WebEntry> getWebEntries() {
        return this.webEntries.getUnmodifiable();
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=TipsEntry.class)
    public synchronized List<TipsEntry> getTipsEntries() {
        return this.tipsEntries.getUnmodifiable();
    }

    public synchronized TipsEntry getTipsEntry(FinanceUnit.FinanceUnitType type) {
        for (TipsEntry element : this.getTipsEntries()) {
            TipsEntry currentEntry = element;
            if (!currentEntry.getFinanceUnit().getType().equals(type.toString())) continue;
            return currentEntry;
        }
        this.addEntry(new TipsEntry(FinanceUnit.getDefaultUnitFor(type)));
        return this.getTipsEntry(type);
    }

    private synchronized void addTipsEntry(TipsEntry entry) {
        Iterator<TipsEntry> it = this.getTipsEntries().iterator();
        while (it.hasNext()) {
            TipsEntry currentEntry = it.next();
            if (!currentEntry.getFinanceUnit().getType().equals(entry.getFinanceUnit().getType())) continue;
            it.remove();
        }
        this.tipsEntries.add(entry);
    }

    @Transient
    @OneToMany(mappedBy="parent", targetEntity=CashOutEntry.class)
    public synchronized CashOutEntry getCashOutEntry() {
        Object obj = this.getResolvedReferenceFromSingletonList(this.cashOutEntry);
        if (obj == null) {
            this.addEntry(new CashOutEntry());
            return this.getCashOutEntry();
        }
        return (CashOutEntry)obj;
    }

    private Object getResolvedReferenceFromSingletonList(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new IllegalStateException("List should not contain more than one value.");
    }

    private Price getTotalFromList(List<? extends AbstractReconciliationEntry> entries) {
        Price total = new Price(0.0, 0.01);
        for (AbstractReconciliationEntry abstractReconciliationEntry : entries) {
            total = total.add(abstractReconciliationEntry.getValue());
        }
        return total;
    }

    @Transient
    public synchronized Price getSystemTips() {
        if (this.systemTips == null) {
            this.systemTips = new QueryReference<PriceReport>(PriceReport.class, CashdrawerReconciliationQueries.getSystemTips(this.getParent(), this.getCashDrawer()));
        }
        return ((PriceReport)this.systemTips.get()).getPrice();
    }

    @Transient
    public synchronized Price getSystemCashOut() {
        if (this.systemCashOut == null) {
            this.systemCashOut = new QueryReference<PriceReport>(PriceReport.class, CashdrawerReconciliationQueries.getSystemCashOut(this.getParent(), this.getCashDrawer()));
        }
        return ((PriceReport)this.systemCashOut.get()).getPrice();
    }

    @Transient
    public synchronized Price getTotalSkims() {
        if (this.totalSkims == null) {
            this.totalSkims = new QueryReference<PriceReport>(PriceReport.class, CashdrawerReconciliationQueries.getTotalSkims(this.getParent(), this.getCashDrawer()));
        }
        return ((PriceReport)this.totalSkims.get()).getPrice();
    }

    protected void setTotalSkims(QueryReference newSkims) {
        this.totalSkims = newSkims;
    }

    @Transient
    public synchronized List<User> getUsers() {
        if (this.users == null) {
            this.users = Query.createQueryList(User.class, CashdrawerReconciliationQueries.getReconciliationUsers(this.getParent(), this.getCashDrawer()));
        }
        return this.users.getUnmodifiable();
    }

    @Transient
    public synchronized Price getActualCashTotal() {
        return this.getTotalFromList(this.actualCashEntries);
    }

    @Transient
    public synchronized Price getCreditTotal() {
        return this.getTotalFromList(this.creditEntries);
    }

    @Transient
    public synchronized Price getWebTotal() {
        return this.getTotalFromList(this.webEntries);
    }

    @Transient
    public synchronized Price getTipsTotal() {
        return this.getTotalFromList(this.tipsEntries);
    }

    @Transient
    public synchronized Price getPettyCashTotal() {
        return this.getTotalFromList(this.pettyCashEntries);
    }

    @Transient
    public synchronized Price getCashOutTotal() {
        return this.getTotalFromList(this.cashOutEntry);
    }

    @Transient
    public synchronized Price getCashVariance() {
        return this.getTotalCashLessFloat().add(this.getPettyCashTotal()).subtract(this.getSystemCash());
    }

    @Transient
    public synchronized Price getCreditVariance() {
        return this.getCreditTotal().subtract(this.getSystemCredit());
    }

    @Transient
    public synchronized Price getTipsVariance() {
        return this.getTipsTotal().subtract(this.getSystemTips());
    }

    @Transient
    public synchronized Price getCashOutVariance() {
        return this.getCashOutEntry().getValue().subtract(this.getSystemCashOut());
    }

    @Transient
    public synchronized Price getWebVariance() {
        return this.getWebTotal().subtract(this.getSystemWeb());
    }

    @Transient
    public synchronized Price getSystemCash() {
        if (this.systemCash == null) {
            this.systemCash = new QueryReference<PriceReport>(PriceReport.class, this.getSystemFinanceTotalQuery(Collections.singletonList("CASH")));
        }
        return ((PriceReport)this.systemCash.get()).getPrice().subtract(this.getSystemCashOut());
    }

    @Transient
    public synchronized Price getSystemCredit() {
        if (this.systemCredit == null) {
            ArrayList<String> financeUnitTypes = new ArrayList<String>(2);
            financeUnitTypes.add("CREDIT");
            financeUnitTypes.add("DEBIT");
            this.systemCredit = new QueryReference<PriceReport>(PriceReport.class, this.getSystemFinanceTotalQuery(financeUnitTypes));
        }
        return ((PriceReport)this.systemCredit.get()).getPrice();
    }

    @Transient
    public synchronized Price getSystemWeb() {
        if (this.systemWeb == null) {
            this.systemWeb = new QueryReference<PriceReport>(PriceReport.class, this.getSystemFinanceTotalQuery(Collections.singletonList("WEB")));
        }
        return ((PriceReport)this.systemWeb.get()).getPrice();
    }

    @Transient
    public synchronized Price getSystemVoucher() {
        if (this.systemVoucher == null) {
            this.systemVoucher = new QueryReference<PriceReport>(PriceReport.class, this.getSystemFinanceTotalQuery(Collections.singletonList(FinanceUnit.VOUCHER_TYPE.toString())));
        }
        return ((PriceReport)this.systemVoucher.get()).getPrice();
    }

    @Transient
    public synchronized Price getTotal() {
        return this.getTotalCashLessFloat().add(this.getPettyCashTotal()).add(this.getCreditTotal()).add(this.getCashOutEntry().getValue()).add(this.getWebTotal());
    }

    @Transient
    public synchronized Price getSystemTotal() {
        return this.getSystemCredit().add(this.getSystemCash().add(this.getCashOutTotal())).add(this.getSystemWeb());
    }

    @Transient
    public synchronized Price getTotalVariance() {
        return this.getTotal().subtract(this.getSystemTotal()).subtract(this.getSystemCashOut());
    }

    @Transient
    public synchronized Price getAllComponentsTotal() {
        return this.getActualCashTotal().add(this.getCashOutTotal()).add(this.getPettyCashTotal()).add(this.getCreditTotal()).add(SystemProperty.getInstance().isReconciliationSystemTotalIncludesTips() ? this.getTipsTotal() : new Price("0.0")).add(this.getWebTotal()).subtract(this.getFloatEntry().getValue());
    }

    @Transient
    public synchronized Price getTotalCashLessFloat() {
        return this.getActualCashTotal().subtract(this.getFloatEntry().getValue());
    }

    private ObjectQuery getSystemFinanceTotalQuery(List<String> financeUnitTypes) {
        return CashdrawerReconciliationQueries.getSystemFinanceTotal(this.getParent(), this.getCashDrawer(), financeUnitTypes);
    }

    protected void setActualCashEntries(List<ActualCashEntry> newActualCashEntries) {
        this.actualCashEntries = this.actualCashEntries.clone();
        this.actualCashEntries.set(newActualCashEntries);
    }

    protected void setSystemTips(QueryReference newSystemTips) {
        this.systemTips = newSystemTips;
    }

    protected void setOverringEntry(List<OverRingEntry> newOverringEntry) {
        this.overringEntry = this.overringEntry.clone();
        this.overringEntry.set(newOverringEntry);
    }

    protected void setPettyCashEntries(List<PettyCashEntry> newPettyCashEntries) {
        this.pettyCashEntries = this.pettyCashEntries.clone();
        this.pettyCashEntries.set(newPettyCashEntries);
    }

    protected void setSystemCashOut(QueryReference newSystemCashOut) {
        this.systemCashOut = newSystemCashOut;
    }

    protected void setSystemCredit(QueryReference newSystemCredit) {
        this.systemCredit = newSystemCredit;
    }

    protected void setSystemWeb(QueryReference newSystemWeb) {
        this.systemWeb = newSystemWeb;
    }

    protected void setSystemVoucher(QueryReference newSystemVoucher) {
        this.systemVoucher = newSystemVoucher;
    }

    protected void setSystemCash(QueryReference newSystemCash) {
        this.systemCash = newSystemCash;
    }

    protected void setCreditEntries(List<CreditEntry> newCreditEntries) {
        this.creditEntries = this.creditEntries.clone();
        this.creditEntries.set(newCreditEntries);
    }

    protected void setWebEntries(List<WebEntry> newWebEntries) {
        this.webEntries = this.webEntries.clone();
        this.webEntries.set(newWebEntries);
    }

    protected void setTipsEntries(List<TipsEntry> newTipsEntries) {
        this.tipsEntries = this.tipsEntries.clone();
        this.tipsEntries.set(newTipsEntries);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<ShiftReconciliation> PARENT;
        public PropertiedObject.Property<CashDrawer> CASHDRAWER;
        public PropertiedObject.Property<FloatEntry> FLOAT_ENTRY;
        public PropertiedObject.Property<OverRingEntry> OVERRING_ENTRY;
        public PropertiedObject.Property<ActualCashEntry> ACTUAL_CASH_ENTRIES;
        public PropertiedObject.Property<PettyCashEntry> PETTY_CASH_ENTRIES;
        public PropertiedObject.Property<CreditEntry> CREDIT_ENTRIES;
        public PropertiedObject.Property<WebEntry> WEB_ENTRIES;
        public PropertiedObject.Property<TipsEntry> TIPS_ENTRIES;
        public PropertiedObject.Property<CashOutEntry> CASH_OUT_ENTRY;
        public final PersistentObject.DerivedProperty<List<User>> USERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "users");
        public final PersistentObject.DerivedProperty<Price> ACTUAL_CASH_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "actualCashTotal");
        public final PersistentObject.DerivedProperty<Price> PETTY_CASH_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "pettyCashTotal");
        public final PersistentObject.DerivedProperty<Price> CASH_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "cashVariance");
        public final PersistentObject.DerivedProperty<Price> CREDIT_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "creditTotal");
        public final PersistentObject.DerivedProperty<Price> WEB_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "webTotal");
        public final PersistentObject.DerivedProperty<Price> WEB_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "webVariance");
        public final PersistentObject.DerivedProperty<Price> CREDIT_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "creditVariance");
        public final PersistentObject.DerivedProperty<Price> TIPS_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "tipsTotal");
        public final PersistentObject.DerivedProperty<Price> TIPS_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "tipsVariance");
        public final PersistentObject.DerivedProperty<Price> CASH_OUT_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "cashOutVariance");
        public final PersistentObject.DerivedProperty<Price> TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "total");
        public final PersistentObject.DerivedProperty<Price> SYSTEM_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemTotal");
        public final PersistentObject.DerivedProperty<Price> TOTAL_VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "totalVariance");
        public final PersistentObject.DerivedProperty<Price> TOTAL_CASH_LESS_FLOAT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "totalCashLessFloat");
        public final PersistentObject.DerivedProperty<Price> ALL_COMPONENTS_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "allComponentsTotal");
        public PersistentObject.DerivedProperty SYSTEM_CASH = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemCash");
        public PersistentObject.DerivedProperty SYSTEM_CREDIT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemCredit");
        public PersistentObject.DerivedProperty SYSTEM_WEB = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemWeb");
        public PersistentObject.DerivedProperty SYSTEM_TIPS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemTips");
        public PersistentObject.DerivedProperty SYSTEM_CASH_OUT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemCashOut");
        public PersistentObject.DerivedProperty SYSTEM_VOUCHER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "systemVoucher");
        public PersistentObject.DerivedProperty TOTAL_SKIMS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerReconciliation.class), "totalSkims");
    }
}

