/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.CreditEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.queries.hardware.CashDrawerQueries;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="finance_reconciliation_shift")
@AccessType(value="property")
public class ShiftReconciliation
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<Shift> shift;
    private Reference<User> user;
    private PersistentWriteableList<CashdrawerReconciliation> cashdrawerRecons;
    private String bankedBy;
    private String approvedBy;
    private Date dateBanked;
    private QueryReference shiftCovers;
    private QueryReference tradingDayCovers;
    private boolean completed;

    private void clearQueryReferences() {
        this.shiftCovers = null;
        this.tradingDayCovers = null;
    }

    public ShiftReconciliation() {
        this.shift = this.createReference(ShiftReconciliation.Properties.SHIFT);
        this.user = this.createReference(ShiftReconciliation.Properties.USER);
        this.cashdrawerRecons = (PersistentWriteableList)this.createList(ShiftReconciliation.Properties.CASHDRAWER_RECONS);
    }

    @Override
    public void init() {
        super.init();
        this.getLabel();
    }

    @Transient
    public String getLabel() {
        if (this.getShift() == null) {
            return "";
        }
        return this.getShift().getLabel();
    }

    public ShiftReconciliation(Shift theShift, User theUser) {
        this.shift = this.createReference(ShiftReconciliation.Properties.SHIFT);
        this.user = this.createReference(ShiftReconciliation.Properties.USER);
        this.cashdrawerRecons = (PersistentWriteableList)this.createList(ShiftReconciliation.Properties.CASHDRAWER_RECONS);
        this.setShift(theShift);
        this.setUser(theUser);
        this.initCashdrawerRecons();
    }

    public void setShift(Shift theShift) {
        this.shift.set(theShift);
        this.clearQueryReferences();
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    public void setUser(User theUser) {
        this.user.set(theUser);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    @Transient
    public List<CashdrawerReconciliation> getCashDrawerReconciliations() {
        return this.cashdrawerRecons.getUnmodifiable();
    }

    public CashdrawerReconciliation getCashDrawerReconciliation(CashDrawer drawer) {
        for (CashdrawerReconciliation rec : this.cashdrawerRecons) {
            if (!rec.getCashDrawer().equals(drawer)) continue;
            return rec;
        }
        OrderMate.LOG.error("No cash drawer reconciliation found for drawer : " + drawer);
        return null;
    }

    private void initCashdrawerRecons() {
        Iterator<CashDrawer> allCashdrawersIt = CashDrawerQueries.getAllCashdrawers().iterator();
        while (allCashdrawersIt.hasNext()) {
            this.cashdrawerRecons.add(new CashdrawerReconciliation(this, allCashdrawersIt.next()));
        }
    }

    @Override
    public void delete() {
        this.cashdrawerRecons.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.cashdrawerRecons.saveChild();
    }

    @Transient
    public Price getSystemActualCashTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getSystemCash());
        }
        return total;
    }

    @Transient
    public Price getSystemCashOutTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getCashOutTotal());
        }
        return total;
    }

    @Transient
    public Price getSystemCreditTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getSystemCredit());
            total = total.add(recon.getSystemCashOut());
        }
        return total;
    }

    @Transient
    public Price getSystemWebTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getSystemWeb());
        }
        return total;
    }

    @Transient
    public Price getSystemVoucherTotal() {
        Price total = Price.ZERO_DOLLAR;
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getSystemVoucher());
        }
        return total;
    }

    @Transient
    public Price getSystemTipsTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getSystemTips());
        }
        return total;
    }

    @Transient
    public Price getSystemTotal() {
        Price systemTotal = this.getSystemActualCashTotal().add(this.getSystemCreditTotal().add(this.getSystemCashOutTotal()).add(this.getSystemWebTotal()));
        return systemTotal;
    }

    @Transient
    public Price getTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getTotal());
        }
        return total;
    }

    @Transient
    public Price getOverringTotal() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getOverringEntry().getValue());
        }
        return total;
    }

    @Transient
    public int getShiftCovers() {
        if (this.shiftCovers == null) {
            this.shiftCovers = new QueryReference<NumberReport>(NumberReport.class, Query.selectFunc("SUM(" + TableAccount.Properties.NUM_PATRONS + ") AS value").equals(Account.Properties.SHIFT, this.shift.getObjectID()));
        }
        return ((NumberReport)this.shiftCovers.get()).intValue();
    }

    @Transient
    public int getTradingDayCovers() {
        if (this.tradingDayCovers == null) {
            this.tradingDayCovers = new QueryReference<NumberReport>(NumberReport.class, Query.selectFunc("SUM(" + TableAccount.Properties.NUM_PATRONS + ") AS value").equals(Account.Properties.SHIFT, this.shift.getObjectID()));
        }
        return ((NumberReport)this.tradingDayCovers.get()).intValue();
    }

    @Transient
    public Price getDollarsPerShiftCover() {
        if (this.getShiftCovers() != 0) {
            return this.getSystemTotal().divide(this.getShiftCovers());
        }
        return Price.ZERO_DOLLAR;
    }

    @Transient
    public Price getTotalActualCashLessFloat() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
            total = total.add(recon.getTotalCashLessFloat());
        }
        return total;
    }

    @Transient
    public Price getTotalPaperCheque() {
        Price total = new Price(0.0, 0.01);
        if (FinanceUnit.getPaperChequeType() != null) {
            for (CashdrawerReconciliation recon : this.getCashDrawerReconciliations()) {
                CreditEntry entry = recon.getCreditEntry(FinanceUnit.getPaperChequeType());
                if (entry == null) continue;
                total = total.add(entry.getValue());
            }
        }
        return total;
    }

    @Transient
    public Price getTotalBanking() {
        return this.getTotalActualCashLessFloat().add(this.getTotalPaperCheque());
    }

    @Column(name="banked_by")
    public String getBankedBy() {
        return this.bankedBy;
    }

    public void setBankedBy(String banker) {
        this.bankedBy = banker;
    }

    @Column(name="approved_by")
    public String getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(String approver) {
        this.approvedBy = approver;
    }

    @Column(name="date_banked")
    @Temporal(value=TemporalType.DATE)
    public Date getDateBanked() {
        return this.dateBanked;
    }

    public void setDateBanked(Date date) {
        this.dateBanked = date;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @OneToMany(mappedBy="parent", targetEntity=CashdrawerReconciliation.class)
    protected List<CashdrawerReconciliation> getCashdrawerRecons() {
        return this.cashdrawerRecons;
    }

    protected void setCashdrawerRecons(List<CashdrawerReconciliation> cashdrawerRecons) {
        this.cashdrawerRecons = this.cashdrawerRecons.clone();
        this.cashdrawerRecons.set(cashdrawerRecons);
    }

    @Column(name="completed")
    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Transient
    public Price getTotalCashVariance() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation cashdrawerRec : this.cashdrawerRecons) {
            total = total.add(cashdrawerRec.getCashVariance());
        }
        return total;
    }

    @Transient
    public Price getTotalCreditVariance() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation cashdrawerRec : this.cashdrawerRecons) {
            total = total.add(cashdrawerRec.getCreditVariance());
        }
        return total;
    }

    @Transient
    public Price getTotalCashOutVariance() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation cashdrawerRec : this.cashdrawerRecons) {
            total = total.add(cashdrawerRec.getCashOutVariance());
        }
        return total;
    }

    @Transient
    public Price getTotalWebVariance() {
        Price total = new Price(0.0, 0.01);
        for (CashdrawerReconciliation cashdrawerRec : this.cashdrawerRecons) {
            total = total.add(cashdrawerRec.getWebVariance());
        }
        return total;
    }

    public static class Reports {
        private static LocalCacheListManager<ShiftReconciliation> allShifts = new LocalCacheListManager<ShiftReconciliation>(Query.createQueryList(ShiftReconciliation.class, Reports.getAllShiftsReconQuery().toString()));
        private static String shiftsWithoutReconciliationQuery = "SELECT * FROM finance_shift INNER JOIN finance_trading_day ON fk_finance_trading_day = finance_trading_day.ID LEFT JOIN finance_reconciliation_shift ON fk_finance_shift = finance_shift.ID WHERE finance_reconciliation_shift.ID IS NULL ORDER BY finance_trading_day.day DESC, finance_trading_day.time DESC ";

        public static List<Shift> getShiftsWithoutReconciliation() {
            return PersistenceManager.getObjectList(Shift.class, shiftsWithoutReconciliationQuery + " LIMIT 30 ", new Object[0]);
        }

        public static Shift getRecentShiftWithoutReconciliation() {
            return PersistenceManager.getObject(Shift.class, shiftsWithoutReconciliationQuery + " LIMIT 1 ", new Object[0]);
        }

        public static List<ShiftReconciliation> getShiftReconciliations() {
            return allShifts.getList();
        }

        public static void clearLocalListCaches() {
            allShifts.clearCache();
        }

        public static final ObjectQuery getAllShiftsReconQuery() {
            return Query.select(ShiftReconciliation.class).orderByDesc(ShiftReconciliation.Properties.SHIFT);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<CashdrawerReconciliation> CASHDRAWER_RECONS;
        public PropertiedObject.Property BANKED_BY;
        public PropertiedObject.Property APPROVED_BY;
        public PropertiedObject.Property DATE_BANKED;
        public PersistentObject.DerivedProperty<Price> SYSTEM_ACTUAL_CASH_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ShiftReconciliation.class), "systemActualCashTotal");
        public PersistentObject.DerivedProperty<Price> SYSTEM_CREDIT_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ShiftReconciliation.class), "systemCreditTotal");
        public PropertiedObject.Property COMPLETED;
    }
}

