/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation.entries;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CREDIT")
@AccessType(value="property")
public class CreditEntry
extends AbstractReconciliationEntry {
    public static final AbstractReconciliationEntry.RecEntryType TYPE = AbstractReconciliationEntry.RecEntryType.CREDIT;
    public static final Props Properties = new Props();

    @Override
    @Transient
    public AbstractReconciliationEntry.RecEntryType getType() {
        return TYPE;
    }

    public CreditEntry() {
    }

    public CreditEntry(FinanceUnit unit) {
        if (!FinanceUnit.getElectronicUnits().contains(unit)) {
            throw new IllegalArgumentException("Credit reconciliation entries must be either CREDIT or DEBIT finance unit type :" + unit);
        }
        this.setFinanceUnit(unit);
    }

    public static class Props
    extends AbstractReconciliationEntry.Props {
    }
}

