/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation.entries;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="PETTY_CASH")
@AccessType(value="property")
public class PettyCashEntry
extends AbstractReconciliationEntry {
    public static final AbstractReconciliationEntry.RecEntryType TYPE = AbstractReconciliationEntry.RecEntryType.PETTY_CASH;
    public static final Props Properties = new Props();
    private boolean purchase = false;
    private Reference<User> user;
    private String description;
    private Date created;

    public PettyCashEntry() {
        this.user = this.createReference(PettyCashEntry.Properties.USER);
        this.description = "";
    }

    @Override
    @Transient
    public AbstractReconciliationEntry.RecEntryType getType() {
        return TYPE;
    }

    @Column(name="is_purchase")
    public boolean isPurchase() {
        return this.purchase;
    }

    public void setPurchase(boolean setIt) {
        this.purchase = setIt;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User value) {
        this.user.set(value);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    @Transient
    public Shift getShift() {
        return this.getParent().getParent().getShift();
    }

    @Transient
    public String getShiftLabel() {
        return this.getParent().getParent().getShift().toString();
    }

    @Transient
    public String getAllocation() {
        return this.isPurchase() ? "Purchase" : "Expense";
    }

    @Override
    public void saveChild() {
        if (this.created == null) {
            this.created = new Date();
        }
        super.saveChild();
    }

    @Override
    @Transient
    public String getLabel() {
        String label = this.isPurchase() ? "Purchase" : "Expense";
        label = label + " " + this.getDescription();
        label = label + "- " + this.getValue();
        return label;
    }

    public static class Props
    extends AbstractReconciliationEntry.Props {
        public PropertiedObject.Property PURCHASE;
        public PropertiedObject.Property DESCRIPTION;
        public PropertiedObject.Property USER;
        public PropertiedObject.Property CREATED;
        public PersistentObject.DerivedProperty SHIFT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PettyCashEntry.class), "shift");
        public PersistentObject.DerivedProperty SHIFT_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PettyCashEntry.class), "shiftLabel");
        public PersistentObject.DerivedProperty ALLOCATION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PettyCashEntry.class), "allocation");
    }
}

