/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reconciliation.entries;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="WEB")
@AccessType(value="property")
public class WebEntry
extends AbstractReconciliationEntry {
    public static final AbstractReconciliationEntry.RecEntryType TYPE = AbstractReconciliationEntry.RecEntryType.WEB;
    public static final Props Properties = new Props();

    @Override
    @Transient
    public AbstractReconciliationEntry.RecEntryType getType() {
        return TYPE;
    }

    @Deprecated
    public WebEntry() {
    }

    public WebEntry(FinanceUnit unit) {
        if (!FinanceUnit.getWebUnits().contains(unit)) {
            throw new IllegalArgumentException("Web reconciliation entries must be a WEB finance unit type :" + unit);
        }
        this.setFinanceUnit(unit);
    }

    public static class Props
    extends AbstractReconciliationEntry.Props {
    }
}

