/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.sales.AccountType;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class AccountTotalsReport
extends TotalsReport {
    public static final Props Properties = new Props();
    private String accountState = "NONE";
    private Price totalAdjustments = new Price(0.0, 1.0E-4);
    private AccountType accountType;
    private int totalPatrons;

    @Override
    public String toString() {
        String accType = this.getAccountType() + "";
        if (accType.isEmpty()) {
            accType = "ALL";
        }
        return "AccountsTotalsReport: " + this.getID() + " :" + this.getAccountState() + " - " + this.getAccountType() + "  " + this.getTotal();
    }

    @Column(name="account_state")
    public String getAccountState() {
        return this.accountState;
    }

    protected void setAccountState(String accState) {
        this.accountState = accState;
    }

    @Transient
    public Price getTotalExDiscounts() {
        return this.getTotal().add(this.getTotalAdjustments());
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    @Column(name="acc_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    protected void setAccountType(AccountType type) {
        this.accountType = type;
    }

    @Transient
    public boolean isOpen() {
        return this.getAccountState().equalsIgnoreCase("OPEN");
    }

    public AccountTotalsReport add(AccountTotalsReport report) {
        AccountTotalsReport newTotalReport = new AccountTotalsReport();
        newTotalReport.accountState = this.getAccountState().equalsIgnoreCase(report.getAccountState()) ? this.getAccountState() : "ALL";
        newTotalReport.accountType = this.accountType != null && this.getAccountType().equals(report.getAccountType()) ? report.getAccountType() : null;
        newTotalReport.setCount(this.getCount() + report.getCount());
        newTotalReport.setTotal(this.getTotal().add(report.getTotal()));
        newTotalReport.totalAdjustments = this.getTotalAdjustments().add(report.getTotalAdjustments());
        newTotalReport.totalPatrons = this.getTotalPatrons() + report.getTotalPatrons();
        newTotalReport.setTotalTax(this.getTotalTax().add(report.getTotalTax()));
        return newTotalReport;
    }

    @Transient
    protected ObjectQuery getSummaryQuery() {
        return null;
    }

    public boolean filter(AccountType type, Boolean isOpen) {
        boolean isValid = true;
        if (type != null) {
            isValid &= type.equals(this.getAccountType());
        }
        if (isOpen != null) {
            isValid &= this.isOpen() == isOpen.booleanValue();
        }
        return isValid;
    }

    public void setTotalAdjustments(Price adjustments) {
        this.totalAdjustments = adjustments;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="total_adjustments")
    public Price getTotalAdjustments() {
        return this.totalAdjustments;
    }

    @Transient
    public String getAverage() {
        if (this.getCount() != 0L) {
            return this.getTotal().divide(this.getCount()) + "";
        }
        return Price.ZERO_DOLLAR + "";
    }

    @Transient
    public Price getDollarsPerHead() {
        if (this.totalPatrons != 0 && !this.getTotal().isZero()) {
            return this.getTotal().divide(this.totalPatrons);
        }
        return Price.ZERO_DOLLAR;
    }

    @Column(name="total_patrons")
    public int getTotalPatrons() {
        return this.totalPatrons;
    }

    public void setTotalPatrons(int totalPatrons) {
        this.totalPatrons = totalPatrons;
    }

    public static class Props
    extends TotalsReport.Props {
        public PropertiedObject.Property<String> ACCOUNT_STATE;
        public PropertiedObject.Property<AccountType> ACCOUNT_TYPE;
        public PropertiedObject.Property<Price> TOTAL_ADJUSTMENTS;
        public PersistentObject.DerivedProperty<Price> TOTAL_EX_DISCOUNTS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountTotalsReport.class), "totalExDiscounts");
        public PersistentObject.DerivedProperty<String> AVERAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountTotalsReport.class), "average");
        public PropertiedObject.Property<Integer> TOTAL_PATRONS;
        public PersistentObject.DerivedProperty DOLLARS_PER_HEAD = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountTotalsReport.class), "dollarsPerHead");
    }
}

