/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.finance.reports.AccountTotalsReportQuery;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;

public class AccountTotalsReportHelper {
    public static List<AccountTotalsReport> getAccountTotalsReport(Shift shift) {
        return AccountTotalsReportHelper.getAccountTotalsReport(shift, shift);
    }

    public static List<AccountTotalsReport> getAccountTotalsReport(Shift startShift, Shift endShift) {
        if (startShift == null || endShift == null) {
            return new ArrayList<AccountTotalsReport>();
        }
        Long startShiftID = new Long(0L);
        Long endShiftID = new Long(0L);
        if (startShift != null) {
            startShiftID = startShift.getID();
        }
        if (endShift != null) {
            endShiftID = endShift.getID();
        }
        String query = AccountTotalsReportQuery.getAccountTotalQuery();
        List<AccountTotalsReport> returnList = PersistenceManager.getObjectList(AccountTotalsReport.class, query, new Object[]{startShiftID, endShiftID, startShiftID, endShiftID});
        if (SystemProperty.getInstance().isCombosAsDiscount()) {
            returnList = AccountTotalsReportHelper.applyCombosAsDiscounts(returnList, startShift, endShift);
        }
        return returnList;
    }

    private static final List<AccountTotalsReport> applyCombosAsDiscounts(List<AccountTotalsReport> reportList, Shift startShift, Shift endShift) {
        ObjectQuery query = AccountTotalsReportQuery.getOpenPriceComboDiscounts("total_adjustments");
        query.select(Account.Properties.ACCOUNT_TYPE, "acc_type").select(Account.Properties.ACCOUNT_STATE).selectFunc("0 as total_patrons").selectFunc("0 as total_tax").selectFunc("0 as count").selectFunc("0 as total").selectFunc("null as fk_config_sales_location").select(Account.Properties.CREATION_DATE_TIME, "total_date").linkUsing(SalesItem.Properties.ACCOUNT).wherePropertyBetween(Account.Properties.SHIFT, startShift, endShift).groupBy(Account.Properties.ACCOUNT_TYPE).groupBy(Account.Properties.ACCOUNT_STATE);
        List<AccountTotalsReport> adjs = PersistenceManager.getObjectList(AccountTotalsReport.class, query.toString());
        ArrayList<AccountTotalsReport> newReports = new ArrayList<AccountTotalsReport>(reportList.size());
        boolean added = false;
        for (AccountTotalsReport report : reportList) {
            for (AccountTotalsReport adj : adjs) {
                if (!report.getAccountState().equals(adj.getAccountState()) || !report.getAccountType().equals(adj.getAccountType())) continue;
                AccountTotalsReport newReport = report.add(adj);
                newReports.add(newReport);
                added = true;
                break;
            }
            if (!added) {
                newReports.add(report);
                continue;
            }
            added = false;
        }
        return newReports;
    }

    public static int getNumOfAccountsWithSalesNotOnShift(Shift shift) {
        String query = "SELECT  count(distinct sales_account.ID) FROM sales_account INNER JOIN sales_item ON sales_account.ID = sales_item.FK_sales_account INNER JOIN sales_item_quantity ON sales_item.ID = sales_item_quantity.FK_sales_item WHERE  sales_account.FK_finance_shift = ? AND sales_item_quantity.FK_finance_shift != ? UNION SELECT  count(distinct sales_account.ID) FROM sales_account INNER JOIN sales_item ON sales_account.ID = sales_item.FK_sales_account INNER JOIN sales_item_quantity ON sales_item.ID = sales_item_quantity.FK_sales_item WHERE sales_item_quantity.FK_finance_shift = ?  AND sales_account.FK_finance_shift != ?";
        Object[][] resultSet = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT  count(distinct sales_account.ID) FROM sales_account INNER JOIN sales_item ON sales_account.ID = sales_item.FK_sales_account INNER JOIN sales_item_quantity ON sales_item.ID = sales_item_quantity.FK_sales_item WHERE  sales_account.FK_finance_shift = ? AND sales_item_quantity.FK_finance_shift != ? UNION SELECT  count(distinct sales_account.ID) FROM sales_account INNER JOIN sales_item ON sales_account.ID = sales_item.FK_sales_account INNER JOIN sales_item_quantity ON sales_item.ID = sales_item_quantity.FK_sales_item WHERE sales_item_quantity.FK_finance_shift = ?  AND sales_account.FK_finance_shift != ?", new Object[]{shift.getID(), shift.getID(), shift.getID(), shift.getID()});
        int accountsTodayWithSalesOnAnotherDay = 0;
        int accountFromAnotherWithSalesFromToday = 0;
        if (resultSet != null) {
            Number intObj;
            if (resultSet[0] != null) {
                intObj = (Number)resultSet[0][0];
                int n = accountsTodayWithSalesOnAnotherDay = intObj != null ? intObj.intValue() : 0;
            }
            if (resultSet.length > 1 && resultSet[1] != null) {
                intObj = (Number)resultSet[1][0];
                accountFromAnotherWithSalesFromToday = intObj != null ? intObj.intValue() : 0;
            }
        }
        return accountFromAnotherWithSalesFromToday + accountsTodayWithSalesOnAnotherDay;
    }
}

