/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class AccountTotalsReportQuery {
    public static final String getAccountTotalQuery() {
        return "SELECT 1 as 'ID', tmpAccs.*, total_patrons FROM (SELECT sales_account.account_state, sales_account.account_type AS acc_type, sales_account.Creation_Time as 'total_date', COUNT(DISTINCT sales_account.ID ) AS count, sales_item_quantity.fk_config_sales_location as fk_config_sales_location, SUM(sales_component.unit_price * sales_item_quantity.quantity) AS total,IFNULL(SUM(sales_component.item_discount_total * sales_item_quantity.quantity + account_discount_total* sales_item_quantity.quantity + account_surcharge_total* sales_item_quantity.quantity + item_surcharge_total * sales_item_quantity.quantity) , 0) AS total_adjustments,SUM(sales_component.saved_total_tax) AS total_tax FROM sales_account left JOIN sales_item ON fk_sales_account = sales_account.ID left JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID left join sales_component on sales_component.fk_sales_item = sales_item.ID WHERE sales_account.FK_finance_shift BETWEEN ? AND ? GROUP BY sales_account.account_state, sales_account.account_type) AS tmpAccs LEFT JOIN (SELECT sales_account.account_type, account_state, SUM(Patrons) as total_patrons FROM sales_account WHERE sales_account.FK_finance_shift BETWEEN ? AND ? GROUP BY sales_account.account_state, sales_account.account_type) AS tmpPatrons ON tmpAccs.acc_type = tmpPatrons.account_type and tmpAccs.account_state = tmpPatrons.account_state;";
    }

    public static final ObjectQuery getOpenPriceComboDiscounts(String priceColName) {
        ObjectQuery query = Query.select(SalesComponent.Properties.ID).selectFunc("SUM(sales_item_quantity.quantity * (sales_component.menu_price - sales_component.open_price)) as " + priceColName).from("sales_item", "combo").linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing("sales_item_quantity", "fk_sales_item", "sales_item").linkUsing("sales_item", "fk_sales_combo", "combo").not().isNull(SalesComponent.Properties.OPEN_PRICE).not().isNull(SalesItem.Properties.PARENT_COMBO).whereFunction("combo.type NOT IN ('SimpleCombo', 'SalesAdjustmentCombo', 'SalesItem')");
        return query;
    }

    public static final ObjectQuery getAdjustmentComboDiscounts() {
        ObjectQuery query = Query.select(SalesPriceAdjustmentUsage.Properties.ID).sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesPriceAdjustmentUsage.Properties.UNIT_VALUE, "price").linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).from("sales_item", "sales_combo").whereFunction("sales_item.fk_sales_combo = sales_combo.ID").whereFunction("sales_combo.fk_inventory_combo = inventory_combo.ID").linkUsing(SalesPriceAdjustment.Properties.INVENTORY_PRICE_ADJUSTMENT, InventoryAdjustmentCombo.Properties.PRICE_ADJUSTMENT);
        return query;
    }

    public static ObjectQuery getObjectQuery() {
        ObjectQuery query = Query.selectFunc("MAX(" + Account.Properties.ACCOUNT_STATE + ") as account_state").selectFunc("MAX(" + Account.Properties.ACCOUNT_TYPE + ") AS acc_type").selectFunc("COUNT(DISTINCT sales_account.ID) AS count").select(Account.Properties.CREATION_DATE_TIME, "total_date").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").selectFunc("IFNULL(SUM(" + SalesComponent.Properties.ITEM_DISCOUNT_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "+ " + SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "+ " + SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "+ " + SalesComponent.Properties.ITEM_SURCHARGE_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "),0.0) AS total_adjustments").select(SalesItemQuantity.Properties.SALES_LOCATION).sumMultiplication(SalesComponent.Properties.UNIT_TAX_AMOUNT, SalesItemQuantity.Properties.QUANTITY, "total_tax").select(Account.Properties.CREATION_DATE_TIME, "total_date").selectFunc("0 AS total_patrons").linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM);
        return query;
    }
}

