/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.Data;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.DebtorGroupTakings;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.queries.finance.voucher.VoucherTransactionQueries;
import ordermate.database.reports.general.PriceReport;

public class CashDrawerTakingsSummary
implements Serializable {
    private Map<FinanceUnit, Double> subtypeTakings;
    private CashDrawer cashDrawer;
    private Shift shift;
    private Price tips;
    private Price totalCashOut;
    private List debtorTakings = new ArrayList();
    private double addedTabs;
    private double paidTabs;
    private double discountedTabs;
    private Map<FinanceUnit, Price> subtypeTips;
    private Price cashTips;
    private Price totalCardTips;
    private Price totalWebTips;
    private Price totalVoucherRedeems = Price.ZERO_DOLLAR;
    private Price terminalVoucherPurchases = Price.ZERO_DOLLAR;
    private Price terminalVoucherTopupReversals = Price.ZERO_DOLLAR;
    private Price terminalVoucherRedeemReversals = Price.ZERO_DOLLAR;

    public CashDrawerTakingsSummary() {
        this.subtypeTakings = new HashMap<FinanceUnit, Double>();
        this.subtypeTips = new HashMap<FinanceUnit, Price>();
        this.fillTipTypes();
        this.tips = Price.ZERO_DOLLAR;
        this.cashTips = Price.ZERO_DOLLAR;
        this.totalCardTips = Price.ZERO_DOLLAR;
    }

    private void fillTipTypes() {
        for (FinanceUnit unit : FinanceUnit.getCardPayableUnits()) {
            this.subtypeTips.put(unit, Price.ZERO_DOLLAR);
        }
        for (FinanceUnit unit : FinanceUnit.getWebUnits()) {
            this.subtypeTips.put(unit, Price.ZERO_DOLLAR);
        }
    }

    public Shift getShift() {
        return this.shift;
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer;
    }

    public Price getTotalTakings() {
        ArrayList<FinanceUnit> units = new ArrayList<FinanceUnit>();
        units.add(CashTransaction.getCashFinanceUnit());
        units.addAll(CreditTransaction.getCreditUnitTypes());
        units.addAll(DebitTransaction.getDebitUnitTypes());
        units.addAll(WebTransaction.getWebUnitTypes());
        return this.getUnitTakings(units, false).add(this.getTotalCashOut());
    }

    public Price getCashTakings(boolean includesSkims) {
        return this.getUnitTakings(CashTransaction.getCashFinanceUnit(), includesSkims);
    }

    public Price getCreditTakings(boolean includesSkims) {
        return this.getUnitTakings(CreditTransaction.getCreditUnitTypes(), includesSkims);
    }

    public Price getDebitTakings(boolean includesSkims) {
        return this.getUnitTakings(DebitTransaction.getDebitUnitTypes(), includesSkims);
    }

    public Price getWebTakings(boolean includesSkims) {
        return this.getUnitTakings(WebTransaction.getWebUnitTypes(), includesSkims);
    }

    public Price getTotalCardsTakings(boolean includesSkims) {
        Price totalCards = this.getUnitTakings(CreditTransaction.getCreditUnitTypes(), includesSkims).add(this.getUnitTakings(DebitTransaction.getDebitUnitTypes(), includesSkims));
        return totalCards;
    }

    private Price getUnitTakings(List units, boolean includeSkims) {
        double value = 0.0;
        for (FinanceUnit unit : units) {
            Double o = this.subtypeTakings.get(unit);
            if (o != null) {
                value += o.doubleValue();
            }
            if (CashTransaction.getCashFinanceUnit().equals(unit)) {
                value -= this.getTotalCashOut().doubleValue();
            }
            if (!includeSkims) continue;
            double skimAmount = this.getCashDrawer().getSkimTotalForShift(this.getShift(), unit).doubleValue();
            value -= skimAmount;
        }
        return new Price(value, 0.01);
    }

    public Price getUnitTakings(FinanceUnit unit, boolean includeSkims) {
        return this.getUnitTakings(Collections.singletonList(unit), includeSkims);
    }

    public Price getTotalTips() {
        return this.tips;
    }

    public static CashDrawerTakingsSummary getSummary(CashDrawer cashdrawer, Shift shift) {
        try {
            CashDrawerTakingsSummary summary = Data.database.getCashDrawerTakingsSummary(cashdrawer, shift);
            summary.shift = shift;
            summary.cashDrawer = cashdrawer;
            ExperimentalFeature debtorTakingsPerCashDrawer = ExperimentalFeature.find("DEBTOR_TAKINGS_PER_CASHDRAWER");
            if (debtorTakingsPerCashDrawer != null && debtorTakingsPerCashDrawer.getBooleanValue(Boolean.FALSE).booleanValue()) {
                summary.addDebtorTakings(DebtorGroupTakings.getTakingsSummary(shift, cashdrawer));
            } else {
                summary.addDebtorTakings(DebtorGroupTakings.getTakingsSummary(shift, null));
            }
            summary.addVouchersInfo(cashdrawer, shift);
            return summary;
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    private void addVouchersInfo(CashDrawer theCashDrawer, Shift theShift) {
        PriceReport report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherRedeemsSum(theCashDrawer, theShift).toString());
        this.setTotalVoucherRedeems(report != null ? report.getPrice().abs() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherPurchasesSum(theCashDrawer.getHost(), theShift).toString());
        this.setTerminalVoucherPurchases(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherTopupReversalsSum(theCashDrawer.getHost(), theShift).toString());
        this.setTerminalVoucherTopupReversals(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherRedeemReversalsSum(theCashDrawer.getHost(), theShift).toString());
        this.setTerminalVoucherRedeemReversals(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
    }

    public Price getTotalPaidCustomerAccounts() {
        return new Price(this.paidTabs, 0.01);
    }

    public boolean hasTotalPaidCustomerAccounts() {
        return this.paidTabs > 0.0;
    }

    public Price getTotalAddedCustomerAccounts() {
        return new Price(this.addedTabs, 0.01);
    }

    public Price getTotalDiscountedCustomerAccounts() {
        return new Price(this.discountedTabs, 0.01);
    }

    public boolean hasDiscountedCustomerTabs() {
        return !(this.discountedTabs < 0.005) || !(this.discountedTabs > -0.005);
    }

    public void setUnitTakings(FinanceUnit unit, double takings) {
        this.subtypeTakings.put(unit, new Double(takings));
    }

    public void addDebtorTakings(List newDebtorGroupTakings) {
        this.debtorTakings.addAll(newDebtorGroupTakings);
    }

    public List getDebtorGroupTakings() {
        return this.debtorTakings;
    }

    public List<Pair<String, String>> getDebtorReportList() {
        ArrayList<Pair<String, String>> returnList = new ArrayList<Pair<String, String>>();
        Iterator debtorTakingsIt = this.getDebtorGroupTakings().iterator();
        PersistentObject previousGroup = null;
        while (debtorTakingsIt.hasNext()) {
            DebtorGroupTakings localDebtorTakings = (DebtorGroupTakings)debtorTakingsIt.next();
            if (previousGroup == null || !previousGroup.equals(localDebtorTakings.getDebtorGroup())) {
                returnList.add(new Pair<String, Object>(localDebtorTakings.getDebtorGroup().getName(), null));
            }
            String debtorInfo = "    " + localDebtorTakings.getDebtor().getLabel();
            StringBuilder SB = new StringBuilder();
            if (localDebtorTakings.hasAdded()) {
                SB.append(" Added " + localDebtorTakings.getNettAdded());
            }
            if (localDebtorTakings.hasPaid()) {
                SB.append(" Paid " + localDebtorTakings.getNettPaid());
            }
            returnList.add(new Pair<String, String>(debtorInfo, SB.toString()));
            previousGroup = localDebtorTakings.getDebtorGroup();
        }
        DebtorGroupTakings totalDebtorTakings = DebtorGroupTakings.getTotal(this.getDebtorGroupTakings());
        returnList.add(new Pair<String, Object>("", null));
        returnList.add(new Pair<String, String>("Debtor Sales:", totalDebtorTakings.getNettAdded().toString()));
        if (totalDebtorTakings.hasPaid()) {
            returnList.add(new Pair<String, String>("Debtor Payments:", totalDebtorTakings.getNettPaid().toString()));
        }
        if (totalDebtorTakings.hasDiscounted()) {
            returnList.add(new Pair<String, String>("Debtor Discounts: ", totalDebtorTakings.getDiscounted().toString()));
        }
        return returnList;
    }

    public void setTips(double newTips) {
        this.tips = new Price(newTips, 0.01);
    }

    public void setTotalCashOut(double cashOut) {
        this.totalCashOut = new Price(cashOut, 0.01);
    }

    public Price getTotalCashOut() {
        return this.totalCashOut;
    }

    public Price getTotalSkims() {
        return this.getCashDrawer().getSkimTotalForShift(this.getShift());
    }

    public Price getUnitSkims(FinanceUnit unit) {
        return this.getCashDrawer().getSkimTotalForShift(this.getShift(), unit);
    }

    public Price getCashTips() {
        return this.cashTips;
    }

    public void setCashTips(double cashTips) {
        this.cashTips = new Price(cashTips, 0.01);
    }

    public Price getTotalCardTips() {
        return this.totalCardTips;
    }

    public void setTotalCardTips(double cardTips) {
        this.totalCardTips = new Price(cardTips, 0.01);
    }

    public Price getTotalWebTips() {
        return this.totalWebTips;
    }

    public void setTotalWebTips(double value) {
        this.totalWebTips = new Price(value, 0.01);
    }

    public Map<FinanceUnit, Price> getSubtypeTips() {
        return this.subtypeTips;
    }

    public void setTipForSubtype(FinanceUnit unit, Price value) {
        this.subtypeTips.put(unit, value);
    }

    public void setTotalVoucherRedeems(Price voucherRedeems) {
        this.totalVoucherRedeems = voucherRedeems;
    }

    public Price getTotalVoucherRedeems() {
        return this.totalVoucherRedeems;
    }

    public Price getTerminalVoucherPurchases() {
        return this.terminalVoucherPurchases;
    }

    public void setTerminalVoucherPurchases(Price voucherPurchases) {
        this.terminalVoucherPurchases = voucherPurchases;
    }

    public Price getTerminalVoucherTopupReversals() {
        return this.terminalVoucherTopupReversals;
    }

    public void setTerminalVoucherTopupReversals(Price voucherTopupReversals) {
        this.terminalVoucherTopupReversals = voucherTopupReversals;
    }

    public Price getTerminalVoucherRedeemReversals() {
        return this.terminalVoucherRedeemReversals;
    }

    public void setTerminalVoucherRedeemReversals(Price voucherRedeemReversals) {
        this.terminalVoucherRedeemReversals = voucherRedeemReversals;
    }
}

