/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.queries.reports.DebtorGroupTakingsQueries;

public class DebtorGroupTakings
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<DebtorGroup> debtorGroup;
    private Reference debtor;
    private Reference cashDrawer;
    private Price nettAdded = Price.ZERO_DOLLAR;
    private Price nettPaid = Price.ZERO_DOLLAR;
    private Price discounted = Price.ZERO_DOLLAR;
    private Price surcharged = Price.ZERO_DOLLAR;
    private Price refundedSales = Price.ZERO_DOLLAR;
    private Price refundedPayments = Price.ZERO_DOLLAR;
    private Price adjustments = Price.ZERO_DOLLAR;

    public DebtorGroupTakings() {
        this.debtorGroup = this.createReference(DebtorGroupTakings.Properties.DEBTOR_GROUP);
        this.debtor = this.createReference(DebtorGroupTakings.Properties.DEBTOR);
        this.cashDrawer = this.createReference(DebtorGroupTakings.Properties.CASHDRAWER);
    }

    public DebtorGroup getDebtorGroup() {
        return this.debtorGroup.get();
    }

    public AbstractDebtor getDebtor() {
        return (AbstractDebtor)this.debtor.get();
    }

    protected CashDrawer getCashDrawer() {
        return (CashDrawer)this.cashDrawer.get();
    }

    public Price getNettAdded() {
        return this.nettAdded;
    }

    public Price getGrossAdded() {
        return this.nettAdded.subtract(this.refundedSales);
    }

    public Price getNettPaid() {
        return this.nettPaid;
    }

    public Price getGrossPaid() {
        return this.nettPaid.subtract(this.refundedPayments).subtract(this.discounted).add(this.surcharged);
    }

    public Price getDiscounted() {
        return this.discounted;
    }

    public Price getSurcharged() {
        return this.surcharged;
    }

    public boolean hasPaid() {
        return !this.nettPaid.equals(Price.ZERO_DOLLAR);
    }

    public boolean hasAdded() {
        return !this.nettAdded.equals(Price.ZERO_DOLLAR);
    }

    public boolean hasDiscounted() {
        return !this.discounted.equals(Price.ZERO_DOLLAR);
    }

    public DebtorGroupTakings add(DebtorGroupTakings toAdd) {
        this.nettAdded = this.nettAdded.add(toAdd.nettAdded);
        this.nettPaid = this.nettPaid.add(toAdd.nettPaid);
        this.discounted = this.discounted.add(toAdd.discounted);
        this.surcharged = this.surcharged.add(toAdd.surcharged);
        this.refundedPayments = this.refundedPayments.add(toAdd.refundedPayments);
        this.refundedSales = this.refundedSales.add(toAdd.refundedSales);
        this.adjustments = this.adjustments.add(toAdd.adjustments);
        return this;
    }

    public static List<DebtorGroupTakings> getTakingsSummary(Shift financeShift, CashDrawer cashDrawer) {
        if (financeShift == null) {
            return new ArrayList<DebtorGroupTakings>();
        }
        HashMap<Long, DebtorGroupTakings> takingsSet = new HashMap<Long, DebtorGroupTakings>();
        List<DebtorGroupTakings> takingsList = PersistenceManager.getObjectList(DebtorGroupTakings.class, DebtorGroupTakings.getQuery(financeShift, cashDrawer).toString(), new Object[0]);
        if (takingsList != null) {
            for (DebtorGroupTakings currentTakings : takingsList) {
                if (takingsSet.containsKey(currentTakings.debtor.getObjectID())) {
                    takingsSet.put(currentTakings.debtor.getObjectID(), currentTakings.add((DebtorGroupTakings)takingsSet.get(currentTakings.debtor.getObjectID())));
                    continue;
                }
                takingsSet.put(currentTakings.debtor.getObjectID(), currentTakings);
            }
        }
        return new ArrayList<DebtorGroupTakings>(takingsSet.values());
    }

    public static List getTakingsSummary(Shift financeShift) {
        return DebtorGroupTakings.getTakingsSummary(financeShift, null);
    }

    public static DebtorGroupTakings getTotal(List debtorGroupTakings) {
        DebtorGroupTakings totalTakings = new DebtorGroupTakings();
        Iterator takingsIt = debtorGroupTakings.iterator();
        while (takingsIt.hasNext()) {
            totalTakings = totalTakings.add((DebtorGroupTakings)takingsIt.next());
        }
        return totalTakings;
    }

    private static ObjectQuery getQuery(Shift financeShift, CashDrawer cashDrawer) {
        return DebtorGroupTakingsQueries.getSummaryForShiftAndCashDrawer(financeShift, cashDrawer);
    }

    protected ObjectQuery getSummaryQuery() {
        return null;
    }

    public Price getRefundedSales() {
        return this.refundedSales;
    }

    public Price getRefundedPayments() {
        return this.refundedPayments;
    }

    public Price getAdjustments() {
        return this.adjustments;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property DEBTOR;
        public PropertiedObject.Property DEBTOR_GROUP;
        public PropertiedObject.Property CASHDRAWER;
        public PropertiedObject.Property NETT_ADDED;
        public PropertiedObject.Property NETT_PAID;
        public PropertiedObject.Property DISCOUNTED;
        public PropertiedObject.Property SURCHARGED;
        public PropertiedObject.Property REFUNDED_SALES;
        public PropertiedObject.Property REFUNDED_PAYMENTS;
        public PropertiedObject.Property ADJUSTMENTS;
    }
}

