/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.CustomPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.finance.reports.AccountTotalsReportHelper;
import ordermate.database.finance.reports.DebtorGroupTakings;
import ordermate.database.finance.reports.RestaurantTakingsSummaryQueryHelper;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.queries.sales.PhoneAccountQueries;
import ordermate.database.reports.StaffCostReportHelper;
import ordermate.database.reports.StaffCostReportSummary;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.database.reports.tax.TaxCodeReportSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;

public class RestaurantTakingsSummary
implements Serializable {
    private Shift shift;
    private static final String CUSTOM_SURCHARGE = "CUSTOM";
    private final Map<CashDrawer, Double> cashdrawerTakings;
    private Price totalTakings;
    private Price totalLoyalty;
    private Price cashTips;
    private Price cardTips;
    private Price webTips;
    private Price totalTips;
    private Price totalTabsDiscounted;
    private final Map<SalesLocation, LocationSales> locationSales;
    private final List<User> clockedOnUserList;
    private final Map<InventoryPriceAdjustment, PriceAdjustmentReport> discountReport;
    private final Map<InventoryPriceAdjustment, PriceAdjustmentReport> surchargeReport;
    private List<AccountTotalsReport> accountTypeTotals;
    private List<TaxCodeReportItem> taxPaidTotals;
    private List<TaxCodeReportItem> taxSalesTotals;
    private Price totalCostOfDeletedItems;
    private Price totalCostOfRefundedItems = new Price(0.0, 0.0);
    private Price totalCostOfRefundedItemsFromPrevShift = new Price(0.0, 0.0);
    private Price appliedPreviousTransactions = Price.ZERO_DOLLAR;
    private Price appliedPreviousTransactionsToday = Price.ZERO_DOLLAR;
    private Price totalVoucherTopups = Price.ZERO_DOLLAR;
    private Price totalVoucherRedeems = Price.ZERO_DOLLAR;
    private Price totalVoucherTopupReversals = Price.ZERO_DOLLAR;
    private Price totalVoucherRedeemReversals = Price.ZERO_DOLLAR;
    private double deliveryFees;
    private int numPatrons;
    private Price totalTax;
    private int totalNumberOfNoSales = 0;
    private DebtorGroupTakings debtorTakings;
    private StaffCostReportSummary previousHourSummary;
    private StaffCostReportSummary currentHourStaffCostSummary;
    private StaffCostReportSummary todayStaffCostSummary;
    boolean init = false;
    private boolean combosAsDiscounts;
    private CustomPriceAdjustment comboAdj;

    public RestaurantTakingsSummary(Shift newShift) {
        this.shift = newShift;
        this.cashdrawerTakings = new LinkedHashMap<CashDrawer, Double>();
        this.totalLoyalty = new Price(0.0, 0.01);
        this.totalTips = new Price(0.0, 0.01);
        this.discountReport = new LinkedHashMap<InventoryPriceAdjustment, PriceAdjustmentReport>();
        this.surchargeReport = new LinkedHashMap<InventoryPriceAdjustment, PriceAdjustmentReport>();
        this.locationSales = new LinkedHashMap<SalesLocation, LocationSales>();
        this.clockedOnUserList = new ArrayList<User>();
        this.totalCostOfDeletedItems = new Price(0.0, 0.01);
        this.combosAsDiscounts = SystemProperty.getInstance().isCombosAsDiscount();
        this.comboAdj = (CustomPriceAdjustment)PriceAdjustmentType.CUSTOM.createPriceAdjustment(0.0, PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.DISCOUNT);
        this.comboAdj.setLabel("Combos");
        this.comboAdj.setShouldDisplayAmount(false);
    }

    private void checkInit() {
        if (!this.init) {
            throw new IllegalStateException("Attempt to get calculated variable before calculate task has been called.");
        }
    }

    public Shift getShift() {
        if (this.shift == null) {
            throw new IllegalArgumentException("Shift has not been set for this takings summary");
        }
        return this.shift;
    }

    public void setShift(Shift newShift) {
        this.shift = newShift;
    }

    public Price getCashDrawerLevel(CashDrawer cashdrawer) {
        double takings = 0.0;
        Double o = this.cashdrawerTakings.get(cashdrawer);
        if (o != null) {
            takings = o;
            takings -= cashdrawer.getSkimTotalForShift(this.getShift()).doubleValue();
        }
        return new Price(takings, 0.01);
    }

    public Price getCashDrawerTakings(CashDrawer cashdrawer) {
        double takings = 0.0;
        Double o = this.cashdrawerTakings.get(cashdrawer);
        if (o != null) {
            takings = o;
        }
        return new Price(takings, 0.01);
    }

    public Price getCashDrawerSkims(CashDrawer cashDrawer) {
        if (cashDrawer == null) {
            return null;
        }
        return cashDrawer.getSkimTotalForShift(this.getShift());
    }

    public boolean getCashDrawerHasSkims(CashDrawer cashDrawer) {
        return this.getCashDrawerSkims(cashDrawer) != null && this.getCashDrawerSkims(cashDrawer).doubleValue() > 0.0;
    }

    public List<CashDrawer> getCashDrawers() {
        ArrayList<CashDrawer> cashdrawers = new ArrayList<CashDrawer>(this.cashdrawerTakings.keySet());
        Collections.sort(cashdrawers, new PropertyComparator((PropertiedObject.Property<? extends Comparable>)CashDrawer.Properties.LABEL));
        return cashdrawers;
    }

    public Price getCashDrawerTakingsTotal() {
        double total = 0.0;
        for (Double cdTakings : this.cashdrawerTakings.values()) {
            total += cdTakings.doubleValue();
        }
        return new Price(total, 0.01);
    }

    public Price getAccounts(AccountType type, boolean open, boolean incDiscounts) {
        this.checkInit();
        TotalsReport total = null;
        for (AccountTotalsReport currentTotal : this.accountTypeTotals) {
            if (!currentTotal.filter(type, open)) continue;
            if (total == null) {
                total = currentTotal;
                continue;
            }
            total = ((AccountTotalsReport)total).add(currentTotal);
        }
        if (total == null) {
            return Price.ZERO_DOLLAR;
        }
        if (incDiscounts) {
            return total.getTotal();
        }
        return ((AccountTotalsReport)total).getTotalExDiscounts();
    }

    public Price getAccounts(AccountType type, boolean open) {
        return this.getAccounts(type, open, true);
    }

    public Price getAccountsTotal(boolean open) {
        return this.getAccounts(null, open, true);
    }

    public Price getAccountsTotalExDiscounts(boolean open) {
        return this.getAccounts(null, open, false);
    }

    public Price getAccountsTotal() {
        Price open = this.getAccountsTotal(true);
        Price closed = this.getAccountsTotal(false);
        return open.add(closed);
    }

    public Price getAccountsTotalExDiscounts() {
        double open = this.getAccounts(null, true, false).doubleValue();
        double closed = this.getAccounts(null, false, false).doubleValue();
        return new Price(open + closed, 0.01);
    }

    public Price getTotalTax() {
        this.checkInit();
        if (this.totalTax == null) {
            this.totalTax = new Price(0.0, 0.0);
            for (TaxCodeReportItem reportItem : this.taxPaidTotals) {
                this.totalTax = this.totalTax.add(reportItem.getAmount());
            }
        }
        return this.totalTax;
    }

    public Price getAccountsTotalExTax() {
        return this.getAccountsTotal().subtract(this.getTotalTax());
    }

    public List<TaxCodeReportItem> getTaxPaidTotals() {
        return this.taxPaidTotals;
    }

    public List<TaxCodeReportItem> getTaxSalesTotals() {
        return this.taxSalesTotals;
    }

    public int getNumAccounts(AccountType type, boolean open) {
        this.checkInit();
        int count = 0;
        for (AccountTotalsReport report : this.accountTypeTotals) {
            if (!report.filter(type, open)) continue;
            count = (int)((long)count + report.getCount());
        }
        return count;
    }

    public int getNumAccountsTotal(boolean open) {
        return this.getNumAccounts(null, open);
    }

    public int getNumAccountsTotal() {
        return this.getNumAccountsTotal(true) + this.getNumAccountsTotal(false);
    }

    public Price getDeliveryFees() {
        this.checkInit();
        return new Price(this.deliveryFees);
    }

    public Price getCostOfDeletedItems() {
        this.checkInit();
        if (this.totalCostOfDeletedItems == null) {
            return new Price(0.0, 0.0);
        }
        return this.totalCostOfDeletedItems;
    }

    public Price getCostOfRefundedItems() {
        this.checkInit();
        if (this.totalCostOfRefundedItems == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.totalCostOfRefundedItems;
    }

    public Price getCostOfRefundsFromPreviousShifts() {
        this.checkInit();
        return this.totalCostOfRefundedItemsFromPrevShift != null ? this.totalCostOfRefundedItemsFromPrevShift : Price.ZERO_DOLLAR;
    }

    public int getTotalNumberOfNoSales() {
        this.checkInit();
        return this.totalNumberOfNoSales;
    }

    public Price getTotalUncategorizedDiscounts() {
        this.checkInit();
        return Price.ZERO_DOLLAR;
    }

    public Price getTotalUncategorizedSurcharges() {
        this.checkInit();
        return Price.ZERO_DOLLAR;
    }

    public int getNumPatrons() {
        this.checkInit();
        return this.numPatrons;
    }

    public int getNumOfAccountsWithSalesOnOtherShifts() {
        return 0;
    }

    public Price getDollarsPerHead() {
        this.checkInit();
        double sales = 0.0;
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            for (AccountTotalsReport report : this.accountTypeTotals) {
                sales += report.getTotal().doubleValue();
            }
        } else {
            for (AccountTotalsReport report : this.accountTypeTotals) {
                if (!TableAccount.TYPE.equals(report.getAccountType())) continue;
                sales += report.getTotal().doubleValue();
            }
        }
        double salesPerCust = this.getNumPatrons() != 0 ? sales / (double)this.getNumPatrons() : 0.0;
        return new Price(salesPerCust, 0.01);
    }

    public List getClockedOnUser() {
        this.clockedOnUserList.clear();
        List<User> userList = User.getUsers();
        for (User user : userList) {
            if (!user.isClockedOn()) continue;
            this.clockedOnUserList.add(user);
        }
        return this.clockedOnUserList;
    }

    public Price getLoyalty() {
        return this.totalLoyalty;
    }

    public boolean isLoyaltyZero() {
        return this.totalLoyalty.isZero();
    }

    public Price getCashTips() {
        return this.cashTips;
    }

    public Price getCardTips() {
        return this.cardTips;
    }

    public Price getWebTips() {
        return this.webTips;
    }

    public Price getTotalTips() {
        return this.totalTips;
    }

    public Price getTotalNettDebtorsAdded() {
        return this.getDebtorTakings().getNettAdded();
    }

    public Price getTotalDebtorsAdjustments() {
        return this.getDebtorTakings().getAdjustments();
    }

    public Price getTotalGrossDebtorsAdded() {
        return this.getDebtorTakings().getGrossAdded();
    }

    public Price getTotalRefundedDebtorSales() {
        return this.getDebtorTakings().getRefundedSales();
    }

    public boolean hasRefundedDebtorSales() {
        return !this.getDebtorTakings().getRefundedSales().isZero();
    }

    public Price getTotalNettDebtorsPaid() {
        return this.getDebtorTakings().getNettPaid();
    }

    public Price getTotalVoucherTopups() {
        return this.totalVoucherTopups;
    }

    public Price getTotalVoucherTopupReversals() {
        return this.totalVoucherTopupReversals.abs();
    }

    public Price getTotalVoucherRedeems() {
        return this.totalVoucherRedeems.abs();
    }

    public Price getTotalVoucherRedeemReversals() {
        return this.totalVoucherRedeemReversals;
    }

    public Price getTotalGrossDebtorsPaid() {
        return this.getDebtorTakings().getGrossPaid();
    }

    public Price getTotalRefundedDebtorPayments() {
        return this.getDebtorTakings().getRefundedPayments();
    }

    public boolean hasRefundedDebtorPayments() {
        return !this.getDebtorTakings().getRefundedPayments().equals(Price.ZERO_DOLLAR);
    }

    public boolean hasAdjustedDebtorPayments() {
        return !this.getDebtorTakings().getDiscounted().equals(Price.ZERO_DOLLAR) || !this.getDebtorTakings().getSurcharged().equals(Price.ZERO_DOLLAR);
    }

    public boolean hasPaid() {
        return this.getDebtorTakings().hasPaid();
    }

    public boolean hasDiscounted() {
        return this.getDebtorTakings().hasDiscounted();
    }

    public Price getDiscounted() {
        return this.getDebtorTakings().getDiscounted();
    }

    public Price getTotalDebtorsDiscounted() {
        return this.getDebtorTakings().getDiscounted();
    }

    public Price getTotalDebtorsSurcharged() {
        return this.getDebtorTakings().getSurcharged();
    }

    public void calculateDebtorTotals() {
        this.debtorTakings = DebtorGroupTakings.getTotal(DebtorGroupTakings.getTakingsSummary(this.getShift()));
    }

    public DebtorGroupTakings getDebtorTakings() {
        if (this.debtorTakings == null) {
            this.calculateDebtorTotals();
        }
        return this.debtorTakings;
    }

    public boolean hasDiscountedDebtors() {
        return this.totalTabsDiscounted != null && !this.totalTabsDiscounted.isZero();
    }

    public boolean hasDiscounts() {
        return !this.getAllDiscounts().isEmpty();
    }

    public Collection<InventoryPriceAdjustment> getAllDiscounts() {
        return this.getDiscountReport().keySet();
    }

    public Price getTotalDiscounts() {
        return RestaurantTakingsSummary.getTotalDiscounts(this.getDiscountReport());
    }

    public int getTotalDiscountsCount() {
        int totalCount = 0;
        for (PriceAdjustmentReport toAdd : this.getDiscountReport().values()) {
            totalCount += toAdd.count;
        }
        return totalCount;
    }

    public Price getMoneyLostToDiscount(InventoryPriceAdjustment invAdjustment) {
        return RestaurantTakingsSummary.getMoneyLostToDiscount(invAdjustment, this.getDiscountReport());
    }

    public int getDiscountCount(InventoryPriceAdjustment invAdjustment) {
        return RestaurantTakingsSummary.getDiscountCount(invAdjustment, this.getDiscountReport());
    }

    public boolean hasSurcharges() {
        return !this.getAllSurcharges().isEmpty();
    }

    public Collection<InventoryPriceAdjustment> getAllSurcharges() {
        ArrayList<InventoryPriceAdjustment> sortedSurcharges = new ArrayList<InventoryPriceAdjustment>(this.getSurchargeReport().keySet());
        Collections.sort(sortedSurcharges);
        return sortedSurcharges;
    }

    public Price getTotalSurcharges() {
        Price toReturn = Price.ZERO_DOLLAR;
        for (PriceAdjustmentReport toAdd : this.getSurchargeReport().values()) {
            toReturn = toReturn.add(new Price(toAdd.total, 0.01));
        }
        return toReturn;
    }

    public Price getMoneyGainedToSurchages(InventoryPriceAdjustment invAdjustment) {
        if (this.getSurchargeReport().containsKey(invAdjustment)) {
            PriceAdjustmentReport report = this.getSurchargeReport().get(invAdjustment);
            return new Price(report.total, 0.01);
        }
        return null;
    }

    public int getSurchargeCount(InventoryPriceAdjustment invAdjustment) {
        if (this.getSurchargeReport().containsKey(invAdjustment)) {
            PriceAdjustmentReport report = this.getSurchargeReport().get(invAdjustment);
            return report.count;
        }
        return 0;
    }

    public List<LocationSales> getLocationSales() {
        return new ArrayList<LocationSales>(this.locationSales.values());
    }

    public void setCashdrawerTakings(CashDrawer drawer, double takings) {
        this.cashdrawerTakings.put(drawer, new Double(takings));
    }

    public void setLoyalty(Price newLoyalty) {
        this.totalLoyalty = newLoyalty;
    }

    public void setCashTips(double tips) {
        this.cashTips = new Price(tips, Price.DEFAULT_ROUND_AMOUNT);
    }

    public void setCardTips(double tips) {
        this.cardTips = new Price(tips, 0.01);
    }

    public void setWebTips(double tips) {
        this.webTips = new Price(tips, 0.01);
    }

    public void setTotalTips(double tips) {
        this.totalTips = new Price(tips, 0.01);
    }

    public void setTotalVoucherTopups(Price voucherTopups) {
        this.totalVoucherTopups = voucherTopups;
    }

    public void setTotalVoucherTopupReversals(Price voucherTopupReversals) {
        this.totalVoucherTopupReversals = voucherTopupReversals;
    }

    public void setTotalVoucherRedeems(Price voucherRedeems) {
        this.totalVoucherRedeems = voucherRedeems;
    }

    public void setTotalVoucherRedeemReversals(Price voucherRedeemReversals) {
        this.totalVoucherRedeemReversals = voucherRedeemReversals;
    }

    public void setTotalTabsDiscounted(double newTabsDiscounted) {
        this.totalTabsDiscounted = new Price(newTabsDiscounted, 0.0);
    }

    public void addLocationSales(SalesLocation location, LocationSales toAdd) {
        this.locationSales.put(location, toAdd);
    }

    public Task getCalculateTask() {
        return new CalculateRestaurantTakingsSummaryTask();
    }

    public void addSurchargeToReport(InventoryPriceAdjustment invAdj) {
        this.surchargeReport.put(invAdj, new PriceAdjustmentReport());
    }

    public void groupAllCustomSurcharges() {
        int customSurchargeCount = 0;
        Price totalCustomSurchargeAmount = Price.ZERO_DOLLAR;
        for (InventoryPriceAdjustment invAdj : this.getAllSurcharges()) {
            if (!PriceAdjustmentType.CUSTOM.equals(invAdj.getType())) continue;
            Price money = this.getMoneyGainedToSurchages(invAdj);
            totalCustomSurchargeAmount = totalCustomSurchargeAmount.add(money);
            ++customSurchargeCount;
            this.surchargeReport.remove(invAdj);
        }
        if (customSurchargeCount > 0) {
            InventoryPriceAdjustment customAdj = PriceAdjustmentType.CUSTOM.createPriceAdjustment(totalCustomSurchargeAmount.doubleValue(), PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.SURCHARGE);
            customAdj.setLabel(CUSTOM_SURCHARGE);
            PriceAdjustmentReport report = new PriceAdjustmentReport();
            this.surchargeReport.put(customAdj, report);
            report.add(totalCustomSurchargeAmount.doubleValue());
        }
    }

    public static List<String> doPriceLevelReport(Shift shift, Terminal terminal) {
        ReportProperty property = ReportProperty.find(ReportGroup.WMTakings, "PriceLevel Count");
        if (property != null) {
            String breakoutLabel = property.getStringValue(null);
            if (StringUtils.isEmpty(breakoutLabel)) {
                return null;
            }
            PriceLevel level = PriceLevel.findPriceLevel(breakoutLabel);
            if (level == null) {
                OrderMate.LOG.info("Cannot find price level " + breakoutLabel);
                return null;
            }
            ObjectQuery query = Query.sum(SalesItemQuantity.Properties.QUANTITY, "value").sumMultiplication(SalesComponent.Properties.ITEM_DISCOUNT_TOTAL, SalesItemQuantity.Properties.QUANTITY, "discount").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).equals(SalesComponent.Properties.PRICE_LEVEL, level).equals(SalesItemQuantity.Properties.SHIFT, shift).equals(SalesItemQuantity.Properties.TERMINAL, terminal);
            Object[][] data = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
            ArrayList<String> toReturn = new ArrayList<String>();
            toReturn.add(breakoutLabel);
            if (data != null && data.length > 0 && data[0] != null && data[0].length > 0 && data[0][0] != null) {
                toReturn.add(DecimalFormat.getIntegerInstance().format(data[0][0]));
                toReturn.add(DecimalFormat.getCurrencyInstance().format(data[0][1]));
            } else {
                toReturn.add("0");
                toReturn.add("$0.00");
            }
            return toReturn;
        }
        return null;
    }

    private Map<InventoryPriceAdjustment, PriceAdjustmentReport> getDiscountReport() {
        this.checkInit();
        return this.discountReport;
    }

    private Map<InventoryPriceAdjustment, PriceAdjustmentReport> getSurchargeReport() {
        this.checkInit();
        return this.surchargeReport;
    }

    public StaffCostReportSummary getStaffCostToday() {
        return this.todayStaffCostSummary;
    }

    public StaffCostReportSummary getStaffCostPreviousHour() {
        return this.previousHourSummary;
    }

    public StaffCostReportSummary getStaffCostCurrentHour() {
        return this.currentHourStaffCostSummary;
    }

    public static RestaurantTakingsSummary getSummary(Shift shift) {
        try {
            RestaurantTakingsSummary summary = Data.database.getRestaurantTakingsSummary(shift);
            return summary;
        }
        catch (RemoteException e) {
            OrderMateLog.LOG.error("Unable to get RestaurantTakingsSummary from DB", (Throwable)e);
            return null;
        }
    }

    private static int getDiscountCount(InventoryPriceAdjustment invAdjustment, Map<InventoryPriceAdjustment, PriceAdjustmentReport> discountReport) {
        if (discountReport.containsKey(invAdjustment)) {
            PriceAdjustmentReport report = discountReport.get(invAdjustment);
            return report.count;
        }
        return 0;
    }

    private static Price getTotalDiscounts(Map<InventoryPriceAdjustment, PriceAdjustmentReport> discountReport) {
        Price toReturn = Price.ZERO_DOLLAR;
        for (PriceAdjustmentReport priceReport : discountReport.values()) {
            toReturn = toReturn.add(new Price(priceReport.total, 0.01));
        }
        return toReturn;
    }

    private static Price getMoneyLostToDiscount(InventoryPriceAdjustment invAdjustment, Map<InventoryPriceAdjustment, PriceAdjustmentReport> discountReport) {
        if (discountReport.containsKey(invAdjustment)) {
            PriceAdjustmentReport report = discountReport.get(invAdjustment);
            return new Price(report.total, 0.01);
        }
        return null;
    }

    public int getNumPatronsForAccount(AccountType type, boolean open) {
        this.checkInit();
        int patronsCount = 0;
        for (AccountTotalsReport report : this.accountTypeTotals) {
            if (!report.filter(type, open)) continue;
            patronsCount += report.getTotalPatrons();
        }
        return patronsCount;
    }

    public Price getDollarsPerHeadForAccount(AccountType type, boolean open) {
        this.checkInit();
        Price toReturn = Price.ZERO_DOLLAR;
        for (AccountTotalsReport report : this.accountTypeTotals) {
            if (!report.filter(type, open)) continue;
            toReturn = toReturn.add(report.getDollarsPerHead());
        }
        return toReturn;
    }

    public Price getPreviousShiftSaleForAccountsInShift() {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getPreviousSalesForAccountsQry(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT), new Object[]{this.shift.getID(), this.shift.getID()});
        return new Price((Double)result[0][0], 0.01);
    }

    public Price getFutureShiftSalesForAccountsInShift() {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getFutureSalesForAccountsQry(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT), new Object[]{this.shift.getID(), this.shift.getID()});
        return new Price((Double)result[0][0], 0.01);
    }

    public Price getPaidPreviousItems() {
        return RestaurantTakingsSummaryQueryHelper.getPaidPreviousItems(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT, this.getShift().getID());
    }

    public void setTotalTakings(double total) {
        this.totalTakings = new Price(total, 0.01);
    }

    public Price getTotalTakings() {
        return this.totalTakings;
    }

    public Price getAppliedPreviousTransactions() {
        return this.appliedPreviousTransactions;
    }

    public void setAppliedPreviousTransactions(Price appliedPreviousTransactions) {
        this.appliedPreviousTransactions = appliedPreviousTransactions;
    }

    public Price getAppliedPreviousTransactionsToday() {
        return this.appliedPreviousTransactionsToday;
    }

    public void setAppliedPreviousTransactionsToday(Price appliedPreviousTransactionsToday) {
        this.appliedPreviousTransactionsToday = appliedPreviousTransactionsToday;
    }

    public static class LocationSales
    implements Serializable {
        private final Map<String, Price> categorySales = new LinkedHashMap<String, Price>();
        private final Map<String, Price> categorySalesExDiscount = new LinkedHashMap<String, Price>();
        private final Map<String, Integer> categoryQty = new LinkedHashMap<String, Integer>();
        private final SalesLocation location;
        private final Map<InventoryPriceAdjustment, PriceAdjustmentReport> discountReport;

        public LocationSales(SalesLocation newLocation) {
            this.location = newLocation;
            this.discountReport = new LinkedHashMap<InventoryPriceAdjustment, PriceAdjustmentReport>();
        }

        public void addSales(String category, Price price, int numItems) {
            if (this.categorySales.containsKey(category)) {
                this.categorySales.put(category, this.categorySales.get(category).add(price));
                this.categoryQty.put(category, this.categoryQty.get(category) + numItems);
            } else {
                this.categorySales.put(category, price);
                this.categoryQty.put(category, numItems);
            }
        }

        public void addSalesExDiscounts(String category, Price price, int numItems) {
            if (this.categorySalesExDiscount.containsKey(category)) {
                this.categorySalesExDiscount.put(category, this.categorySalesExDiscount.get(category).add(price));
            } else {
                this.categorySalesExDiscount.put(category, price);
            }
        }

        public String getLocationName() {
            return this.location.getLabel();
        }

        public Collection<String> getCategories() {
            return this.categorySales.keySet();
        }

        public Price getSalesForCategory(String category) {
            if (this.categorySales.containsKey(category)) {
                return this.categorySales.get(category);
            }
            return Price.ZERO_DOLLAR;
        }

        public Price getSalesForCategoryExDiscounts(String category) {
            if (this.categorySalesExDiscount.containsKey(category)) {
                return this.categorySalesExDiscount.get(category);
            }
            return Price.ZERO_DOLLAR;
        }

        public int getNumItemsForCategory(String category) {
            if (this.categoryQty.containsKey(category)) {
                return this.categoryQty.get(category);
            }
            return 0;
        }

        public Price getTotalSales() {
            Price toReturn = Price.ZERO_DOLLAR;
            for (Price toAdd : this.categorySales.values()) {
                toReturn = toReturn.add(toAdd);
            }
            return toReturn;
        }

        public Price getTotalSalesExDiscounts() {
            Price toReturn = Price.ZERO_DOLLAR;
            for (Price toAdd : this.categorySalesExDiscount.values()) {
                toReturn = toReturn.add(toAdd);
            }
            return toReturn;
        }

        private void addDiscount(InventoryPriceAdjustment invAdj, Price moneyLost) {
            PriceAdjustmentReport report;
            if (this.discountReport.containsKey(invAdj)) {
                report = this.discountReport.get(invAdj);
            } else {
                report = new PriceAdjustmentReport();
                this.discountReport.put(invAdj, report);
            }
            report.add(moneyLost.doubleValue());
            if (MathsUtils.approxEquals(0.0, report.total)) {
                this.discountReport.remove(invAdj);
            }
        }

        public Collection<InventoryPriceAdjustment> getAllDiscounts() {
            return this.discountReport.keySet();
        }

        public Price getMoneyLostToDiscount(InventoryPriceAdjustment invAdjustment) {
            return RestaurantTakingsSummary.getMoneyLostToDiscount(invAdjustment, this.discountReport);
        }

        public int getDiscountCount(InventoryPriceAdjustment invAdjustment) {
            return RestaurantTakingsSummary.getDiscountCount(invAdjustment, this.discountReport);
        }

        public Price getTotalDiscounts() {
            return RestaurantTakingsSummary.getTotalDiscounts(this.discountReport);
        }

        public SalesLocation getLocation() {
            return this.location;
        }

        public void putLastOrClear(String catName) {
            if (this.categorySales.containsKey(catName)) {
                if (this.categorySalesExDiscount.get(catName) == null) {
                    this.categorySales.remove(catName);
                    this.categorySalesExDiscount.remove(catName);
                    this.categoryQty.remove(catName);
                } else {
                    this.categorySales.put(catName, this.categorySales.get(catName));
                    this.categorySalesExDiscount.put(catName, this.categorySalesExDiscount.get(catName));
                    this.categoryQty.put(catName, this.categoryQty.get(catName));
                }
            }
        }
    }

    private static class PriceAdjustmentReport
    implements Serializable {
        private double total;
        private int count;

        private PriceAdjustmentReport() {
        }

        public void add(double toAdd) {
            this.total += toAdd;
            this.count = toAdd > 0.0 ? ++this.count : --this.count;
        }
    }

    private class CalculateRestaurantTakingsSummaryTask
    extends AbstractTask {
        private static final int NUM_PROGRESS_SIGNALS_EMITTED_OUTSIDE_LOOP = 10;

        private CalculateRestaurantTakingsSummaryTask() {
        }

        @Override
        public Icon getIcon() {
            return IconLoader.get("/waitermate/images/pay.png");
        }

        @Override
        public int getTotalSubTasks() {
            return 11;
        }

        @Override
        public String getName() {
            return "Calculating takings for " + RestaurantTakingsSummary.this.getShift().getLabel();
        }

        @Override
        protected void performTask() throws Exception {
            this.emitProgress("Started");
            RestaurantTakingsSummary.this.accountTypeTotals = AccountTotalsReportHelper.getAccountTotalsReport(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got account totals");
            RestaurantTakingsSummary.this.deliveryFees = PhoneAccountQueries.DeliveryFees.getTotalDeliveryFees(RestaurantTakingsSummary.this.getShift()).doubleValue();
            this.emitProgress("Got delivery fees");
            RestaurantTakingsSummary.this.numPatrons = AccountQueries.getTotalNumberOfPatrons(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got number of patrons");
            RestaurantTakingsSummary.this.totalCostOfDeletedItems = AccountQueries.getCostOfDeletedItems(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got cost of deleted items");
            RestaurantTakingsSummary.this.totalCostOfRefundedItems = AccountQueries.getCostOfRefundedItems(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got cost of refunded items");
            RestaurantTakingsSummary.this.totalCostOfRefundedItemsFromPrevShift = AccountQueries.getCostOfRefundedItemsFromOtherShifts(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got cost of refunds from previous shifts");
            TaxCodeReportSearcher taxSearcher = new TaxCodeReportSearcher();
            taxSearcher.setSearchType(TaxCodeReportSearcher.TaxSearchType.TaxPayable);
            taxSearcher.getShiftFilter().setSearchValue(RestaurantTakingsSummary.this.getShift());
            RestaurantTakingsSummary.this.taxPaidTotals = taxSearcher.search();
            taxSearcher.setSearchType(TaxCodeReportSearcher.TaxSearchType.TotalTaxSales);
            RestaurantTakingsSummary.this.taxSalesTotals = taxSearcher.search();
            this.emitProgress("Got tax report");
            RestaurantTakingsSummary.this.totalNumberOfNoSales = AccountQueries.getTotalNumberOfNoSales(RestaurantTakingsSummary.this.getShift());
            this.emitProgress("Got num no sales");
            this.doAdjustments();
            this.emitProgress("Discounts");
            Calendar previousHour = Calendar.getInstance();
            if (!RestaurantTakingsSummary.this.getShift().getTradingDay().isOpen()) {
                Calendar closeTradingDay = Calendar.getInstance();
                closeTradingDay.setTime(RestaurantTakingsSummary.this.getShift().getTradingDay().getCloseDateTime());
                if (previousHour.after(closeTradingDay)) {
                    previousHour = closeTradingDay;
                }
            }
            Date currentHourEndTime = previousHour.getTime();
            previousHour.set(12, 0);
            previousHour.set(13, 0);
            previousHour.set(14, 0);
            Date previousHourEndTime = previousHour.getTime();
            previousHour.add(10, -1);
            Date previousHourStartTime = previousHour.getTime();
            StaffCostReportHelper staffCostReportHelper = new StaffCostReportHelper();
            RestaurantTakingsSummary.this.previousHourSummary = staffCostReportHelper.getStaffCostReportSummary(previousHourStartTime, previousHourEndTime);
            RestaurantTakingsSummary.this.currentHourStaffCostSummary = staffCostReportHelper.getStaffCostReportSummary(previousHourEndTime, currentHourEndTime);
            RestaurantTakingsSummary.this.todayStaffCostSummary = staffCostReportHelper.getStaffCostReportSummary(RestaurantTakingsSummary.this.getShift().getTradingDay().getOpenDateTime(), currentHourEndTime);
            ArrayList invAdjs = new ArrayList(RestaurantTakingsSummary.this.discountReport.keySet());
            for (InventoryPriceAdjustment invAdj : invAdjs) {
                if (!MathsUtils.approxEquals(0.0, ((PriceAdjustmentReport)RestaurantTakingsSummary.this.discountReport.get(invAdj)).total)) continue;
                RestaurantTakingsSummary.this.discountReport.remove(invAdj);
            }
            RestaurantTakingsSummary.this.init = true;
            this.emitProgress("Finished");
        }

        private void emitProgress(String progressInfo) {
            super.emitProgress();
            OrderMate.LOG.info("Takings progress : " + progressInfo);
        }

        private void doAdjustments() {
            ObjectQuery query = Query.select(SalesPriceAdjustment.class).equals(SalesPriceAdjustment.Properties.SHIFT, RestaurantTakingsSummary.this.shift).orderBy(SalesPriceAdjustment.Properties.UNIT).orderBy(SalesPriceAdjustment.Properties.LABEL);
            List<SalesPriceAdjustment> priceAdjustments = PersistenceManager.getObjectList(SalesPriceAdjustment.class, query.toString());
            for (SalesPriceAdjustment adj : priceAdjustments) {
                if (Price.ZERO_DOLLAR.equals(adj.getSavedValue())) continue;
                if (PriceAdjustmentDirection.DISCOUNT.equals(adj.getDirection())) {
                    this.addDiscount(adj.getInventoryPriceAdjustment(), adj.getSavedValue(), adj.getCreationContext().getTerminal() != null ? adj.getCreationContext().getTerminal().getSalesLocation() : null);
                    continue;
                }
                if (!PriceAdjustmentDirection.SURCHARGE.equals(adj.getDirection())) continue;
                this.addSurcharge(adj, adj.getSavedValue());
            }
            if (RestaurantTakingsSummary.this.combosAsDiscounts) {
                this.performCombosAsDiscounts();
            }
        }

        private void performCombosAsDiscounts() {
            Object[][] result;
            ObjectQuery query = Query.select(SalesLineItem.class).linkUsing(SalesLineItem.Properties.ACCOUNT).equals(Account.Properties.SHIFT, RestaurantTakingsSummary.this.shift).whereFunction("sales_item.type NOT IN ('SalesItem','SimpleCombo')").isNull(SalesCombo.Properties.COMBO_DISCOUNT);
            List<SalesLineItem> combos = PersistenceManager.getObjectList(SalesLineItem.class, query.toString());
            for (SalesLineItem combo : combos) {
                ((SalesCombo)combo).getComboDiscount();
                PersistenceManager.saveChild(combo);
            }
            query = Query.sumMultiplication(SalesCombo.Properties.COMBO_DISCOUNT, SalesItemQuantity.Properties.QUANTITY, "total").select(SalesItemQuantity.Properties.SALES_LOCATION, "location").selectFunc("sales_item.type as type").select(SalesCombo.Properties.COMBO, "inv_combo").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesLineItem.Properties.ACCOUNT).equals(Account.Properties.SHIFT, RestaurantTakingsSummary.this.shift).whereFunction("sales_item.type NOT IN ('SalesItem','SimpleCombo')").groupBy(SalesCombo.Properties.ID);
            for (Object[] nextSet : result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0])) {
                if (nextSet[0] == null) continue;
                Price discount = new Price(((Number)nextSet[0]).doubleValue(), 0.01);
                SalesLocation location = PersistenceManager.getByID(((Number)nextSet[1]).longValue(), SalesLocation.class);
                if (Price.ZERO_DOLLAR.equals(discount)) continue;
                if ("SalesAdjustmentCombo".equals(nextSet[2])) {
                    InventoryAdjustmentCombo adjCombo = PersistenceManager.getByID(((Number)nextSet[3]).longValue(), InventoryAdjustmentCombo.class);
                    this.subtractDiscount(adjCombo.getPriceAdjustment(), location, discount);
                }
                this.addDiscount(RestaurantTakingsSummary.this.comboAdj, discount, location);
            }
        }

        private void subtractDiscount(InventoryPriceAdjustment invAdj, SalesLocation location, Price moneyReturned) {
            LocationSales locationSale;
            PriceAdjustmentReport report;
            if (RestaurantTakingsSummary.this.discountReport.containsKey(invAdj)) {
                report = (PriceAdjustmentReport)RestaurantTakingsSummary.this.discountReport.get(invAdj);
            } else {
                report = new PriceAdjustmentReport();
                RestaurantTakingsSummary.this.discountReport.put(invAdj, report);
            }
            report.add(moneyReturned.negate().doubleValue());
            if (location != null && (locationSale = (LocationSales)RestaurantTakingsSummary.this.locationSales.get(location)) != null) {
                locationSale.addDiscount(invAdj, moneyReturned.negate());
            }
        }

        private void addDiscount(InventoryPriceAdjustment invAdj, Price moneyLost, SalesLocation location) {
            LocationSales locationSale;
            PriceAdjustmentReport report;
            if (RestaurantTakingsSummary.this.discountReport.containsKey(invAdj)) {
                report = (PriceAdjustmentReport)RestaurantTakingsSummary.this.discountReport.get(invAdj);
            } else {
                report = new PriceAdjustmentReport();
                RestaurantTakingsSummary.this.discountReport.put(invAdj, report);
            }
            report.add(moneyLost.doubleValue());
            SalesLocation termLocation = location;
            if (termLocation != null && (locationSale = (LocationSales)RestaurantTakingsSummary.this.locationSales.get(termLocation)) != null) {
                locationSale.addDiscount(invAdj, moneyLost);
            }
        }

        private void addSurcharge(SalesPriceAdjustmentI surcharge, Price moneyGained) {
            PriceAdjustmentReport report;
            InventoryPriceAdjustment invAdj = surcharge.getInventoryPriceAdjustment();
            if (RestaurantTakingsSummary.this.surchargeReport.containsKey(invAdj)) {
                report = (PriceAdjustmentReport)RestaurantTakingsSummary.this.surchargeReport.get(invAdj);
            } else {
                report = new PriceAdjustmentReport();
                RestaurantTakingsSummary.this.surchargeReport.put(invAdj, report);
            }
            report.add(moneyGained.doubleValue() * -1.0);
        }
    }

    public static class RemoteTask
    extends Executable<RestaurantTakingsSummary> {
        private final RestaurantTakingsSummary summary;

        public RemoteTask(RestaurantTakingsSummary sum) {
            this.summary = sum;
        }

        @Override
        public RestaurantTakingsSummary execute() {
            this.summary.getCalculateTask().run();
            return this.summary;
        }
    }
}

