/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.Account;

public class RestaurantTakingsSummaryQueryHelper {
    private static final String FILTER_BY_PATTERN = "%FILTER_BY%";
    private static final String ACC_PREVIOUS_FINANCE_TRANSACTION_QRY = "SELECT sales_account.* FROM finance_transaction_item LEFT JOIN finance_transaction ON finance_transaction.ID  = finance_transaction_item.fk_finance_transaction LEFT JOIN sales_account ON sales_account.ID = finance_transaction.FK_payoff_account LEFT JOIN finance_unit ON finance_transaction.FK_finance_unit = finance_unit.ID LEFT JOIN sales_item ON sales_item.ID = finance_transaction_item.fk_sales_item LEFT JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID WHERE finance_transaction.%FILTER_BY% = ? AND finance_transaction.system_state = 'ACTIVE' AND finance_unit.unit_type != 'ACCOUNT' AND finance_unit.unit_type != 'LOYALTY' AND sales_item_quantity.%FILTER_BY% < ? GROUP BY finance_transaction.FK_payoff_account";
    private static final String ACC_FUTURE_FINANCE_TRANSACTION_QRY = "SELECT sales_account.* FROM finance_transaction_item LEFT JOIN finance_transaction ON finance_transaction.ID  = finance_transaction_item.fk_finance_transaction LEFT JOIN sales_account ON sales_account.ID = finance_transaction.FK_payoff_account LEFT JOIN finance_unit ON finance_transaction.FK_finance_unit = finance_unit.ID LEFT JOIN sales_item ON sales_item.ID = finance_transaction_item.fk_sales_item LEFT JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID WHERE finance_transaction.%FILTER_BY% > ? AND finance_transaction.system_state = 'ACTIVE' AND finance_unit.unit_type != 'ACCOUNT' AND finance_unit.unit_type != 'LOYALTY' AND sales_item_quantity.%FILTER_BY% = ? GROUP BY finance_transaction.FK_payoff_account";
    private static final String CHECK_FINANCE_SHIFT_ANORMALIES_ACCOUNT = "SELECT sales_account.* FROM sales_account  inner join finance_shift on sales_account.fk_finance_trading_day=finance_shift.fk_finance_trading_day where sales_account.fk_finance_shift<> finance_shift.id and sales_account.%FILTER_BY%  = ?;";
    private static final String FUTURE_SALES_FOR_ACCOUNTS = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.%FILTER_BY% = ? AND \t\tsales_item_quantity.%FILTER_BY% > ?;";
    private static final String PREVIOUS_SALES_FOR_ACCOUNTS = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.%FILTER_BY% < ? AND \t\tsales_item_quantity.%FILTER_BY% = ?;";
    private static final String ACCOUNTS_PREVIOUS_SALES = "SELECT distinct sales_account.*  FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.%FILTER_BY% < ? AND \t\tsales_item_quantity.%FILTER_BY% = ?;";
    private static final String GET_TODAYS_SALES_FOR_ACCOUNT = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.ID = ? AND \t\tsales_item_quantity.%FILTER_BY% = ?;";
    private static final String GET_TODAYS_TAKINGS_FOR_ACCOUNT = "SELECT COALESCE(SUM(finance_transaction.amount_paid), 0) AS total_paid FROM finance_transaction INNER JOIN sales_account ON sales_account.ID = finance_transaction.fk_payoff_account \tWHERE \t\tfinance_transaction.fk_payoff_account = ? AND \t\tfinance_transaction.system_state = 'ACTIVE' AND \t\tfinance_transaction.%FILTER_BY% = ?";
    private static final String GET_PREVIOUS_SALES_FOR_ACCOUNT = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.ID = ? AND \t\tsales_item_quantity.%FILTER_BY% < ?;";
    private static final String GET_PREVIOUS_TAKINGS_FOR_ACCOUNT = "SELECT COALESCE(SUM(finance_transaction.amount_paid), 0) AS total_paid FROM finance_transaction INNER JOIN sales_account ON sales_account.ID = finance_transaction.fk_payoff_account \tWHERE \t\tfinance_transaction.fk_payoff_account = ? AND \t\tfinance_transaction.system_state = 'ACTIVE' AND \t\tfinance_transaction.%FILTER_BY% < ?";
    private static final String GET_FUTURE_SALES_FOR_ACCOUNT = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID INNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE \t\tsales_account.ID = ? AND \t\tsales_item_quantity.%FILTER_BY% > ?;";
    private static final String GET_FUTURE_TAKINGS_FOR_ACCOUNT = "SELECT COALESCE(SUM(finance_transaction.amount_paid), 0) AS total_paid FROM finance_transaction INNER JOIN sales_account ON sales_account.ID = finance_transaction.fk_payoff_account \tWHERE  \t\tfinance_transaction.fk_payoff_account = ? AND \t\tfinance_transaction.system_state = 'ACTIVE' AND \t\tfinance_transaction.%FILTER_BY% > ?";
    private static final String TOTAL_SALES_BY_ITEM_QTY = "SELECT COALESCE(SUM(sales_component.unit_price * sales_item_quantity.quantity), 0) AS total_sales FROM sales_account \t\tINNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID  \t\tINNER JOIN sales_item_quantity ON sales_item_quantity.fk_sales_item = sales_item.ID \t\tINNER JOIN sales_component ON sales_component.fk_sales_item = sales_item.ID \tWHERE  \t\tsales_item_quantity.%FILTER_BY% = ?;";
    private static final String TOTAL_SALES_BY_ACCOUNT = "SELECT COALESCE(SUM(saved_total), 0) AS total_sales FROM sales_account \tWHERE  \t\tsales_account.%FILTER_BY% = ?;";

    public static String getAccountsWithFinanceTransactionsForPreviousItemsQry(PeriodFilterBy filter) {
        return ACC_PREVIOUS_FINANCE_TRANSACTION_QRY.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountsWithFinanceTransactionsForFutureItemsQry(PeriodFilterBy filter) {
        return ACC_FUTURE_FINANCE_TRANSACTION_QRY.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountsWithIncorrectFinanceShift(PeriodFilterBy filter) {
        return CHECK_FINANCE_SHIFT_ANORMALIES_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getPreviousSalesForAccountsQry(PeriodFilterBy filter) {
        return PREVIOUS_SALES_FOR_ACCOUNTS.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountsPreviousSales(PeriodFilterBy filter) {
        return ACCOUNTS_PREVIOUS_SALES.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getFutureSalesForAccountsQry(PeriodFilterBy filter) {
        return FUTURE_SALES_FOR_ACCOUNTS.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountSalesForTodayQry(PeriodFilterBy filter) {
        return GET_TODAYS_SALES_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountTakingsForTodayQry(PeriodFilterBy filter) {
        return GET_TODAYS_TAKINGS_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountSalesForPreviousQry(PeriodFilterBy filter) {
        return GET_PREVIOUS_SALES_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountTakingsForPreviousQry(PeriodFilterBy filter) {
        return GET_PREVIOUS_TAKINGS_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountSalesForFutureQry(PeriodFilterBy filter) {
        return GET_FUTURE_SALES_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getAccountTakingsForFutureQry(PeriodFilterBy filter) {
        return GET_FUTURE_TAKINGS_FOR_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getTotalSalesByItemQtyQry(PeriodFilterBy filter) {
        return TOTAL_SALES_BY_ITEM_QTY.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static String getTotalSalesByAccountQry(PeriodFilterBy filter) {
        return TOTAL_SALES_BY_ACCOUNT.replace(FILTER_BY_PATTERN, filter.getQueryConditionField());
    }

    public static Price getOpenSalesThatNotBeenPaidToday(PeriodFilterBy filterBy, Long id) {
        Price total = Price.ZERO_DOLLAR;
        try {
            List<Account> allAccountsWithFuturePayments = PersistenceManager.getObjectList(Account.class, RestaurantTakingsSummaryQueryHelper.getAccountsWithFinanceTransactionsForFutureItemsQry(filterBy), new Object[]{id, id});
            for (Account account : allAccountsWithFuturePayments) {
                Object[][] todaysSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForTodayQry(filterBy), new Object[]{account.getID(), id});
                Price salesToday = new Price((Double)todaysSalesResults[0][0], 0.01);
                Object[][] todaysTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForTodayQry(filterBy), new Object[]{account.getID(), id});
                Price paidToday = new Price((Double)todaysTakingsResults[0][0], 0.01);
                Price todaysDiff = salesToday.subtract(paidToday);
                if (!todaysDiff.greaterThan(Price.ZERO_DOLLAR)) continue;
                total = total.add(todaysDiff);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured while calculating open sales that have since been paid.", (Throwable)ex);
            return Price.ZERO_DOLLAR;
        }
        return total;
    }

    public static Price getOpenSalesThatHaveSinceBeenPaid(PeriodFilterBy filterBy, Long id) {
        Price total = Price.ZERO_DOLLAR;
        try {
            List<Account> allAccountsWithFuturePayments = PersistenceManager.getObjectList(Account.class, RestaurantTakingsSummaryQueryHelper.getAccountsWithFinanceTransactionsForFutureItemsQry(filterBy), new Object[]{id, id});
            for (Account account : allAccountsWithFuturePayments) {
                Object[][] todaysSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForTodayQry(filterBy), new Object[]{account.getID(), id});
                Object[][] todaysTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForTodayQry(filterBy), new Object[]{account.getID(), id});
                Object[][] futureSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForFutureQry(filterBy), new Object[]{account.getID(), id});
                Object[][] futureTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForFutureQry(filterBy), new Object[]{account.getID(), id});
                Price salesToday = new Price((Double)todaysSalesResults[0][0], 0.01);
                Price paidToday = new Price((Double)todaysTakingsResults[0][0], 0.01);
                Price salesFuture = new Price((Double)futureSalesResults[0][0], 0.01);
                Price paidFuture = new Price((Double)futureTakingsResults[0][0], 0.01);
                Price result = paidFuture.multiply(salesToday.subtract(paidToday)).divide(salesFuture.add(salesToday.subtract(paidToday)));
                total = total.add(result);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured while calculating open sales that have since been paid.", (Throwable)ex);
            return Price.ZERO_DOLLAR;
        }
        return total;
    }

    public static Price getPaidPreviousForExcessAmountFromToday(PeriodFilterBy filterBy, Long id) {
        Price totalPreviousPaid = Price.ZERO_DOLLAR;
        try {
            List<Account> allTransPayingPreviousItems = PersistenceManager.getObjectList(Account.class, RestaurantTakingsSummaryQueryHelper.getAccountsWithFinanceTransactionsForPreviousItemsQry(filterBy), new Object[]{id, id});
            for (Account account : allTransPayingPreviousItems) {
                Price salesToday;
                Object[][] todaysSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForTodayQry(filterBy), new Object[]{account.getID(), id});
                Object[][] todaysTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForTodayQry(filterBy), new Object[]{account.getID(), id});
                Price paidToday = new Price((Double)todaysTakingsResults[0][0], 0.01);
                Price todaysDiff = paidToday.subtract(salesToday = new Price((Double)todaysSalesResults[0][0], 0.01));
                if (!todaysDiff.greaterThan(Price.ZERO_DOLLAR)) continue;
                totalPreviousPaid = totalPreviousPaid.add(todaysDiff);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured while calculating previous paid items.", (Throwable)ex);
            return Price.ZERO_DOLLAR;
        }
        return totalPreviousPaid;
    }

    public static Price getPaidPreviousItems(PeriodFilterBy filterBy, Long id) {
        Price totalPreviousPaid = Price.ZERO_DOLLAR;
        try {
            List<Account> allTransPayingPreviousItems = PersistenceManager.getObjectList(Account.class, RestaurantTakingsSummaryQueryHelper.getAccountsWithFinanceTransactionsForPreviousItemsQry(filterBy), new Object[]{id, id});
            for (Account account : allTransPayingPreviousItems) {
                Object[][] todaysSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForTodayQry(filterBy), new Object[]{account.getID(), id});
                Object[][] todaysTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForTodayQry(filterBy), new Object[]{account.getID(), id});
                Object[][] previousSalesResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountSalesForPreviousQry(filterBy), new Object[]{account.getID(), id});
                Object[][] previousTakingsResults = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getAccountTakingsForPreviousQry(filterBy), new Object[]{account.getID(), id});
                Price salesToday = new Price((Double)todaysSalesResults[0][0], 0.01);
                Price paidToday = new Price((Double)todaysTakingsResults[0][0], 0.01);
                Price salesPrevious = new Price((Double)previousSalesResults[0][0], 0.01);
                Price paidPrevious = new Price((Double)previousTakingsResults[0][0], 0.01);
                Price result = paidToday.multiply(salesPrevious.subtract(paidPrevious)).divide(salesToday.add(salesPrevious.subtract(paidPrevious)));
                totalPreviousPaid = totalPreviousPaid.add(result);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured while calculating previous paid items.", (Throwable)ex);
            return Price.ZERO_DOLLAR;
        }
        return totalPreviousPaid;
    }

    public static Price getPreviousSalesForAccountsByTradingDay(PeriodFilterBy filterBy, Long id) {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getPreviousSalesForAccountsQry(filterBy), new Object[]{id, id});
        Price prevSalesPrice = new Price((Double)result[0][0], 0.01);
        if (prevSalesPrice.lessThan(Price.ZERO_NO_ROUND)) {
            prevSalesPrice = Price.ZERO_DOLLAR;
        }
        return prevSalesPrice;
    }

    public static Price getFutureSalesForAccountsByTradingDay(Long tradingDayId) {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getFutureSalesForAccountsQry(PeriodFilterBy.TRADING_DAY), new Object[]{tradingDayId, tradingDayId});
        return new Price((Double)result[0][0], 0.01);
    }

    public static Price getPastPaymentsForAccountsByTradingDay(Long tradingDayId) {
        String query = "SELECT sum(amount_paid) as value from finance_transaction txn\r\nJOIN sales_account sa on sa.id = txn.fk_payoff_account\r\nWHERE txn.fk_finance_trading_day < sa.fk_finance_trading_day\r\nAND txn.system_state = 'ACTIVE'\r\nAND sa.fk_finance_trading_day = ?";
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query, new Object[]{tradingDayId});
        if (result[0][0] != null) {
            return new Price((Double)result[0][0], 0.01);
        }
        return Price.ZERO_DOLLAR;
    }

    public static Price getFuturePaymentsForAccountsByTradingDay(Long tradingDayId) {
        String query = "SELECT sum(amount_paid) as value\r\nfrom finance_transaction txn\r\nJOIN sales_account sa on sa.id = txn.fk_payoff_account\r\nWHERE txn.fk_finance_trading_day < sa.fk_finance_trading_day\r\nAND txn.system_state = 'ACTIVE'\r\nAND txn.fk_finance_trading_day = ?";
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query, new Object[]{tradingDayId});
        if (result[0][0] != null) {
            return new Price((Double)result[0][0], 0.01);
        }
        return Price.ZERO_DOLLAR;
    }

    public static enum PeriodFilterBy {
        SHIFT("fk_finance_shift"),
        TRADING_DAY("fk_finance_trading_day");

        private String queryConditionField;

        private PeriodFilterBy(String queryConditionField) {
            this.queryConditionField = queryConditionField;
        }

        public String getQueryConditionField() {
            return this.queryConditionField;
        }
    }
}

