/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.reports.Summary;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class SalesSummary
implements Serializable {
    private Shift shift;
    private Map<String, InventoryGroupSummary> groups;
    private Map<String, Summary> discounts;
    private Map<String, Summary> surcharges;
    private Price total = new Price(0.0, 0.0);
    private Price tax = new Price(0.0, 0.0);
    private SalesQuantity count = SalesQuantity.ZERO;

    public Price getTotal() {
        return this.total;
    }

    public Price getTax() {
        return this.tax;
    }

    public SalesQuantity getCount() {
        return this.count;
    }

    public String getShift() {
        return this.shift.getLabel();
    }

    public List<InventoryGroupSummary> getInventoryGroups() {
        return new ArrayList<InventoryGroupSummary>(this.groups.values());
    }

    public List<Summary> getDiscounts() {
        return new ArrayList<Summary>(this.discounts.values());
    }

    public List<Summary> getSurcharges() {
        return new ArrayList<Summary>(this.surcharges.values());
    }

    public Task getCalculateTask() {
        return new CalculateSalesSummaryTask();
    }

    public static SalesSummary getSummary() {
        return SalesSummary.getSummary(Terminal.getLocalHost().getShift());
    }

    public static SalesSummary getSummary(Shift shift) {
        SalesSummary summary = new SalesSummary();
        summary.shift = shift;
        return summary;
    }

    public static class SalesSummaryExecutable
    extends Executable<SalesSummary> {
        private final SalesSummary summary;

        public SalesSummaryExecutable(SalesSummary sum) {
            this.summary = sum;
        }

        @Override
        public SalesSummary execute() {
            this.summary.getCalculateTask().run();
            return this.summary;
        }
    }

    public static class InventoryGroupSummary
    extends Summary {
        private Map<String, Summary> items = new LinkedHashMap<String, Summary>();

        public InventoryGroupSummary(String name) {
            super(name);
        }

        private void addItem(String item, SalesQuantity num, Price price) {
            Summary summary = null;
            if (this.items.containsKey(item)) {
                summary = this.items.get(item);
            } else {
                summary = new Summary(item);
                this.items.put(item, summary);
            }
            summary.addCount(num);
            summary.addTotal(price);
            this.addCount(num);
            this.addTotal(price);
        }

        public List<Summary> getItems() {
            return new ArrayList<Summary>(this.items.values());
        }
    }

    private class CalculateSalesSummaryTask
    extends AbstractTask
    implements Serializable {
        private List<Account> accountsToCalculate;
        private boolean combosAsDiscounts = false;

        private CalculateSalesSummaryTask() {
        }

        @Override
        public int getTotalSubTasks() {
            if (this.accountsToCalculate == null) {
                this.getAccountsToCalculate();
            }
            return this.accountsToCalculate.size();
        }

        @Override
        public String getName() {
            return "Calculating sales summary for " + SalesSummary.this.shift.getLabel();
        }

        private void getAccountsToCalculate() {
            this.accountsToCalculate = Account.getAccounts(SalesSummary.this.shift);
        }

        @Override
        protected void performTask() throws Exception {
            this.combosAsDiscounts = SystemProperty.getInstance().isCombosAsDiscount();
            if (this.accountsToCalculate == null) {
                this.getAccountsToCalculate();
            }
            SalesSummary.this.groups = new LinkedHashMap();
            SalesSummary.this.discounts = new LinkedHashMap();
            SalesSummary.this.surcharges = new LinkedHashMap();
            HashSet<SalesPriceAdjustment> salesPriceAdjustmentSet = new HashSet<SalesPriceAdjustment>();
            for (Account account : this.accountsToCalculate) {
                SalesSummary.this.tax = SalesSummary.this.tax.add(account.getTax());
                for (SalesLineItem lineItem : account.getItems()) {
                    Summary paSummary;
                    for (SalesItem item : lineItem.getSalesItems()) {
                        for (SalesComponent comp : item.getComponentList()) {
                            this.analyseComponent(comp, salesPriceAdjustmentSet);
                        }
                    }
                    if (!this.combosAsDiscounts || !(lineItem instanceof SalesCombo) || (paSummary = ((SalesCombo)lineItem).getHelper().getPriceAdjustmentSummary()).getTotal().isZero()) continue;
                    this.addDiscount(paSummary);
                }
                salesPriceAdjustmentSet.clear();
                this.emitProgress();
            }
        }

        private void analyseComponent(SalesComponent comp, Set<SalesPriceAdjustment> salesPriceAdjustmentSet) {
            this.addSale(comp);
            InventoryPriceAdjustment comboPriceAdjustment = null;
            if (this.combosAsDiscounts && comp.getSalesItem().isComboItem()) {
                comboPriceAdjustment = comp.getSalesItem().getParentCombo().getHelper().getAppliedPriceAdjustment();
            }
            for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
                if (comboPriceAdjustment != null && comboPriceAdjustment.equals(usage.getSalesPriceAdjustment().getInventoryPriceAdjustment())) {
                    comboPriceAdjustment = null;
                    continue;
                }
                boolean salesAdjAlreadyPresent = salesPriceAdjustmentSet.contains(usage.getSalesPriceAdjustment());
                if (!salesAdjAlreadyPresent) {
                    salesPriceAdjustmentSet.add(usage.getSalesPriceAdjustment());
                }
                if (usage.getSalesPriceAdjustment().getDirection().equals(PriceAdjustmentDirection.SURCHARGE)) {
                    this.addSurcharge(usage.getSalesPriceAdjustment(), usage.getSavedTotalValue(), !salesAdjAlreadyPresent);
                    continue;
                }
                this.addDiscount(usage.getSalesPriceAdjustment().getLabel(), usage.getSavedTotalValue(), !salesAdjAlreadyPresent);
            }
        }

        private void addSale(SalesComponent comp) {
            SalesItem item = comp.getSalesItem();
            InventoryItem invItem = comp.getInventoryItem();
            String groupName = invItem.getMenuGroup().getLabel();
            InventoryGroupSummary groupSummary = null;
            if (SalesSummary.this.groups.containsKey(groupName)) {
                groupSummary = (InventoryGroupSummary)SalesSummary.this.groups.get(groupName);
            } else {
                groupSummary = new InventoryGroupSummary(groupName);
                SalesSummary.this.groups.put(groupName, groupSummary);
            }
            SalesQuantity qty = item.getQuantity();
            Price price = comp.getPrice().multiply(item.getQuantity());
            groupSummary.addItem(invItem.getLabel(), qty, price);
            SalesSummary.this.total = SalesSummary.this.total.add(price);
            SalesSummary.this.count = SalesSummary.this.count.add(qty);
        }

        private void addSurcharge(SalesPriceAdjustment salesPriceAdjustment, Price moneyGained, boolean incCount) {
            Summary summary = null;
            String newSurchargeName = this.extractSurchargeLabel(salesPriceAdjustment);
            if (SalesSummary.this.surcharges.containsKey(newSurchargeName)) {
                summary = (Summary)SalesSummary.this.surcharges.get(newSurchargeName);
            } else {
                summary = new Summary(newSurchargeName);
                SalesSummary.this.surcharges.put(newSurchargeName, summary);
            }
            if (incCount) {
                summary.addCount(SalesQuantity.ONE);
            }
            summary.addTotal(moneyGained.multiply(-1));
        }

        private String extractSurchargeLabel(SalesPriceAdjustment salesPriceAdjustment) {
            int dashIndex;
            String newSurchargeLabel;
            String value = newSurchargeLabel = salesPriceAdjustment.getLabel();
            if (PriceAdjustmentType.CUSTOM.equals(salesPriceAdjustment.getType())) {
                return "CUSTOM";
            }
            if (!StringUtils.isEmpty(value) && (dashIndex = value.indexOf(" - ")) != -1) {
                newSurchargeLabel = value.substring(0, dashIndex).trim();
            }
            return newSurchargeLabel;
        }

        private void addDiscount(String discountName, Price moneyLost, boolean incCount) {
            Summary summary = null;
            if (SalesSummary.this.discounts.containsKey(discountName)) {
                summary = (Summary)SalesSummary.this.discounts.get(discountName);
            } else {
                summary = new Summary(discountName);
                SalesSummary.this.discounts.put(discountName, summary);
            }
            if (incCount) {
                summary.addCount(SalesQuantity.ONE);
            }
            summary.addTotal(moneyLost.multiply(-1));
        }

        private void addDiscount(Summary summary) {
            if (!SalesSummary.this.discounts.containsKey(summary.getName())) {
                SalesSummary.this.discounts.put(summary.getName(), summary);
            } else {
                Summary existing = (Summary)SalesSummary.this.discounts.get(summary.getName());
                existing.add(summary);
            }
        }
    }
}

