/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@MappedSuperclass
@AccessType(value="property")
public class TotalsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Price total = new Price(0.0, 1.0E-5);
    private long count;
    private Price totalTax = new Price(0.0, 0.0);
    private Date totalDate;
    private Reference<DayPart> dayPart;
    private Reference<SalesLocation> location;

    public TotalsReport() {
        this.dayPart = this.createReference(TotalsReport.Properties.DAY_PART);
        this.location = this.createReference(TotalsReport.Properties.LOCATION);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="total")
    public Price getTotal() {
        if (this.total == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.total;
    }

    public void setTotal(Price price) {
        this.total = price;
    }

    @ManyToOne(targetEntity=SalesLocation.class)
    @JoinColumn(name="fk_config_sales_location")
    public SalesLocation getLocation() {
        return this.location.get();
    }

    protected void setLocation(SalesLocation loc) {
        this.location.set(loc);
    }

    @Column(name="total_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTotalDate() {
        return this.totalDate;
    }

    protected void setTotalDate(Date value) {
        this.totalDate = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="total_tax")
    public Price getTotalTax() {
        if (this.totalTax == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.totalTax;
    }

    public void setTotalTax(Price price) {
        this.totalTax = price;
    }

    @Transient
    public Double getTotalRawValue() {
        return this.getTotal().doubleValue();
    }

    @Column(name="count")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long newCount) {
        this.count = newCount;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_day_part")
    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    public void setDayPart(DayPart part) {
        this.dayPart.set(part);
    }

    @Transient
    public Price getTotalEx() {
        return this.getTotal() != null ? this.getTotal().subtract(this.getTotalTax()) : null;
    }

    @Transient
    public Price getAverageValue() {
        if (this.getCount() == 0L) {
            return Price.ZERO_DOLLAR;
        }
        return this.getTotal() != null ? this.getTotal().divide(this.getCount()) : null;
    }

    public static TotalsReport getAggregatedTotal(List<? extends TotalsReport> resultList) {
        TotalsReport total = new TotalsReport();
        for (TotalsReport totalsReport : resultList) {
            total.setTotal(total.getTotal().add(totalsReport.getTotal()));
            total.setTotalTax(total.getTotalTax().add(totalsReport.getTotalTax()));
            total.setCount(total.getCount() + totalsReport.getCount());
        }
        return total;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property COUNT;
        public PropertiedObject.Property<Price> TOTAL;
        public PropertiedObject.Property<Price> TOTAL_TAX;
        public PropertiedObject.Property<Date> TOTAL_DATE;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PropertiedObject.Property<SalesLocation> LOCATION;
        public PersistentObject.DerivedProperty<Price> TOTAL_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TotalsReport.class), "totalEx");
        public PersistentObject.DerivedProperty<Price> AVERAGE_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TotalsReport.class), "averageValue");
        public PersistentObject.DerivedProperty<Double> TOTAL_RAW_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TotalsReport.class), "totalRawValue");
    }
}

