/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.tax;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.finance.tax.TaxCodeI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="system_tax_code")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class TaxCode
extends PersistentObject
implements Displayable,
Saveable,
TaxCodeI {
    private static final String DEFAULT_SEPARATOR = ";";
    private static TaxCodeStringifer stringifier = new TaxCodeStringifer();
    public static final String GST = "GST";
    public static final String FREE = "FREE";
    public static final String NO_TAX = "NO_TAX";
    public static final String NON_CAPITAL_AQUISITION_GST = "NCA_GST";
    public static final String NON_CAPITAL_AQUISITION_FREE = "NCA_FRE";
    public static final Props Properties = new Props();
    private static LocalCacheListManager<TaxCode> defaultCodes = new LocalCacheListManager<TaxCode>(Query.createQueryList(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.DEFAULT_CODE, "1").orderBy(TaxCode.Properties.ID)));
    private static LocalCacheListManager<TaxCode> inventoryCodes = new LocalCacheListManager<TaxCode>(Query.createQueryList(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.ACCOUNTING, "0").active(TaxCode.class).orderBy(TaxCode.Properties.ID)));
    private static LocalCachedReference<TaxCode> gstCode = new LocalCachedReference<TaxCode>(new QueryReference<TaxCode>(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.CODE, "GST")));
    private static LocalCachedReference<TaxCode> freeCode = new LocalCachedReference<TaxCode>(new QueryReference<TaxCode>(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.CODE, "FREE")));
    private static LocalCachedReference<TaxCode> ntCode = new LocalCachedReference<TaxCode>(new QueryReference<TaxCode>(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.CODE, "NO_TAX")));
    private static LocalCachedReference<TaxCode> nonCapAqFree = new LocalCachedReference<TaxCode>(new QueryReference<TaxCode>(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.CODE, "NCA_FRE")));
    private static LocalCachedReference<TaxCode> nonCapAqGST = new LocalCachedReference<TaxCode>(new QueryReference<TaxCode>(TaxCode.class, Query.select(TaxCode.class).equals(TaxCode.Properties.CODE, "NCA_GST")));
    private static LocalCacheListManager<TaxCode> allTaxCodeListCache = new LocalCacheListManager<TaxCode>(Query.createQueryList(TaxCode.class, Query.select(TaxCode.class)));
    private String code;
    private double rate;
    private String description;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private boolean defaultCode;
    private boolean accounting = false;
    private int sequence = 1;
    private String extAccID;

    public static final List<TaxCode> getDefaultTaxCodes() {
        return defaultCodes.getList();
    }

    public static final TaxCode getGstCode() {
        return gstCode.get();
    }

    public static TaxCode getFreeCode() {
        return freeCode.get();
    }

    public static final TaxCode getNotTaxable() {
        return ntCode.get();
    }

    public static final TaxCode getNonCapAqGST() {
        return nonCapAqGST.get();
    }

    public static final TaxCode getNonCapAqFree() {
        return nonCapAqFree.get();
    }

    public static final List<TaxCode> getAllTaxCodes() {
        return allTaxCodeListCache.getList();
    }

    public static final List<TaxCode> getInventoryTaxCodes() {
        return inventoryCodes.getList();
    }

    @Deprecated
    public static double getGSTPercentage() {
        return TaxCode.getGstCode().getRate();
    }

    public static TaxCode getTaxCode(String code) {
        for (TaxCode taxCode : TaxCode.getAllTaxCodes()) {
            if (!taxCode.code.equals(code)) continue;
            return taxCode;
        }
        return null;
    }

    public TaxCode() {
    }

    public TaxCode(TaxCode copy) {
        this.code = copy.code;
        this.rate = copy.rate;
        this.description = copy.description;
        this.systemState = SystemState.ACTIVE_STATE;
        this.defaultCode = copy.defaultCode;
        this.accounting = copy.accounting;
        this.sequence = copy.sequence;
    }

    @Override
    @Column(name="code")
    public String getCode() {
        return this.code;
    }

    @Override
    @Transient
    public String getLabel() {
        return this.code != null ? this.code : "NO CODE";
    }

    @Basic(optional=false)
    @Column(name="default_code")
    public boolean isDefaultCode() {
        return this.defaultCode;
    }

    public void setDefaultCode(boolean value) {
        this.defaultCode = value;
    }

    @Override
    @Column(name="rate")
    public double getRate() {
        return this.rate;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public Price getTaxAmount(Price taxIncAmount) {
        double value = taxIncAmount.doubleValue();
        return new Price(value * (this.rate / (1.0 + this.rate)), 0.0);
    }

    public double getTaxAmount(double taxIncAmount) {
        return taxIncAmount * (this.rate / (1.0 + this.rate));
    }

    public void setRate(double newRate) {
        this.rate = newRate;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setCode(String newCode) {
        this.code = newCode;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel() != null ? this.getLabel() : "Tax Code : No Label, ID:" + this.getID();
    }

    public void setSystemState(SystemState value) {
        if (value == null) {
            throw new IllegalStateException("Cannot set the system state to a null value");
        }
        this.systemState = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Basic(optional=false)
    @Column(name="accounting")
    public boolean isAccounting() {
        return this.accounting;
    }

    protected void setAccounting(boolean value) {
        this.accounting = value;
    }

    @Override
    @Basic(optional=false)
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.setSystemState(SystemState.INACTIVE_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    protected void setID(Long value) {
        super.setID(value);
    }

    public static String convertToString(List<TaxCode> codes) {
        if (codes.isEmpty()) {
            return "";
        }
        if (codes.size() == 1) {
            return codes.get(0).getCode();
        }
        return StringUtils.mergeToStringWithSeparator(codes, DEFAULT_SEPARATOR, stringifier);
    }

    public static List<TaxCode> convertToList(String codedString, Collection<TaxCode> possibleCodes) {
        ArrayList<TaxCode> newList = new ArrayList<TaxCode>();
        for (String nextCode : StringUtils.splitToList(codedString, DEFAULT_SEPARATOR)) {
            TaxCode code = null;
            for (TaxCode nextPossible : possibleCodes) {
                if (!nextPossible.code.equals(nextCode)) continue;
                code = nextPossible;
            }
            if (code == null) continue;
            newList.add(code);
        }
        return newList;
    }

    @Column(name="ext_acc_id")
    public String getExtAccID() {
        return this.extAccID;
    }

    public void setExtAccID(String extAccID) {
        this.extAccID = extAccID;
    }

    public static void clearCaches() {
        defaultCodes.clearCache();
        inventoryCodes.clearCache();
        gstCode.clearCache();
        freeCode.clearCache();
        ntCode.clearCache();
        nonCapAqFree.clearCache();
        nonCapAqGST.clearCache();
        allTaxCodeListCache.clearCache();
    }

    static class TaxCodeStringifer
    implements Stringifier<TaxCode> {
        TaxCodeStringifer() {
        }

        @Override
        public String stringify(TaxCode object) {
            return object.getCode();
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> CODE;
        public PropertiedObject.Property RATE;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property DEFAULT_CODE;
        public PropertiedObject.Property ACCOUNTING;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> EXT_ACC_ID;
    }
}

