/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.timesheet;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.departments.Department;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_timesheet")
public class FinanceTimesheet
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Date timeIn;
    private Date timeOut;
    private Date timeInMod;
    private Date timeOutMod;
    private Reference<TradingDay> tradingDay;
    private Reference<User> user;
    private Reference<Department> department;
    private Price payRate;
    private Price totalPay;
    private long totalSeconds;

    public FinanceTimesheet() {
        this.tradingDay = this.createReference(FinanceTimesheet.Properties.TRADING_DAY);
        this.user = this.createReference(FinanceTimesheet.Properties.USER);
        this.department = this.createReference(FinanceTimesheet.Properties.DEPARTMENT);
        this.payRate = new Price(Price.ZERO_DOLLAR, 0.01);
        this.totalPay = Price.ZERO_DOLLAR;
    }

    public FinanceTimesheet(User value, Department dept) {
        this.tradingDay = this.createReference(FinanceTimesheet.Properties.TRADING_DAY);
        this.user = this.createReference(FinanceTimesheet.Properties.USER);
        this.department = this.createReference(FinanceTimesheet.Properties.DEPARTMENT);
        this.payRate = new Price(Price.ZERO_DOLLAR, 0.01);
        this.totalPay = Price.ZERO_DOLLAR;
        this.user.set(value);
        this.department.set(dept);
    }

    @Column(name="Time_IN")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeIn() {
        return this.timeIn;
    }

    public void setTimeIn(Date newTimeIn) {
        this.timeIn = newTimeIn;
    }

    @Column(name="Time_OUT")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(Date newTimeOut) {
        this.timeOut = newTimeOut;
    }

    @Column(name="mod_time_out")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeOutMod() {
        return this.timeOutMod;
    }

    public void setTimeOutMod(Date newTimeOut) {
        this.timeOutMod = newTimeOut;
    }

    @Column(name="mod_time_in")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeInMod() {
        return this.timeInMod;
    }

    public void setTimeInMod(Date newTimeIn) {
        this.timeInMod = newTimeIn;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay newTradingDay) {
        this.tradingDay.set(newTradingDay);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User newUser) {
        this.user.set(newUser);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_department")
    public Department getDepartment() {
        return this.department.get();
    }

    public void setDepartment(Department dept) {
        this.department.set(dept);
    }

    @Column(name="pay_rate")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPayRate() {
        return this.payRate;
    }

    public void setPayRate(Price payRate) {
        this.payRate = payRate;
        this.recalculateSeconds();
    }

    @Transient
    public Date getReportingTimeIn() {
        if (this.timeInMod != null) {
            return this.timeInMod;
        }
        return this.timeIn;
    }

    @Transient
    public Date getReportingTimeOut() {
        if (this.timeOutMod != null) {
            return this.timeOutMod;
        }
        return this.timeOut;
    }

    public void setReportingTimeIn(Date value) {
        this.timeInMod = value;
        this.recalculateSeconds();
    }

    public void setReportingTimeOut(Date value) {
        this.timeOutMod = value;
        this.recalculateSeconds();
    }

    @Transient
    public boolean isModified() {
        return this.timeOutMod != null || this.timeInMod != null;
    }

    @Transient
    public Boolean getAltered() {
        if (this.isModified()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Transient
    public String getPayrollId() {
        if (this.getUser() != null) {
            return this.getUser().getPayrollID();
        }
        return "";
    }

    @Transient
    public String getTimeInHourMin() {
        if (this.getReportingTimeIn() == null) {
            return "";
        }
        return DateTimeUtils.get24HFormat().format(this.getReportingTimeIn());
    }

    @Transient
    public String getTimeOutHourMin() {
        if (this.getReportingTimeOut() == null) {
            return "";
        }
        return DateTimeUtils.get24HFormat().format(this.getReportingTimeOut());
    }

    @Transient
    public Double getHours() {
        return (double)this.getTotalSeconds() / 3600.0;
    }

    @Transient
    public Long getTotalMillis() {
        return this.getTotalSeconds() * 1000L;
    }

    public void recalculateSeconds() {
        Date timeInCalc = this.timeIn;
        if (this.timeInMod != null) {
            timeInCalc = this.timeInMod;
        }
        Date timeOutCalc = this.timeOut;
        if (this.timeOutMod != null) {
            timeOutCalc = this.timeOutMod;
        }
        this.totalSeconds = timeInCalc == null || timeOutCalc == null ? 0L : (timeOutCalc.getTime() - timeInCalc.getTime()) / 1000L;
        if (this.payRate != null) {
            this.totalPay = this.payRate.multiply(this.getHours());
        }
    }

    @Column(name="total_seconds")
    public long getTotalSeconds() {
        return this.totalSeconds;
    }

    public void setTotalSeconds(long value) {
        this.totalSeconds = value;
    }

    @Column(name="total_pay")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getTotalPay() {
        return this.totalPay;
    }

    public void setTotalPay(Price value) {
        this.totalPay = value;
    }

    @Transient
    public Price getPayValue() {
        if (this.getPayRate() == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.getPayRate().multiply(this.getHours());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.recalculateSeconds();
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void setNewTimesheetVars() {
        TradingDay toSet;
        if (this.getTimeIn() == null) {
            this.setTimeIn(this.getTimeInMod());
        }
        this.setTradingDay((toSet = TradingDay.ReportDates.getFirstTradingDayForDate(this.getTimeInMod())) != null ? toSet : TradingDay.ReportDates.getLastTradingDay());
        if (this.getTimeOut() == null) {
            this.setTimeOut(this.getTimeOutMod());
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TIME_IN;
        public PropertiedObject.Property TIME_OUT;
        public PropertiedObject.Property TIME_IN_MOD;
        public PropertiedObject.Property TIME_OUT_MOD;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property TOTAL_SECONDS;
        public PropertiedObject.Property<Price> TOTAL_PAY;
        public PropertiedObject.Property<Department> DEPARTMENT;
        public PropertiedObject.Property PAY_RATE;
        public PersistentObject.DerivedProperty<Date> REPORTING_TIME_IN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "reportingTimeIn");
        public PersistentObject.DerivedProperty<Date> REPORTING_TIME_OUT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "reportingTimeOut");
        public PersistentObject.DerivedProperty<String> TIME_IN_HOUR_MIN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "timeInHourMin");
        public PersistentObject.DerivedProperty<String> TIME_OUT_HOUR_MIN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "timeOutHourMin");
        public PersistentObject.DerivedProperty<Boolean> MODIFIED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "modified");
        public PersistentObject.DerivedProperty<Boolean> ALTERED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "altered");
        public PersistentObject.DerivedProperty<String> PAYROLLID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "payrollId");
        public PersistentObject.DerivedProperty<Integer> TOTAL_MILLIS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "totalMillis");
        public PersistentObject.DerivedProperty<Double> HOURS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FinanceTimesheet.class), "hours");
    }
}

