/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.timesheet;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;

public class FinanceTimesheetHelper {
    private static final DateTimeUtils.ThreadLocalDateFormat dateFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy"));
    private static final DateTimeUtils.ThreadLocalDateFormat dayTimeFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("EEE HH:mm"));
    private static final DateTimeUtils.ThreadLocalDateFormat footerDateFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("dd-MM-yyyy"));
    private static final DateTimeUtils.ThreadLocalDateFormat footerTimeFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("h:mm a"));

    public static boolean printTimesheet(List<FinanceTimesheet> timesheetList, Date weekStartDate, User user) {
        String docketText = FinanceTimesheetHelper.getDocketText(timesheetList, weekStartDate, user);
        try {
            if (!docketText.isEmpty()) {
                DocketProcessor.printSimpleDocket(docketText);
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Problem printing timesheets.", (Throwable)ex);
        }
        return !docketText.isEmpty();
    }

    protected static String getDocketText(List<FinanceTimesheet> timesheetList, Date weekStartDate, User user) {
        if (!timesheetList.isEmpty()) {
            StringBuilder docketText = new StringBuilder();
            BusinessInfo businessInfo = BusinessInfo.getInstance();
            docketText.append(businessInfo.getLocation() + "\n");
            docketText.append("Timesheet Week Beginning: " + dateFormatter.getFormat().format(weekStartDate) + "\n");
            docketText.append(user.getName() + "\n");
            docketText.append("--- \n");
            docketText.append("Department  Clocked In  Clocked Out  Shift Time\n");
            docketText.append("--- \n");
            long totalTime = 0L;
            Assert.isFalse(timesheetList.isEmpty(), "Attempting to print Timesheet with no shifts for period.");
            if (!timesheetList.isEmpty()) {
                for (FinanceTimesheet timesheet : timesheetList) {
                    String deptName = timesheet.getDepartment().getName();
                    docketText.append(StringUtils.rightPad(StringUtils.shorten(deptName, 10), 12, ' '));
                    if (timesheet.getTimeOut() != null) {
                        long shiftDurationMillis = DateTimeUtils.getDifferenceInMillisecs(timesheet.getTimeIn(), timesheet.getTimeOut());
                        docketText.append(dayTimeFormatter.getFormat().format(timesheet.getTimeIn()) + "   " + dayTimeFormatter.getFormat().format(timesheet.getTimeOut()) + "    " + DateTimeUtils.getHoursMinutesSecondsForPeriod(shiftDurationMillis) + " \n");
                        totalTime += shiftDurationMillis;
                        continue;
                    }
                    docketText.append(dayTimeFormatter.getFormat().format(timesheet.getTimeIn()) + " \n");
                }
            }
            docketText.append("--- \n");
            docketText.append("Total Time: " + DateTimeUtils.getHoursMinutesSecondsForPeriod(totalTime) + " \n");
            docketText.append("--- \n");
            Date printTime = new Date();
            docketText.append(footerDateFormatter.getFormat().format(printTime) + " ");
            docketText.append(footerTimeFormatter.getFormat().format(printTime) + "\n");
            docketText.append("Powered By OrderMate www.ordermate.com.au\n");
            return docketText.toString();
        }
        return "";
    }

    public static boolean printTimesheetForWeekBeginning(Date weekStart, User user) {
        return FinanceTimesheetHelper.printTimesheet(FinanceTimesheetHelper.getUserTimeSheetList(weekStart, user), weekStart, user);
    }

    public static List<FinanceTimesheet> getUserTimeSheetList(Date weekBeginning, User user) {
        Calendar weekEnding = DateTimeUtils.getCalendar(weekBeginning);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date zeroAM = calendar.getTime();
        if (SystemProperty.getInstance().getChangeDayTime().equals(zeroAM)) {
            weekEnding.add(5, 7);
        } else {
            weekEnding.add(5, 6);
        }
        FinanceTimesheetSearcher searcher = new FinanceTimesheetSearcher();
        searcher.getTradingDayDateFilter().setStart(weekBeginning);
        searcher.getTradingDayDateFilter().setEnd(weekEnding.getTime());
        searcher.getUserFilter().setSearchValue(user);
        return searcher.search();
    }

    public static FinanceTimesheet createAndSaveFinanceTimesheet(Date timeIn, Date timeOut, TradingDay tradingDay, User user, Department dept) {
        FinanceTimesheet timesheet = new FinanceTimesheet();
        timesheet.setDepartment(dept);
        timesheet.setTimeIn(timeIn);
        timesheet.setTimeOut(timeOut);
        timesheet.setUser(user);
        timesheet.setTradingDay(tradingDay);
        timesheet.setPayRate(FinanceTimesheetHelper.getPayrateForUser(user, dept));
        timesheet.save();
        return timesheet;
    }

    private static Price getPayrateForUser(User user, Department dept) {
        Payrate payrate = user.getPayrate(dept);
        return payrate == null ? Price.ZERO_DOLLAR : payrate.getPayRate();
    }
}

